/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.services;

import java.util.ArrayList;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.jasig.cas.services.AbstractRegisteredService;
import org.jasig.cas.services.RegisteredService;
import org.jasig.cas.services.ServiceRegistryDao;

public final class InMemoryServiceRegistryDaoImpl
implements ServiceRegistryDao {
    @NotNull
    private List<RegisteredService> registeredServices = new ArrayList<RegisteredService>();

    @Override
    public boolean delete(RegisteredService registeredService) {
        return this.registeredServices.remove(registeredService);
    }

    @Override
    public RegisteredService findServiceById(long id) {
        for (RegisteredService r : this.registeredServices) {
            if (r.getId() != id) continue;
            return r;
        }
        return null;
    }

    @Override
    public List<RegisteredService> load() {
        return this.registeredServices;
    }

    @Override
    public RegisteredService save(RegisteredService registeredService) {
        if (registeredService.getId() == -9223372036854775807L) {
            ((AbstractRegisteredService)registeredService).setId(this.findHighestId() + 1L);
        }
        this.registeredServices.remove(registeredService);
        this.registeredServices.add(registeredService);
        return registeredService;
    }

    public void setRegisteredServices(List<RegisteredService> registeredServices) {
        this.registeredServices = registeredServices;
    }

    private long findHighestId() {
        long id = 0L;
        for (RegisteredService r : this.registeredServices) {
            if (r.getId() <= id) continue;
            id = r.getId();
        }
        return id;
    }
}

