/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.authentication.principal;

import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.jasig.cas.authentication.principal.AbstractWebApplicationService;
import org.jasig.cas.authentication.principal.Response;
import org.springframework.util.StringUtils;

public final class SimpleWebApplicationServiceImpl
extends AbstractWebApplicationService {
    private static final String CONST_PARAM_SERVICE = "service";
    private static final String CONST_PARAM_TARGET_SERVICE = "targetService";
    private static final String CONST_PARAM_TICKET = "ticket";
    private static final String CONST_PARAM_METHOD = "method";
    private final Response.ResponseType responseType;
    private static final long serialVersionUID = 8334068957483758042L;

    public SimpleWebApplicationServiceImpl(String id) {
        this(id, id, null, null);
    }

    private SimpleWebApplicationServiceImpl(String id, String originalUrl, String artifactId, Response.ResponseType responseType) {
        super(id, originalUrl, artifactId);
        this.responseType = responseType;
    }

    public static SimpleWebApplicationServiceImpl createServiceFrom(HttpServletRequest request) {
        String serviceToUse;
        String targetService = request.getParameter(CONST_PARAM_TARGET_SERVICE);
        String method = request.getParameter(CONST_PARAM_METHOD);
        String string = serviceToUse = StringUtils.hasText((String)targetService) ? targetService : request.getParameter(CONST_PARAM_SERVICE);
        if (!StringUtils.hasText((String)serviceToUse)) {
            return null;
        }
        String id = SimpleWebApplicationServiceImpl.cleanupUrl(serviceToUse);
        String artifactId = request.getParameter(CONST_PARAM_TICKET);
        return new SimpleWebApplicationServiceImpl(id, serviceToUse, artifactId, "POST".equals(method) ? Response.ResponseType.POST : Response.ResponseType.REDIRECT);
    }

    @Override
    public Response getResponse(String ticketId) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        if (StringUtils.hasText((String)ticketId)) {
            parameters.put(CONST_PARAM_TICKET, ticketId);
        }
        if (Response.ResponseType.POST == this.responseType) {
            return Response.getPostResponse(this.getOriginalUrl(), parameters);
        }
        return Response.getRedirectResponse(this.getOriginalUrl(), parameters);
    }
}

