/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.services;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorType;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.Lob;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.hibernate.annotations.IndexColumn;
import org.jasig.cas.services.LogoutType;
import org.jasig.cas.services.RegisteredService;
import org.jasig.cas.services.RegisteredServiceAttributeFilter;

@Entity
@Inheritance
@DiscriminatorColumn(name="expression_type", length=15, discriminatorType=DiscriminatorType.STRING, columnDefinition="VARCHAR(15) DEFAULT 'ant'")
@Table(name="RegisteredServiceImpl")
public abstract class AbstractRegisteredService
implements RegisteredService,
Comparable<RegisteredService>,
Serializable {
    private static final long serialVersionUID = 7645279151115635245L;
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    private long id = -9223372036854775807L;
    @ElementCollection(targetClass=String.class, fetch=FetchType.EAGER)
    @JoinTable(name="rs_attributes", joinColumns={@JoinColumn(name="RegisteredServiceImpl_id")})
    @Column(name="a_name", nullable=false)
    @IndexColumn(name="a_id")
    private List<String> allowedAttributes = new ArrayList<String>();
    @Column(length=255, updatable=true, insertable=true, nullable=false)
    private String description;
    @Column(length=255, updatable=true, insertable=true, nullable=false)
    protected String serviceId;
    @Column(length=255, updatable=true, insertable=true, nullable=false)
    private String name;
    @Column(length=255, updatable=true, insertable=true, nullable=true)
    private String theme;
    private boolean allowedToProxy = false;
    private boolean enabled = true;
    private boolean ssoEnabled = true;
    private boolean anonymousAccess = false;
    private boolean ignoreAttributes = false;
    @Column(name="evaluation_order", nullable=false)
    private int evaluationOrder;
    @Transient
    private RegisteredServiceAttributeFilter attributeFilter = null;
    @Column(name="username_attr", nullable=true, length=256)
    private String usernameAttribute = null;
    @Transient
    private LogoutType logoutType = LogoutType.BACK_CHANNEL;
    @Lob
    @Column(name="required_handlers")
    private HashSet<String> requiredHandlers = new HashSet();

    @Override
    public boolean isAnonymousAccess() {
        return this.anonymousAccess;
    }

    public void setAnonymousAccess(boolean anonymousAccess) {
        this.anonymousAccess = anonymousAccess;
    }

    @Override
    public List<String> getAllowedAttributes() {
        return this.allowedAttributes;
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getServiceId() {
        return this.serviceId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getTheme() {
        return this.theme;
    }

    @Override
    public boolean isAllowedToProxy() {
        return this.allowedToProxy;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public boolean isSsoEnabled() {
        return this.ssoEnabled;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractRegisteredService)) {
            return false;
        }
        AbstractRegisteredService that = (AbstractRegisteredService)o;
        return new EqualsBuilder().append(this.allowedToProxy, that.allowedToProxy).append(this.anonymousAccess, that.anonymousAccess).append(this.enabled, that.enabled).append(this.evaluationOrder, that.evaluationOrder).append(this.ignoreAttributes, that.ignoreAttributes).append(this.ssoEnabled, that.ssoEnabled).append(this.allowedAttributes, that.allowedAttributes).append((Object)this.description, (Object)that.description).append((Object)this.name, (Object)that.name).append((Object)this.serviceId, (Object)that.serviceId).append((Object)this.theme, (Object)that.theme).append((Object)this.usernameAttribute, (Object)that.usernameAttribute).append((Object)this.logoutType, (Object)that.logoutType).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(7, 31).append(this.allowedAttributes).append((Object)this.description).append((Object)this.serviceId).append((Object)this.name).append((Object)this.theme).append(this.enabled).append(this.ssoEnabled).append(this.anonymousAccess).append(this.ignoreAttributes).append(this.evaluationOrder).append((Object)this.usernameAttribute).append((Object)this.logoutType).toHashCode();
    }

    public void setAllowedAttributes(List<String> allowedAttributes) {
        this.allowedAttributes = allowedAttributes == null ? new ArrayList<String>() : allowedAttributes;
    }

    public void setAllowedToProxy(boolean allowedToProxy) {
        this.allowedToProxy = allowedToProxy;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public abstract void setServiceId(String var1);

    public void setId(long id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setSsoEnabled(boolean ssoEnabled) {
        this.ssoEnabled = ssoEnabled;
    }

    public void setTheme(String theme) {
        this.theme = theme;
    }

    @Override
    public boolean isIgnoreAttributes() {
        return this.ignoreAttributes;
    }

    public void setIgnoreAttributes(boolean ignoreAttributes) {
        this.ignoreAttributes = ignoreAttributes;
    }

    @Override
    public void setEvaluationOrder(int evaluationOrder) {
        this.evaluationOrder = evaluationOrder;
    }

    @Override
    public int getEvaluationOrder() {
        return this.evaluationOrder;
    }

    @Override
    public String getUsernameAttribute() {
        return this.usernameAttribute;
    }

    public void setUsernameAttribute(String username) {
        this.usernameAttribute = StringUtils.isBlank((String)username) ? null : username;
    }

    @Override
    public final LogoutType getLogoutType() {
        return this.logoutType;
    }

    public final void setLogoutType(LogoutType logoutType) {
        this.logoutType = logoutType;
    }

    @Override
    public RegisteredService clone() throws CloneNotSupportedException {
        AbstractRegisteredService clone = this.newInstance();
        clone.copyFrom(this);
        return clone;
    }

    public void copyFrom(RegisteredService source) {
        this.setId(source.getId());
        this.setAllowedAttributes(new ArrayList<String>(source.getAllowedAttributes()));
        this.setAllowedToProxy(source.isAllowedToProxy());
        this.setDescription(source.getDescription());
        this.setEnabled(source.isEnabled());
        this.setName(source.getName());
        this.setServiceId(source.getServiceId());
        this.setSsoEnabled(source.isSsoEnabled());
        this.setTheme(source.getTheme());
        this.setAnonymousAccess(source.isAnonymousAccess());
        this.setIgnoreAttributes(source.isIgnoreAttributes());
        this.setEvaluationOrder(source.getEvaluationOrder());
        this.setUsernameAttribute(source.getUsernameAttribute());
        this.setLogoutType(source.getLogoutType());
    }

    @Override
    public int compareTo(RegisteredService other) {
        return new CompareToBuilder().append(this.getEvaluationOrder(), other.getEvaluationOrder()).append((Object)this.getName().toLowerCase(), (Object)other.getName().toLowerCase()).append((Object)this.getServiceId(), (Object)other.getServiceId()).toComparison();
    }

    public String toString() {
        ToStringBuilder toStringBuilder = new ToStringBuilder(null, ToStringStyle.SHORT_PREFIX_STYLE);
        toStringBuilder.append("id", this.id);
        toStringBuilder.append("name", (Object)this.name);
        toStringBuilder.append("description", (Object)this.description);
        toStringBuilder.append("serviceId", (Object)this.serviceId);
        toStringBuilder.append("usernameAttribute", (Object)this.usernameAttribute);
        toStringBuilder.append("attributes", this.allowedAttributes.toArray());
        return toStringBuilder.toString();
    }

    protected abstract AbstractRegisteredService newInstance();

    public final void setAttributeFilter(RegisteredServiceAttributeFilter filter) {
        this.attributeFilter = filter;
    }

    @Override
    public RegisteredServiceAttributeFilter getAttributeFilter() {
        return this.attributeFilter;
    }

    @Override
    public Set<String> getRequiredHandlers() {
        if (this.requiredHandlers == null) {
            this.requiredHandlers = new HashSet();
        }
        return this.requiredHandlers;
    }

    public void setRequiredHandlers(Set<String> handlers) {
        this.getRequiredHandlers().clear();
        if (handlers == null) {
            return;
        }
        for (String handler : handlers) {
            this.getRequiredHandlers().add(handler);
        }
    }
}

