/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas;

import com.github.inspektr.audit.annotation.Audit;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.jasig.cas.CentralAuthenticationService;
import org.jasig.cas.aspect.LogAspect;
import org.jasig.cas.authentication.AcceptAnyAuthenticationPolicyFactory;
import org.jasig.cas.authentication.Authentication;
import org.jasig.cas.authentication.AuthenticationBuilder;
import org.jasig.cas.authentication.AuthenticationException;
import org.jasig.cas.authentication.AuthenticationManager;
import org.jasig.cas.authentication.ContextualAuthenticationPolicy;
import org.jasig.cas.authentication.ContextualAuthenticationPolicyFactory;
import org.jasig.cas.authentication.Credential;
import org.jasig.cas.authentication.MixedPrincipalException;
import org.jasig.cas.authentication.principal.PersistentIdGenerator;
import org.jasig.cas.authentication.principal.Principal;
import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.authentication.principal.ShibbolethCompatiblePersistentIdGenerator;
import org.jasig.cas.authentication.principal.SimplePrincipal;
import org.jasig.cas.logout.LogoutManager;
import org.jasig.cas.logout.LogoutRequest;
import org.jasig.cas.services.RegisteredService;
import org.jasig.cas.services.RegisteredServiceAttributeFilter;
import org.jasig.cas.services.ServiceContext;
import org.jasig.cas.services.ServicesManager;
import org.jasig.cas.services.UnauthorizedProxyingException;
import org.jasig.cas.services.UnauthorizedServiceException;
import org.jasig.cas.services.UnauthorizedSsoServiceException;
import org.jasig.cas.services.support.RegisteredServiceDefaultAttributeFilter;
import org.jasig.cas.ticket.ExpirationPolicy;
import org.jasig.cas.ticket.InvalidTicketException;
import org.jasig.cas.ticket.ServiceTicket;
import org.jasig.cas.ticket.TicketException;
import org.jasig.cas.ticket.TicketGrantingTicket;
import org.jasig.cas.ticket.TicketGrantingTicketImpl;
import org.jasig.cas.ticket.TicketValidationException;
import org.jasig.cas.ticket.UnsatisfiedAuthenticationPolicyException;
import org.jasig.cas.ticket.registry.TicketRegistry;
import org.jasig.cas.util.UniqueTicketIdGenerator;
import org.jasig.cas.validation.Assertion;
import org.jasig.cas.validation.ImmutableAssertion;
import org.perf4j.aop.Profiled;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

public final class CentralAuthenticationServiceImpl
implements CentralAuthenticationService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @NotNull
    private final TicketRegistry ticketRegistry;
    @NotNull
    private final TicketRegistry serviceTicketRegistry;
    @NotNull
    private final AuthenticationManager authenticationManager;
    @NotNull
    private final UniqueTicketIdGenerator ticketGrantingTicketUniqueTicketIdGenerator;
    @NotNull
    private final Map<String, UniqueTicketIdGenerator> uniqueTicketIdGeneratorsForService;
    @NotNull
    private final ServicesManager servicesManager;
    @NotNull
    private final LogoutManager logoutManager;
    @NotNull
    private ExpirationPolicy ticketGrantingTicketExpirationPolicy;
    @NotNull
    private ExpirationPolicy serviceTicketExpirationPolicy;
    @NotNull
    private PersistentIdGenerator persistentIdGenerator = new ShibbolethCompatiblePersistentIdGenerator();
    private RegisteredServiceAttributeFilter defaultAttributeFilter = new RegisteredServiceDefaultAttributeFilter();
    @NotNull
    private ContextualAuthenticationPolicyFactory<ServiceContext> serviceContextAuthenticationPolicyFactory = new AcceptAnyAuthenticationPolicyFactory();
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;

    public CentralAuthenticationServiceImpl(TicketRegistry ticketRegistry, TicketRegistry serviceTicketRegistry, AuthenticationManager authenticationManager, UniqueTicketIdGenerator ticketGrantingTicketUniqueTicketIdGenerator, Map<String, UniqueTicketIdGenerator> uniqueTicketIdGeneratorsForService, ExpirationPolicy ticketGrantingTicketExpirationPolicy, ExpirationPolicy serviceTicketExpirationPolicy, ServicesManager servicesManager, LogoutManager logoutManager) {
        this.ticketRegistry = ticketRegistry;
        this.serviceTicketRegistry = serviceTicketRegistry == null ? ticketRegistry : serviceTicketRegistry;
        this.authenticationManager = authenticationManager;
        this.ticketGrantingTicketUniqueTicketIdGenerator = ticketGrantingTicketUniqueTicketIdGenerator;
        this.uniqueTicketIdGeneratorsForService = uniqueTicketIdGeneratorsForService;
        this.ticketGrantingTicketExpirationPolicy = ticketGrantingTicketExpirationPolicy;
        this.serviceTicketExpirationPolicy = serviceTicketExpirationPolicy;
        this.servicesManager = servicesManager;
        this.logoutManager = logoutManager;
    }

    @Override
    @Audit(action="TICKET_GRANTING_TICKET_DESTROYED", actionResolverName="DESTROY_TICKET_GRANTING_TICKET_RESOLVER", resourceResolverName="DESTROY_TICKET_GRANTING_TICKET_RESOURCE_RESOLVER")
    @Profiled(tag="DESTROY_TICKET_GRANTING_TICKET", logFailuresSeparately=false)
    @Transactional(readOnly=false)
    public List<LogoutRequest> destroyTicketGrantingTicket(String ticketGrantingTicketId) {
        String string = ticketGrantingTicketId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)string);
        return (List)CentralAuthenticationServiceImpl.destroyTicketGrantingTicket_aroundBody1$advice(this, string, joinPoint, LogAspect.aspectOf(), (ProceedingJoinPoint)joinPoint);
    }

    @Override
    @Audit(action="SERVICE_TICKET", actionResolverName="GRANT_SERVICE_TICKET_RESOLVER", resourceResolverName="GRANT_SERVICE_TICKET_RESOURCE_RESOLVER")
    @Profiled(tag="GRANT_SERVICE_TICKET", logFailuresSeparately=false)
    @Transactional(readOnly=false)
    public String grantServiceTicket(String ticketGrantingTicketId, Service service, Credential ... credentials) throws AuthenticationException, TicketException {
        String string = ticketGrantingTicketId;
        Service service2 = service;
        Credential[] credentialArray = credentials;
        Object[] objectArray = new Object[]{string, service2, credentialArray};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object[])objectArray);
        return (String)CentralAuthenticationServiceImpl.grantServiceTicket_aroundBody3$advice(this, string, service2, credentialArray, joinPoint, LogAspect.aspectOf(), (ProceedingJoinPoint)joinPoint);
    }

    @Override
    @Audit(action="SERVICE_TICKET", actionResolverName="GRANT_SERVICE_TICKET_RESOLVER", resourceResolverName="GRANT_SERVICE_TICKET_RESOURCE_RESOLVER")
    @Profiled(tag="GRANT_SERVICE_TICKET", logFailuresSeparately=false)
    @Transactional(readOnly=false)
    public String grantServiceTicket(String ticketGrantingTicketId, Service service) throws TicketException {
        String string = ticketGrantingTicketId;
        Service service2 = service;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)string, (Object)service2);
        return (String)CentralAuthenticationServiceImpl.grantServiceTicket_aroundBody5$advice(this, string, service2, joinPoint, LogAspect.aspectOf(), (ProceedingJoinPoint)joinPoint);
    }

    @Override
    @Audit(action="PROXY_GRANTING_TICKET", actionResolverName="GRANT_PROXY_GRANTING_TICKET_RESOLVER", resourceResolverName="GRANT_PROXY_GRANTING_TICKET_RESOURCE_RESOLVER")
    @Profiled(tag="GRANT_PROXY_GRANTING_TICKET", logFailuresSeparately=false)
    @Transactional(readOnly=false)
    public String delegateTicketGrantingTicket(String serviceTicketId, Credential ... credentials) throws AuthenticationException, TicketException {
        String string = serviceTicketId;
        Credential[] credentialArray = credentials;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)string, (Object)credentialArray);
        return (String)CentralAuthenticationServiceImpl.delegateTicketGrantingTicket_aroundBody7$advice(this, string, credentialArray, joinPoint, LogAspect.aspectOf(), (ProceedingJoinPoint)joinPoint);
    }

    @Override
    @Audit(action="SERVICE_TICKET_VALIDATE", actionResolverName="VALIDATE_SERVICE_TICKET_RESOLVER", resourceResolverName="VALIDATE_SERVICE_TICKET_RESOURCE_RESOLVER")
    @Profiled(tag="VALIDATE_SERVICE_TICKET", logFailuresSeparately=false)
    @Transactional(readOnly=false)
    public Assertion validateServiceTicket(String serviceTicketId, Service service) throws TicketException {
        String string = serviceTicketId;
        Service service2 = service;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)string, (Object)service2);
        return (Assertion)CentralAuthenticationServiceImpl.validateServiceTicket_aroundBody9$advice(this, string, service2, joinPoint, LogAspect.aspectOf(), (ProceedingJoinPoint)joinPoint);
    }

    private String determinePrincipalIdForRegisteredService(Principal principal, RegisteredService registeredService, ServiceTicket serviceTicket) {
        String principalId = null;
        String serviceUsernameAttribute = registeredService.getUsernameAttribute();
        if (registeredService.isAnonymousAccess()) {
            principalId = this.persistentIdGenerator.generate(principal, serviceTicket.getService());
        } else if (StringUtils.isBlank((String)serviceUsernameAttribute)) {
            principalId = principal.getId();
        } else if (principal.getAttributes().containsKey(serviceUsernameAttribute)) {
            principalId = principal.getAttributes().get(serviceUsernameAttribute).toString();
        } else {
            principalId = principal.getId();
            Object[] errorLogParameters = new Object[]{principalId, registeredService.getUsernameAttribute(), principal.getAttributes(), registeredService.getServiceId(), principalId};
            this.logger.warn("Principal [{}] did not have attribute [{}] among attributes [{}] so CAS cannot provide on the validation response the user attribute the registered service [{}] expects. CAS will instead return the default username attribute [{}]", errorLogParameters);
        }
        this.logger.debug("Principal id to return for service [{}] is [{}]. The default principal id is [{}].", new Object[]{registeredService.getName(), principal.getId(), principalId});
        return principalId;
    }

    @Override
    @Audit(action="TICKET_GRANTING_TICKET", actionResolverName="CREATE_TICKET_GRANTING_TICKET_RESOLVER", resourceResolverName="CREATE_TICKET_GRANTING_TICKET_RESOURCE_RESOLVER")
    @Profiled(tag="CREATE_TICKET_GRANTING_TICKET", logFailuresSeparately=false)
    @Transactional(readOnly=false)
    public String createTicketGrantingTicket(Credential ... credentials) throws AuthenticationException, TicketException {
        Credential[] credentialArray = credentials;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)credentialArray);
        return (String)CentralAuthenticationServiceImpl.createTicketGrantingTicket_aroundBody11$advice(this, credentialArray, joinPoint, LogAspect.aspectOf(), (ProceedingJoinPoint)joinPoint);
    }

    public void setPersistentIdGenerator(PersistentIdGenerator persistentIdGenerator) {
        this.persistentIdGenerator = persistentIdGenerator;
    }

    public void setServiceContextAuthenticationPolicyFactory(ContextualAuthenticationPolicyFactory<ServiceContext> policy) {
        this.serviceContextAuthenticationPolicyFactory = policy;
    }

    public void setTicketGrantingTicketExpirationPolicy(ExpirationPolicy ticketGrantingTicketExpirationPolicy) {
        this.ticketGrantingTicketExpirationPolicy = ticketGrantingTicketExpirationPolicy;
    }

    public void setServiceTicketExpirationPolicy(ExpirationPolicy serviceTicketExpirationPolicy) {
        this.serviceTicketExpirationPolicy = serviceTicketExpirationPolicy;
    }

    private Authentication getAuthenticationSatisfiedByPolicy(TicketGrantingTicket ticket, ServiceContext context) throws TicketException {
        ContextualAuthenticationPolicy<ServiceContext> policy = this.serviceContextAuthenticationPolicyFactory.createPolicy(context);
        if (policy.isSatisfiedBy(ticket.getAuthentication())) {
            return ticket.getAuthentication();
        }
        for (Authentication auth : ticket.getSupplementalAuthentications()) {
            if (!policy.isSatisfiedBy(auth)) continue;
            return auth;
        }
        throw new UnsatisfiedAuthenticationPolicyException(policy);
    }

    private void verifyRegisteredServiceProperties(RegisteredService registeredService, Service service) {
        if (registeredService == null) {
            String msg = String.format("ServiceManagement: Unauthorized Service Access. Service [%s] is not found in service registry.", service.getId());
            this.logger.warn(msg);
            throw new UnauthorizedServiceException("screen.service.error.message", msg);
        }
        if (!registeredService.isEnabled()) {
            String msg = String.format("ServiceManagement: Unauthorized Service Access. Service %s] is not enabled in service registry.", service.getId());
            this.logger.warn(msg);
            throw new UnauthorizedServiceException("screen.service.error.message", msg);
        }
    }

    static {
        CentralAuthenticationServiceImpl.ajc$preClinit();
    }

    private static final /* synthetic */ List destroyTicketGrantingTicket_aroundBody0(CentralAuthenticationServiceImpl ajc$this, String ticketGrantingTicketId, JoinPoint joinPoint) {
        Assert.notNull((Object)ticketGrantingTicketId);
        ajc$this.logger.debug("Removing ticket [{}] from registry.", (Object)ticketGrantingTicketId);
        TicketGrantingTicket ticket = (TicketGrantingTicket)ajc$this.ticketRegistry.getTicket(ticketGrantingTicketId, TicketGrantingTicket.class);
        if (ticket == null) {
            ajc$this.logger.debug("TicketGrantingTicket [{}] cannot be found in the ticket registry.", (Object)ticketGrantingTicketId);
            return Collections.emptyList();
        }
        ajc$this.logger.debug("Ticket found. Processing logout requests and then deleting the ticket...");
        List<LogoutRequest> logoutRequests = ajc$this.logoutManager.performLogout(ticket);
        ajc$this.ticketRegistry.deleteTicket(ticketGrantingTicketId);
        return logoutRequests;
    }

    private static final /* synthetic */ Object destroyTicketGrantingTicket_aroundBody1$advice(CentralAuthenticationServiceImpl ajc$this, String ticketGrantingTicketId, JoinPoint thisJoinPoint, LogAspect ajc$aspectInstance, ProceedingJoinPoint proceedingJoinPoint) {
        Object object;
        Object returnVal = null;
        Logger logger = LogAspect.ajc$inlineAccessMethod$org_jasig_cas_aspect_LogAspect$org_jasig_cas_aspect_LogAspect$getLog(ajc$aspectInstance, (JoinPoint)proceedingJoinPoint);
        String methodName = proceedingJoinPoint.getSignature().getName();
        try {
            if (logger.isTraceEnabled()) {
                Object[] args = proceedingJoinPoint.getArgs();
                String arguments = args == null || args.length == 0 ? "" : Arrays.deepToString(args);
                logger.trace("Entering method [{}] with arguments [{}]", (Object)methodName, (Object)arguments);
            }
            ProceedingJoinPoint proceedingJoinPoint2 = proceedingJoinPoint;
            object = returnVal = CentralAuthenticationServiceImpl.destroyTicketGrantingTicket_aroundBody0(ajc$this, ticketGrantingTicketId, (JoinPoint)proceedingJoinPoint2);
            logger.trace("Leaving method [{}] with return value [{}].", (Object)methodName, (Object)(returnVal != null ? returnVal.toString() : "null"));
        }
        catch (Throwable throwable) {
            logger.trace("Leaving method [{}] with return value [{}].", (Object)methodName, (Object)(returnVal != null ? returnVal.toString() : "null"));
            throw throwable;
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final /* synthetic */ String grantServiceTicket_aroundBody2(CentralAuthenticationServiceImpl ajc$this, String ticketGrantingTicketId, Service service, Credential[] credentials, JoinPoint joinPoint) {
        Assert.notNull((Object)ticketGrantingTicketId, (String)"ticketGrantingticketId cannot be null");
        Assert.notNull((Object)service, (String)"service cannot be null");
        TicketGrantingTicket ticketGrantingTicket = (TicketGrantingTicket)ajc$this.ticketRegistry.getTicket(ticketGrantingTicketId, TicketGrantingTicket.class);
        if (ticketGrantingTicket == null) {
            ajc$this.logger.debug("TicketGrantingTicket [{}] cannot be found in the ticket registry.", (Object)ticketGrantingTicketId);
            throw new InvalidTicketException(ticketGrantingTicketId);
        }
        TicketGrantingTicket ticketGrantingTicket2 = ticketGrantingTicket;
        synchronized (ticketGrantingTicket2) {
            if (ticketGrantingTicket.isExpired()) {
                ajc$this.ticketRegistry.deleteTicket(ticketGrantingTicketId);
                ajc$this.logger.debug("TicketGrantingTicket[{}] has expired and is now deleted from the ticket registry.", (Object)ticketGrantingTicketId);
                throw new InvalidTicketException(ticketGrantingTicketId);
            }
        }
        RegisteredService registeredService = ajc$this.servicesManager.findServiceBy(service);
        ajc$this.verifyRegisteredServiceProperties(registeredService, service);
        if (!registeredService.isSsoEnabled() && credentials == null && ticketGrantingTicket.getCountOfUses() > 0) {
            ajc$this.logger.warn("ServiceManagement: Service [{}] is not allowed to use SSO.", (Object)service.getId());
            throw new UnauthorizedSsoServiceException();
        }
        List<Authentication> authns = ticketGrantingTicket.getChainedAuthentications();
        if (authns.size() > 1 && !registeredService.isAllowedToProxy()) {
            String message = String.format("ServiceManagement: Proxy attempt by service [%s] (registered service [%s]) is not allowed.", service.getId(), registeredService.toString());
            ajc$this.logger.warn(message);
            throw new UnauthorizedProxyingException(message);
        }
        if (credentials != null) {
            Authentication current = ajc$this.authenticationManager.authenticate(credentials);
            Authentication original = ticketGrantingTicket.getAuthentication();
            if (!current.getPrincipal().equals(original.getPrincipal())) {
                throw new MixedPrincipalException(current, current.getPrincipal(), original.getPrincipal());
            }
            ticketGrantingTicket.getSupplementalAuthentications().add(current);
        }
        ajc$this.getAuthenticationSatisfiedByPolicy(ticketGrantingTicket, new ServiceContext(service, registeredService));
        String uniqueTicketIdGenKey = service.getClass().getName();
        if (!ajc$this.uniqueTicketIdGeneratorsForService.containsKey(uniqueTicketIdGenKey)) {
            ajc$this.logger.warn("Cannot create service ticket because the key [{}] for service [{}] is not linked to a ticket id generator", (Object)uniqueTicketIdGenKey, (Object)service.getId());
            throw new UnauthorizedSsoServiceException();
        }
        UniqueTicketIdGenerator serviceTicketUniqueTicketIdGenerator = ajc$this.uniqueTicketIdGeneratorsForService.get(uniqueTicketIdGenKey);
        String generatedServiceTicketId = serviceTicketUniqueTicketIdGenerator.getNewTicketId("ST");
        ajc$this.logger.debug("Generated service ticket id [{}] for ticket granting ticket [{}]", (Object)generatedServiceTicketId, (Object)ticketGrantingTicket.getId());
        ServiceTicket serviceTicket = ticketGrantingTicket.grantServiceTicket(generatedServiceTicketId, service, ajc$this.serviceTicketExpirationPolicy, credentials != null);
        ajc$this.serviceTicketRegistry.addTicket(serviceTicket);
        if (ajc$this.logger.isInfoEnabled()) {
            List<Authentication> authentications = serviceTicket.getGrantingTicket().getChainedAuthentications();
            String principalId = authentications.get(authentications.size() - 1).getPrincipal().getId();
            String type = authentications.size() == 1 ? "service" : "proxy";
            ajc$this.logger.info(String.format("Granted %s ticket [%s] for service [%s] for user [%s]", type, serviceTicket.getId(), service.getId(), principalId));
        }
        return serviceTicket.getId();
    }

    private static final /* synthetic */ Object grantServiceTicket_aroundBody3$advice(CentralAuthenticationServiceImpl ajc$this, String ticketGrantingTicketId, Service service, Credential[] credentials, JoinPoint thisJoinPoint, LogAspect ajc$aspectInstance, ProceedingJoinPoint proceedingJoinPoint) {
        Object object;
        Object returnVal = null;
        Logger logger = LogAspect.ajc$inlineAccessMethod$org_jasig_cas_aspect_LogAspect$org_jasig_cas_aspect_LogAspect$getLog(ajc$aspectInstance, (JoinPoint)proceedingJoinPoint);
        String methodName = proceedingJoinPoint.getSignature().getName();
        try {
            if (logger.isTraceEnabled()) {
                Object[] args = proceedingJoinPoint.getArgs();
                String arguments = args == null || args.length == 0 ? "" : Arrays.deepToString(args);
                logger.trace("Entering method [{}] with arguments [{}]", (Object)methodName, (Object)arguments);
            }
            ProceedingJoinPoint proceedingJoinPoint2 = proceedingJoinPoint;
            object = returnVal = CentralAuthenticationServiceImpl.grantServiceTicket_aroundBody2(ajc$this, ticketGrantingTicketId, service, credentials, (JoinPoint)proceedingJoinPoint2);
            logger.trace("Leaving method [{}] with return value [{}].", (Object)methodName, (Object)(returnVal != null ? returnVal.toString() : "null"));
        }
        catch (Throwable throwable) {
            logger.trace("Leaving method [{}] with return value [{}].", (Object)methodName, (Object)(returnVal != null ? returnVal.toString() : "null"));
            throw throwable;
        }
        return object;
    }

    private static final /* synthetic */ String grantServiceTicket_aroundBody4(CentralAuthenticationServiceImpl ajc$this, String ticketGrantingTicketId, Service service, JoinPoint joinPoint) {
        try {
            return ajc$this.grantServiceTicket(ticketGrantingTicketId, service, null);
        }
        catch (AuthenticationException e) {
            throw new IllegalStateException("Unexpected authentication exception", e);
        }
    }

    private static final /* synthetic */ Object grantServiceTicket_aroundBody5$advice(CentralAuthenticationServiceImpl ajc$this, String ticketGrantingTicketId, Service service, JoinPoint thisJoinPoint, LogAspect ajc$aspectInstance, ProceedingJoinPoint proceedingJoinPoint) {
        Object object;
        Object returnVal = null;
        Logger logger = LogAspect.ajc$inlineAccessMethod$org_jasig_cas_aspect_LogAspect$org_jasig_cas_aspect_LogAspect$getLog(ajc$aspectInstance, (JoinPoint)proceedingJoinPoint);
        String methodName = proceedingJoinPoint.getSignature().getName();
        try {
            if (logger.isTraceEnabled()) {
                Object[] args = proceedingJoinPoint.getArgs();
                String arguments = args == null || args.length == 0 ? "" : Arrays.deepToString(args);
                logger.trace("Entering method [{}] with arguments [{}]", (Object)methodName, (Object)arguments);
            }
            ProceedingJoinPoint proceedingJoinPoint2 = proceedingJoinPoint;
            object = returnVal = CentralAuthenticationServiceImpl.grantServiceTicket_aroundBody4(ajc$this, ticketGrantingTicketId, service, (JoinPoint)proceedingJoinPoint2);
            logger.trace("Leaving method [{}] with return value [{}].", (Object)methodName, (Object)(returnVal != null ? returnVal.toString() : "null"));
        }
        catch (Throwable throwable) {
            logger.trace("Leaving method [{}] with return value [{}].", (Object)methodName, (Object)(returnVal != null ? returnVal.toString() : "null"));
            throw throwable;
        }
        return object;
    }

    private static final /* synthetic */ String delegateTicketGrantingTicket_aroundBody6(CentralAuthenticationServiceImpl ajc$this, String serviceTicketId, Credential[] credentials, JoinPoint joinPoint) {
        Assert.notNull((Object)serviceTicketId, (String)"serviceTicketId cannot be null");
        Assert.notNull((Object)credentials, (String)"credentials cannot be null");
        ServiceTicket serviceTicket = (ServiceTicket)ajc$this.serviceTicketRegistry.getTicket(serviceTicketId, ServiceTicket.class);
        if (serviceTicket == null || serviceTicket.isExpired()) {
            ajc$this.logger.debug("ServiceTicket [{}] has expired or cannot be found in the ticket registry", (Object)serviceTicketId);
            throw new InvalidTicketException(serviceTicketId);
        }
        RegisteredService registeredService = ajc$this.servicesManager.findServiceBy(serviceTicket.getService());
        ajc$this.verifyRegisteredServiceProperties(registeredService, serviceTicket.getService());
        if (!registeredService.isAllowedToProxy()) {
            ajc$this.logger.warn("ServiceManagement: Service [{}] attempted to proxy, but is not allowed.", (Object)serviceTicket.getService().getId());
            throw new UnauthorizedProxyingException();
        }
        Authentication authentication = ajc$this.authenticationManager.authenticate(credentials);
        TicketGrantingTicket ticketGrantingTicket = serviceTicket.grantTicketGrantingTicket(ajc$this.ticketGrantingTicketUniqueTicketIdGenerator.getNewTicketId("TGT"), authentication, ajc$this.ticketGrantingTicketExpirationPolicy);
        ajc$this.ticketRegistry.addTicket(ticketGrantingTicket);
        return ticketGrantingTicket.getId();
    }

    private static final /* synthetic */ Object delegateTicketGrantingTicket_aroundBody7$advice(CentralAuthenticationServiceImpl ajc$this, String serviceTicketId, Credential[] credentials, JoinPoint thisJoinPoint, LogAspect ajc$aspectInstance, ProceedingJoinPoint proceedingJoinPoint) {
        Object object;
        Object returnVal = null;
        Logger logger = LogAspect.ajc$inlineAccessMethod$org_jasig_cas_aspect_LogAspect$org_jasig_cas_aspect_LogAspect$getLog(ajc$aspectInstance, (JoinPoint)proceedingJoinPoint);
        String methodName = proceedingJoinPoint.getSignature().getName();
        try {
            if (logger.isTraceEnabled()) {
                Object[] args = proceedingJoinPoint.getArgs();
                String arguments = args == null || args.length == 0 ? "" : Arrays.deepToString(args);
                logger.trace("Entering method [{}] with arguments [{}]", (Object)methodName, (Object)arguments);
            }
            ProceedingJoinPoint proceedingJoinPoint2 = proceedingJoinPoint;
            object = returnVal = CentralAuthenticationServiceImpl.delegateTicketGrantingTicket_aroundBody6(ajc$this, serviceTicketId, credentials, (JoinPoint)proceedingJoinPoint2);
            logger.trace("Leaving method [{}] with return value [{}].", (Object)methodName, (Object)(returnVal != null ? returnVal.toString() : "null"));
        }
        catch (Throwable throwable) {
            logger.trace("Leaving method [{}] with return value [{}].", (Object)methodName, (Object)(returnVal != null ? returnVal.toString() : "null"));
            throw throwable;
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final /* synthetic */ Assertion validateServiceTicket_aroundBody8(CentralAuthenticationServiceImpl ajc$this, String serviceTicketId, Service service, JoinPoint joinPoint) {
        Assert.notNull((Object)serviceTicketId, (String)"serviceTicketId cannot be null");
        Assert.notNull((Object)service, (String)"service cannot be null");
        ServiceTicket serviceTicket = (ServiceTicket)ajc$this.serviceTicketRegistry.getTicket(serviceTicketId, ServiceTicket.class);
        if (serviceTicket == null) {
            ajc$this.logger.info("ServiceTicket [{}] does not exist.", (Object)serviceTicketId);
            throw new InvalidTicketException(serviceTicketId);
        }
        RegisteredService registeredService = ajc$this.servicesManager.findServiceBy(service);
        ajc$this.verifyRegisteredServiceProperties(registeredService, serviceTicket.getService());
        try {
            ServiceTicket serviceTicket2 = serviceTicket;
            synchronized (serviceTicket2) {
                if (serviceTicket.isExpired()) {
                    ajc$this.logger.info("ServiceTicket [{}] has expired.", (Object)serviceTicketId);
                    throw new InvalidTicketException(serviceTicketId);
                }
                if (!serviceTicket.isValidFor(service)) {
                    ajc$this.logger.error("ServiceTicket [{}] with service [{}] does not match supplied service [{}]", new Object[]{serviceTicketId, serviceTicket.getService().getId(), service});
                    throw new TicketValidationException(serviceTicket.getService());
                }
            }
            TicketGrantingTicket root = serviceTicket.getGrantingTicket().getRoot();
            Authentication authentication = ajc$this.getAuthenticationSatisfiedByPolicy(root, new ServiceContext(serviceTicket.getService(), registeredService));
            Principal principal = authentication.getPrincipal();
            Map<String, Object> attributesToRelease = ajc$this.defaultAttributeFilter.filter(principal.getId(), principal.getAttributes(), registeredService);
            if (registeredService.getAttributeFilter() != null) {
                attributesToRelease = registeredService.getAttributeFilter().filter(principal.getId(), attributesToRelease, registeredService);
            }
            String principalId = ajc$this.determinePrincipalIdForRegisteredService(principal, registeredService, serviceTicket);
            SimplePrincipal modifiedPrincipal = new SimplePrincipal(principalId, attributesToRelease);
            AuthenticationBuilder builder = AuthenticationBuilder.newInstance(authentication);
            builder.setPrincipal(modifiedPrincipal);
            ImmutableAssertion immutableAssertion = new ImmutableAssertion(builder.build(), serviceTicket.getGrantingTicket().getChainedAuthentications(), serviceTicket.getService(), serviceTicket.isFromNewLogin());
            return immutableAssertion;
        }
        finally {
            if (serviceTicket.isExpired()) {
                ajc$this.serviceTicketRegistry.deleteTicket(serviceTicketId);
            }
        }
    }

    private static final /* synthetic */ Object validateServiceTicket_aroundBody9$advice(CentralAuthenticationServiceImpl ajc$this, String serviceTicketId, Service service, JoinPoint thisJoinPoint, LogAspect ajc$aspectInstance, ProceedingJoinPoint proceedingJoinPoint) {
        Object object;
        Object returnVal = null;
        Logger logger = LogAspect.ajc$inlineAccessMethod$org_jasig_cas_aspect_LogAspect$org_jasig_cas_aspect_LogAspect$getLog(ajc$aspectInstance, (JoinPoint)proceedingJoinPoint);
        String methodName = proceedingJoinPoint.getSignature().getName();
        try {
            if (logger.isTraceEnabled()) {
                Object[] args = proceedingJoinPoint.getArgs();
                String arguments = args == null || args.length == 0 ? "" : Arrays.deepToString(args);
                logger.trace("Entering method [{}] with arguments [{}]", (Object)methodName, (Object)arguments);
            }
            ProceedingJoinPoint proceedingJoinPoint2 = proceedingJoinPoint;
            object = returnVal = CentralAuthenticationServiceImpl.validateServiceTicket_aroundBody8(ajc$this, serviceTicketId, service, (JoinPoint)proceedingJoinPoint2);
            logger.trace("Leaving method [{}] with return value [{}].", (Object)methodName, (Object)(returnVal != null ? returnVal.toString() : "null"));
        }
        catch (Throwable throwable) {
            logger.trace("Leaving method [{}] with return value [{}].", (Object)methodName, (Object)(returnVal != null ? returnVal.toString() : "null"));
            throw throwable;
        }
        return object;
    }

    private static final /* synthetic */ String createTicketGrantingTicket_aroundBody10(CentralAuthenticationServiceImpl ajc$this, Credential[] credentials, JoinPoint joinPoint) {
        Assert.notNull((Object)credentials, (String)"credentials cannot be null");
        Authentication authentication = ajc$this.authenticationManager.authenticate(credentials);
        TicketGrantingTicketImpl ticketGrantingTicket = new TicketGrantingTicketImpl(ajc$this.ticketGrantingTicketUniqueTicketIdGenerator.getNewTicketId("TGT"), authentication, ajc$this.ticketGrantingTicketExpirationPolicy);
        ajc$this.ticketRegistry.addTicket(ticketGrantingTicket);
        return ticketGrantingTicket.getId();
    }

    private static final /* synthetic */ Object createTicketGrantingTicket_aroundBody11$advice(CentralAuthenticationServiceImpl ajc$this, Credential[] credentials, JoinPoint thisJoinPoint, LogAspect ajc$aspectInstance, ProceedingJoinPoint proceedingJoinPoint) {
        Object object;
        Object returnVal = null;
        Logger logger = LogAspect.ajc$inlineAccessMethod$org_jasig_cas_aspect_LogAspect$org_jasig_cas_aspect_LogAspect$getLog(ajc$aspectInstance, (JoinPoint)proceedingJoinPoint);
        String methodName = proceedingJoinPoint.getSignature().getName();
        try {
            if (logger.isTraceEnabled()) {
                Object[] args = proceedingJoinPoint.getArgs();
                String arguments = args == null || args.length == 0 ? "" : Arrays.deepToString(args);
                logger.trace("Entering method [{}] with arguments [{}]", (Object)methodName, (Object)arguments);
            }
            ProceedingJoinPoint proceedingJoinPoint2 = proceedingJoinPoint;
            object = returnVal = CentralAuthenticationServiceImpl.createTicketGrantingTicket_aroundBody10(ajc$this, credentials, (JoinPoint)proceedingJoinPoint2);
            logger.trace("Leaving method [{}] with return value [{}].", (Object)methodName, (Object)(returnVal != null ? returnVal.toString() : "null"));
        }
        catch (Throwable throwable) {
            logger.trace("Leaving method [{}] with return value [{}].", (Object)methodName, (Object)(returnVal != null ? returnVal.toString() : "null"));
            throw throwable;
        }
        return object;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("CentralAuthenticationServiceImpl.java", CentralAuthenticationServiceImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "destroyTicketGrantingTicket", "org.jasig.cas.CentralAuthenticationServiceImpl", "java.lang.String", "ticketGrantingTicketId", "", "java.util.List"), 214);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("81", "grantServiceTicket", "org.jasig.cas.CentralAuthenticationServiceImpl", "java.lang.String:org.jasig.cas.authentication.principal.Service:[Lorg.jasig.cas.authentication.Credential;", "ticketGrantingTicketId:service:credentials", "org.jasig.cas.authentication.AuthenticationException:org.jasig.cas.ticket.TicketException", "java.lang.String"), 242);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "grantServiceTicket", "org.jasig.cas.CentralAuthenticationServiceImpl", "java.lang.String:org.jasig.cas.authentication.principal.Service", "ticketGrantingTicketId:service", "org.jasig.cas.ticket.TicketException", "java.lang.String"), 341);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("81", "delegateTicketGrantingTicket", "org.jasig.cas.CentralAuthenticationServiceImpl", "java.lang.String:[Lorg.jasig.cas.authentication.Credential;", "serviceTicketId:credentials", "org.jasig.cas.authentication.AuthenticationException:org.jasig.cas.ticket.TicketException", "java.lang.String"), 360);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "validateServiceTicket", "org.jasig.cas.CentralAuthenticationServiceImpl", "java.lang.String:org.jasig.cas.authentication.principal.Service", "serviceTicketId:service", "org.jasig.cas.ticket.TicketException", "org.jasig.cas.validation.Assertion"), 406);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("81", "createTicketGrantingTicket", "org.jasig.cas.CentralAuthenticationServiceImpl", "[Lorg.jasig.cas.authentication.Credential;", "credentials", "org.jasig.cas.authentication.AuthenticationException:org.jasig.cas.ticket.TicketException", "java.lang.String"), 526);
    }
}

