/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.authentication.handler.support;

import java.security.GeneralSecurityException;
import java.util.Arrays;
import javax.security.auth.login.FailedLoginException;
import javax.validation.constraints.NotNull;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.jasig.cas.aspect.LogAspect;
import org.jasig.cas.authentication.AbstractAuthenticationHandler;
import org.jasig.cas.authentication.AuthenticationHandler;
import org.jasig.cas.authentication.Credential;
import org.jasig.cas.authentication.CredentialMetaData;
import org.jasig.cas.authentication.HandlerResult;
import org.jasig.cas.authentication.HttpBasedServiceCredential;
import org.jasig.cas.authentication.principal.SimplePrincipal;
import org.jasig.cas.util.HttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HttpBasedServiceCredentialsAuthenticationHandler
extends AbstractAuthenticationHandler {
    private static final String PROTOCOL_HTTPS = "https";
    private boolean requireSecure = true;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @NotNull
    private HttpClient httpClient;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    @Override
    public HandlerResult authenticate(Credential credential) throws GeneralSecurityException {
        Credential credential2 = credential;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)credential2);
        return (HandlerResult)HttpBasedServiceCredentialsAuthenticationHandler.authenticate_aroundBody1$advice(this, credential2, joinPoint, LogAspect.aspectOf(), (ProceedingJoinPoint)joinPoint);
    }

    @Override
    public boolean supports(Credential credential) {
        Credential credential2 = credential;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)credential2);
        return Conversions.booleanValue((Object)HttpBasedServiceCredentialsAuthenticationHandler.supports_aroundBody3$advice(this, credential2, joinPoint, LogAspect.aspectOf(), (ProceedingJoinPoint)joinPoint));
    }

    public void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public void setRequireSecure(boolean requireSecure) {
        this.requireSecure = requireSecure;
    }

    static {
        HttpBasedServiceCredentialsAuthenticationHandler.ajc$preClinit();
    }

    private static final /* synthetic */ HandlerResult authenticate_aroundBody0(HttpBasedServiceCredentialsAuthenticationHandler ajc$this, Credential credential, JoinPoint joinPoint) {
        HttpBasedServiceCredential httpCredential = (HttpBasedServiceCredential)credential;
        if (ajc$this.requireSecure && !httpCredential.getCallbackUrl().getProtocol().equals(PROTOCOL_HTTPS)) {
            ajc$this.logger.debug("Authentication failed because url was not secure.");
            throw new FailedLoginException(httpCredential.getCallbackUrl() + " is not an HTTPS endpoint as required.");
        }
        ajc$this.logger.debug("Attempting to authenticate {}", (Object)httpCredential);
        if (!ajc$this.httpClient.isValidEndPoint(httpCredential.getCallbackUrl())) {
            throw new FailedLoginException(httpCredential.getCallbackUrl() + " sent an unacceptable response status code");
        }
        return new HandlerResult((AuthenticationHandler)ajc$this, (CredentialMetaData)httpCredential, new SimplePrincipal(httpCredential.getId()));
    }

    private static final /* synthetic */ Object authenticate_aroundBody1$advice(HttpBasedServiceCredentialsAuthenticationHandler ajc$this, Credential credential, JoinPoint thisJoinPoint, LogAspect ajc$aspectInstance, ProceedingJoinPoint proceedingJoinPoint) {
        Object object;
        Object returnVal = null;
        Logger logger = LogAspect.ajc$inlineAccessMethod$org_jasig_cas_aspect_LogAspect$org_jasig_cas_aspect_LogAspect$getLog(ajc$aspectInstance, (JoinPoint)proceedingJoinPoint);
        String methodName = proceedingJoinPoint.getSignature().getName();
        try {
            if (logger.isTraceEnabled()) {
                Object[] args = proceedingJoinPoint.getArgs();
                String arguments = args == null || args.length == 0 ? "" : Arrays.deepToString(args);
                logger.trace("Entering method [{}] with arguments [{}]", (Object)methodName, (Object)arguments);
            }
            ProceedingJoinPoint proceedingJoinPoint2 = proceedingJoinPoint;
            object = returnVal = HttpBasedServiceCredentialsAuthenticationHandler.authenticate_aroundBody0(ajc$this, credential, (JoinPoint)proceedingJoinPoint2);
            logger.trace("Leaving method [{}] with return value [{}].", (Object)methodName, (Object)(returnVal != null ? returnVal.toString() : "null"));
        }
        catch (Throwable throwable) {
            logger.trace("Leaving method [{}] with return value [{}].", (Object)methodName, (Object)(returnVal != null ? returnVal.toString() : "null"));
            throw throwable;
        }
        return object;
    }

    private static final /* synthetic */ boolean supports_aroundBody2(HttpBasedServiceCredentialsAuthenticationHandler ajc$this, Credential credential, JoinPoint joinPoint) {
        return credential instanceof HttpBasedServiceCredential;
    }

    private static final /* synthetic */ Object supports_aroundBody3$advice(HttpBasedServiceCredentialsAuthenticationHandler ajc$this, Credential credential, JoinPoint thisJoinPoint, LogAspect ajc$aspectInstance, ProceedingJoinPoint proceedingJoinPoint) {
        Object object;
        Object returnVal = null;
        Logger logger = LogAspect.ajc$inlineAccessMethod$org_jasig_cas_aspect_LogAspect$org_jasig_cas_aspect_LogAspect$getLog(ajc$aspectInstance, (JoinPoint)proceedingJoinPoint);
        String methodName = proceedingJoinPoint.getSignature().getName();
        try {
            if (logger.isTraceEnabled()) {
                Object[] args = proceedingJoinPoint.getArgs();
                String arguments = args == null || args.length == 0 ? "" : Arrays.deepToString(args);
                logger.trace("Entering method [{}] with arguments [{}]", (Object)methodName, (Object)arguments);
            }
            ProceedingJoinPoint proceedingJoinPoint2 = proceedingJoinPoint;
            object = returnVal = Conversions.booleanObject((boolean)HttpBasedServiceCredentialsAuthenticationHandler.supports_aroundBody2(ajc$this, credential, (JoinPoint)proceedingJoinPoint2));
            logger.trace("Leaving method [{}] with return value [{}].", (Object)methodName, (Object)(returnVal != null ? returnVal.toString() : "null"));
        }
        catch (Throwable throwable) {
            logger.trace("Leaving method [{}] with return value [{}].", (Object)methodName, (Object)(returnVal != null ? returnVal.toString() : "null"));
            throw throwable;
        }
        return object;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("HttpBasedServiceCredentialsAuthenticationHandler.java", HttpBasedServiceCredentialsAuthenticationHandler.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "authenticate", "org.jasig.cas.authentication.handler.support.HttpBasedServiceCredentialsAuthenticationHandler", "org.jasig.cas.authentication.Credential", "credential", "java.security.GeneralSecurityException", "org.jasig.cas.authentication.HandlerResult"), 63);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supports", "org.jasig.cas.authentication.handler.support.HttpBasedServiceCredentialsAuthenticationHandler", "org.jasig.cas.authentication.Credential", "credential", "", "boolean"), 81);
    }
}

