/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas;

import java.util.Map;
import org.jasig.cas.AbstractCentralAuthenticationServiceTest;
import org.jasig.cas.CentralAuthenticationService;
import org.jasig.cas.CentralAuthenticationServiceImpl;
import org.jasig.cas.MockExpireUpdateTicketLogoutManager;
import org.jasig.cas.MockOnlyOneTicketRegistry;
import org.jasig.cas.TestUtils;
import org.jasig.cas.authentication.Authentication;
import org.jasig.cas.authentication.AuthenticationException;
import org.jasig.cas.authentication.Credential;
import org.jasig.cas.authentication.MixedPrincipalException;
import org.jasig.cas.authentication.UsernamePasswordCredential;
import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.logout.LogoutManager;
import org.jasig.cas.services.UnauthorizedServiceException;
import org.jasig.cas.services.UnauthorizedServiceForPrincipalException;
import org.jasig.cas.services.UnauthorizedSsoServiceException;
import org.jasig.cas.ticket.ExpirationPolicy;
import org.jasig.cas.ticket.ServiceTicket;
import org.jasig.cas.ticket.Ticket;
import org.jasig.cas.ticket.TicketCreationException;
import org.jasig.cas.ticket.TicketException;
import org.jasig.cas.ticket.TicketGrantingTicket;
import org.jasig.cas.ticket.TicketGrantingTicketImpl;
import org.jasig.cas.ticket.TicketState;
import org.jasig.cas.ticket.registry.TicketRegistry;
import org.jasig.cas.ticket.support.MultiTimeUseOrTimeoutExpirationPolicy;
import org.jasig.cas.ticket.support.NeverExpiresExpirationPolicy;
import org.jasig.cas.validation.Assertion;
import org.jasig.cas.validation.Cas20WithoutProxyingValidationSpecification;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class CentralAuthenticationServiceImplTests
extends AbstractCentralAuthenticationServiceTest {
    @Test(expected=AuthenticationException.class)
    public void verifyBadCredentialsOnTicketGrantingTicketCreation() throws Exception {
        this.getCentralAuthenticationService().createTicketGrantingTicket(new Credential[]{TestUtils.getCredentialsWithDifferentUsernameAndPassword()});
    }

    @Test
    public void verifyGoodCredentialsOnTicketGrantingTicketCreation() throws Exception {
        try {
            Assert.assertNotNull((Object)this.getCentralAuthenticationService().createTicketGrantingTicket(new Credential[]{TestUtils.getCredentialsWithSameUsernameAndPassword()}));
        }
        catch (TicketException e) {
            Assert.fail((String)"Exception not expected.");
        }
    }

    @Test
    public void verifyDestroyTicketGrantingTicketWithNonExistantTicket() {
        this.getCentralAuthenticationService().destroyTicketGrantingTicket("test");
    }

    @Test
    public void verifyDestroyTicketGrantingTicketWithValidTicket() throws Exception {
        TicketGrantingTicket ticketId = this.getCentralAuthenticationService().createTicketGrantingTicket(new Credential[]{TestUtils.getCredentialsWithSameUsernameAndPassword()});
        this.getCentralAuthenticationService().destroyTicketGrantingTicket(ticketId.getId());
    }

    @Test(expected=TicketCreationException.class)
    public void disallowNullCredentionalsWhenCreatingTicketGrantingTicket() throws Exception {
        TicketGrantingTicket ticketId = this.getCentralAuthenticationService().createTicketGrantingTicket(null);
    }

    @Test(expected=TicketCreationException.class)
    public void disallowNullCredentionalsArrayWhenCreatingTicketGrantingTicket() throws Exception {
        TicketGrantingTicket ticketId = this.getCentralAuthenticationService().createTicketGrantingTicket(new Credential[]{null, null});
    }

    @Test(expected=ClassCastException.class)
    public void verifyDestroyTicketGrantingTicketWithInvalidTicket() throws Exception {
        TicketGrantingTicket ticketId = this.getCentralAuthenticationService().createTicketGrantingTicket(new Credential[]{TestUtils.getCredentialsWithSameUsernameAndPassword()});
        ServiceTicket serviceTicketId = this.getCentralAuthenticationService().grantServiceTicket(ticketId.getId(), TestUtils.getService());
        this.getCentralAuthenticationService().destroyTicketGrantingTicket(serviceTicketId.getId());
    }

    @Test
    public void checkGrantingOfServiceTicketUsingDefaultTicketIdGen() throws Exception {
        Service mockService = (Service)Mockito.mock(Service.class);
        Mockito.when((Object)mockService.getId()).thenReturn((Object)"testDefault");
        TicketGrantingTicket ticketId = this.getCentralAuthenticationService().createTicketGrantingTicket(new Credential[]{TestUtils.getCredentialsWithSameUsernameAndPassword()});
        ServiceTicket serviceTicketId = this.getCentralAuthenticationService().grantServiceTicket(ticketId.getId(), mockService);
        Assert.assertNotNull((Object)serviceTicketId);
    }

    @Test
    public void verifyGrantServiceTicketWithValidTicketGrantingTicket() throws Exception {
        TicketGrantingTicket ticketId = this.getCentralAuthenticationService().createTicketGrantingTicket(new Credential[]{TestUtils.getCredentialsWithSameUsernameAndPassword()});
        this.getCentralAuthenticationService().grantServiceTicket(ticketId.getId(), TestUtils.getService());
    }

    @Test(expected=UnauthorizedServiceForPrincipalException.class)
    public void verifyGrantServiceTicketFailsAuthzRule() throws Exception {
        TicketGrantingTicket ticketId = this.getCentralAuthenticationService().createTicketGrantingTicket(new Credential[]{TestUtils.getCredentialsWithSameUsernameAndPassword()});
        this.getCentralAuthenticationService().grantServiceTicket(ticketId.getId(), TestUtils.getService("TestServiceAttributeForAuthzFails"));
    }

    @Test
    public void verifyGrantServiceTicketPassesAuthzRule() throws Exception {
        TicketGrantingTicket ticketId = this.getCentralAuthenticationService().createTicketGrantingTicket(new Credential[]{TestUtils.getCredentialsWithSameUsernameAndPassword()});
        this.getCentralAuthenticationService().grantServiceTicket(ticketId.getId(), TestUtils.getService("TestServiceAttributeForAuthzPasses"));
    }

    @Test
    public void verifyGrantProxyTicketWithValidTicketGrantingTicket() throws Exception {
        TicketGrantingTicket ticketId = this.getCentralAuthenticationService().createTicketGrantingTicket(new Credential[]{TestUtils.getCredentialsWithSameUsernameAndPassword()});
        ServiceTicket serviceTicketId = this.getCentralAuthenticationService().grantServiceTicket(ticketId.getId(), TestUtils.getService());
        TicketGrantingTicket pgt = this.getCentralAuthenticationService().delegateTicketGrantingTicket(serviceTicketId.getId(), new Credential[]{TestUtils.getHttpBasedServiceCredentials()});
        ServiceTicket pt = this.getCentralAuthenticationService().grantServiceTicket(pgt.getId(), TestUtils.getService(), new Credential[0]);
        Assert.assertTrue((boolean)pt.getId().startsWith("PT"));
    }

    @Test(expected=TicketException.class)
    public void verifyGrantServiceTicketWithInvalidTicketGrantingTicket() throws Exception {
        TicketGrantingTicket ticketId = this.getCentralAuthenticationService().createTicketGrantingTicket(new Credential[]{TestUtils.getCredentialsWithSameUsernameAndPassword()});
        this.getCentralAuthenticationService().destroyTicketGrantingTicket(ticketId.getId());
        this.getCentralAuthenticationService().grantServiceTicket(ticketId.getId(), TestUtils.getService());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=TicketException.class)
    public void verifyGrantServiceTicketWithExpiredTicketGrantingTicket() throws Exception {
        ((CentralAuthenticationServiceImpl)this.getCentralAuthenticationService()).setTicketGrantingTicketExpirationPolicy(new ExpirationPolicy(){
            private static final long serialVersionUID = 1L;

            public boolean isExpired(TicketState ticket) {
                return true;
            }
        });
        TicketGrantingTicket ticketId = this.getCentralAuthenticationService().createTicketGrantingTicket(new Credential[]{TestUtils.getCredentialsWithSameUsernameAndPassword()});
        try {
            this.getCentralAuthenticationService().grantServiceTicket(ticketId.getId(), TestUtils.getService());
        }
        finally {
            ((CentralAuthenticationServiceImpl)this.getCentralAuthenticationService()).setTicketGrantingTicketExpirationPolicy((ExpirationPolicy)new NeverExpiresExpirationPolicy());
        }
    }

    @Test
    public void verifyDelegateTicketGrantingTicketWithProperParams() throws Exception {
        TicketGrantingTicket ticketId = this.getCentralAuthenticationService().createTicketGrantingTicket(new Credential[]{TestUtils.getCredentialsWithSameUsernameAndPassword()});
        ServiceTicket serviceTicketId = this.getCentralAuthenticationService().grantServiceTicket(ticketId.getId(), TestUtils.getService());
        TicketGrantingTicket pgt = this.getCentralAuthenticationService().delegateTicketGrantingTicket(serviceTicketId.getId(), new Credential[]{TestUtils.getHttpBasedServiceCredentials()});
        Assert.assertTrue((boolean)pgt.getId().startsWith("PGT"));
    }

    @Test(expected=TicketException.class)
    public void verifyDelegateTicketGrantingTicketWithBadServiceTicket() throws Exception {
        TicketGrantingTicket ticketId = this.getCentralAuthenticationService().createTicketGrantingTicket(new Credential[]{TestUtils.getCredentialsWithSameUsernameAndPassword()});
        ServiceTicket serviceTicketId = this.getCentralAuthenticationService().grantServiceTicket(ticketId.getId(), TestUtils.getService());
        this.getCentralAuthenticationService().destroyTicketGrantingTicket(ticketId.getId());
        this.getCentralAuthenticationService().delegateTicketGrantingTicket(serviceTicketId.getId(), new Credential[]{TestUtils.getHttpBasedServiceCredentials()});
    }

    @Test
    public void verifyGrantServiceTicketWithValidCredentials() throws Exception {
        TicketGrantingTicket ticketGrantingTicket = this.getCentralAuthenticationService().createTicketGrantingTicket(new Credential[]{TestUtils.getCredentialsWithSameUsernameAndPassword()});
        this.getCentralAuthenticationService().grantServiceTicket(ticketGrantingTicket.getId(), TestUtils.getService(), new Credential[]{TestUtils.getCredentialsWithSameUsernameAndPassword()});
    }

    @Test(expected=MixedPrincipalException.class)
    public void verifyGrantServiceTicketWithDifferentCredentials() throws Exception {
        TicketGrantingTicket ticketGrantingTicket = this.getCentralAuthenticationService().createTicketGrantingTicket(new Credential[]{TestUtils.getCredentialsWithSameUsernameAndPassword("testA")});
        this.getCentralAuthenticationService().grantServiceTicket(ticketGrantingTicket.getId(), TestUtils.getService(), new Credential[]{TestUtils.getCredentialsWithSameUsernameAndPassword("testB")});
    }

    @Test
    public void verifyValidateServiceTicketWithExpires() throws Exception {
        ((CentralAuthenticationServiceImpl)this.getCentralAuthenticationService()).setServiceTicketExpirationPolicy((ExpirationPolicy)new MultiTimeUseOrTimeoutExpirationPolicy(1, 1100L));
        TicketGrantingTicket ticketGrantingTicket = this.getCentralAuthenticationService().createTicketGrantingTicket(new Credential[]{TestUtils.getCredentialsWithSameUsernameAndPassword()});
        ServiceTicket serviceTicket = this.getCentralAuthenticationService().grantServiceTicket(ticketGrantingTicket.getId(), TestUtils.getService());
        this.getCentralAuthenticationService().validateServiceTicket(serviceTicket.getId(), TestUtils.getService());
        Assert.assertFalse((boolean)this.getTicketRegistry().deleteTicket(serviceTicket.getId()));
        ((CentralAuthenticationServiceImpl)this.getCentralAuthenticationService()).setServiceTicketExpirationPolicy((ExpirationPolicy)new NeverExpiresExpirationPolicy());
    }

    @Test
    public void verifyValidateServiceTicketWithValidService() throws Exception {
        TicketGrantingTicket ticketGrantingTicket = this.getCentralAuthenticationService().createTicketGrantingTicket(new Credential[]{TestUtils.getCredentialsWithSameUsernameAndPassword()});
        ServiceTicket serviceTicket = this.getCentralAuthenticationService().grantServiceTicket(ticketGrantingTicket.getId(), TestUtils.getService());
        this.getCentralAuthenticationService().validateServiceTicket(serviceTicket.getId(), TestUtils.getService());
    }

    @Test(expected=UnauthorizedServiceException.class)
    public void verifyValidateServiceTicketWithInvalidService() throws Exception {
        TicketGrantingTicket ticketGrantingTicket = this.getCentralAuthenticationService().createTicketGrantingTicket(new Credential[]{TestUtils.getCredentialsWithSameUsernameAndPassword()});
        ServiceTicket serviceTicket = this.getCentralAuthenticationService().grantServiceTicket(ticketGrantingTicket.getId(), TestUtils.getService());
        this.getCentralAuthenticationService().validateServiceTicket(serviceTicket.getId(), TestUtils.getService("test2"));
    }

    @Test(expected=TicketException.class)
    public void verifyValidateServiceTicketWithInvalidServiceTicket() throws Exception {
        TicketGrantingTicket ticketGrantingTicket = this.getCentralAuthenticationService().createTicketGrantingTicket(new Credential[]{TestUtils.getCredentialsWithSameUsernameAndPassword()});
        ServiceTicket serviceTicket = this.getCentralAuthenticationService().grantServiceTicket(ticketGrantingTicket.getId(), TestUtils.getService());
        this.getCentralAuthenticationService().destroyTicketGrantingTicket(ticketGrantingTicket.getId());
        this.getCentralAuthenticationService().validateServiceTicket(serviceTicket.getId(), TestUtils.getService());
    }

    @Test(expected=TicketException.class)
    public void verifyValidateServiceTicketNonExistantTicket() throws Exception {
        this.getCentralAuthenticationService().validateServiceTicket("test", TestUtils.getService());
    }

    @Test
    public void verifyValidateServiceTicketWithoutUsernameAttribute() throws Exception {
        UsernamePasswordCredential cred = TestUtils.getCredentialsWithSameUsernameAndPassword();
        TicketGrantingTicket ticketGrantingTicket = this.getCentralAuthenticationService().createTicketGrantingTicket(new Credential[]{cred});
        ServiceTicket serviceTicket = this.getCentralAuthenticationService().grantServiceTicket(ticketGrantingTicket.getId(), TestUtils.getService());
        Assertion assertion = this.getCentralAuthenticationService().validateServiceTicket(serviceTicket.getId(), TestUtils.getService());
        Authentication auth = assertion.getPrimaryAuthentication();
        Assert.assertEquals((Object)auth.getPrincipal().getId(), (Object)cred.getUsername());
    }

    @Test
    public void verifyValidateServiceTicketWithDefaultUsernameAttribute() throws Exception {
        UsernamePasswordCredential cred = TestUtils.getCredentialsWithSameUsernameAndPassword();
        TicketGrantingTicket ticketGrantingTicket = this.getCentralAuthenticationService().createTicketGrantingTicket(new Credential[]{cred});
        Service svc = TestUtils.getService("testDefault");
        ServiceTicket serviceTicket = this.getCentralAuthenticationService().grantServiceTicket(ticketGrantingTicket.getId(), svc);
        Assertion assertion = this.getCentralAuthenticationService().validateServiceTicket(serviceTicket.getId(), svc);
        Authentication auth = assertion.getPrimaryAuthentication();
        Assert.assertEquals((Object)auth.getPrincipal().getId(), (Object)cred.getUsername());
    }

    @Test
    public void verifyValidateServiceTicketWithUsernameAttribute() throws Exception {
        UsernamePasswordCredential cred = TestUtils.getCredentialsWithSameUsernameAndPassword();
        TicketGrantingTicket ticketGrantingTicket = this.getCentralAuthenticationService().createTicketGrantingTicket(new Credential[]{cred});
        Service svc = TestUtils.getService("eduPersonTest");
        ServiceTicket serviceTicket = this.getCentralAuthenticationService().grantServiceTicket(ticketGrantingTicket.getId(), svc);
        Assertion assertion = this.getCentralAuthenticationService().validateServiceTicket(serviceTicket.getId(), svc);
        Assert.assertEquals((Object)"developer", (Object)assertion.getPrimaryAuthentication().getPrincipal().getId());
    }

    @Test
    public void verifyGrantServiceTicketWithCredsAndSsoFalse() throws Exception {
        UsernamePasswordCredential cred = TestUtils.getCredentialsWithSameUsernameAndPassword();
        TicketGrantingTicket ticketGrantingTicket = this.getCentralAuthenticationService().createTicketGrantingTicket(new Credential[]{cred});
        Service svc = TestUtils.getService("TestSsoFalse");
        ServiceTicket serviceTicket = this.getCentralAuthenticationService().grantServiceTicket(ticketGrantingTicket.getId(), svc, new Credential[]{cred});
        Assert.assertNotNull((Object)serviceTicket);
    }

    @Test(expected=UnauthorizedSsoServiceException.class)
    public void verifyGrantServiceTicketWithNoCredsAndSsoFalse() throws Exception {
        UsernamePasswordCredential cred = TestUtils.getCredentialsWithSameUsernameAndPassword();
        TicketGrantingTicket ticketGrantingTicket = this.getCentralAuthenticationService().createTicketGrantingTicket(new Credential[]{cred});
        Service svc = TestUtils.getService("TestSsoFalse");
        this.getCentralAuthenticationService().grantServiceTicket(ticketGrantingTicket.getId(), svc, null);
    }

    @Test
    public void verifyValidateServiceTicketNoAttributesReturned() throws Exception {
        Service service = TestUtils.getService();
        UsernamePasswordCredential cred = TestUtils.getCredentialsWithSameUsernameAndPassword();
        TicketGrantingTicket ticketGrantingTicket = this.getCentralAuthenticationService().createTicketGrantingTicket(new Credential[]{cred});
        ServiceTicket serviceTicket = this.getCentralAuthenticationService().grantServiceTicket(ticketGrantingTicket.getId(), service);
        Assertion assertion = this.getCentralAuthenticationService().validateServiceTicket(serviceTicket.getId(), service);
        Authentication auth = assertion.getPrimaryAuthentication();
        Assert.assertEquals((long)0L, (long)auth.getPrincipal().getAttributes().size());
    }

    @Test
    public void verifyValidateServiceTicketReturnAllAttributes() throws Exception {
        Service service = TestUtils.getService("eduPersonTest");
        UsernamePasswordCredential cred = TestUtils.getCredentialsWithSameUsernameAndPassword();
        TicketGrantingTicket ticketGrantingTicket = this.getCentralAuthenticationService().createTicketGrantingTicket(new Credential[]{cred});
        ServiceTicket serviceTicket = this.getCentralAuthenticationService().grantServiceTicket(ticketGrantingTicket.getId(), service);
        Assertion assertion = this.getCentralAuthenticationService().validateServiceTicket(serviceTicket.getId(), service);
        Authentication auth = assertion.getPrimaryAuthentication();
        Assert.assertEquals((long)3L, (long)auth.getPrincipal().getAttributes().size());
    }

    @Test
    public void verifyValidateServiceTicketReturnOnlyAllowedAttribute() throws Exception {
        Service service = TestUtils.getService("eduPersonTestInvalid");
        UsernamePasswordCredential cred = TestUtils.getCredentialsWithSameUsernameAndPassword();
        TicketGrantingTicket ticketGrantingTicket = this.getCentralAuthenticationService().createTicketGrantingTicket(new Credential[]{cred});
        ServiceTicket serviceTicket = this.getCentralAuthenticationService().grantServiceTicket(ticketGrantingTicket.getId(), service);
        Assertion assertion = this.getCentralAuthenticationService().validateServiceTicket(serviceTicket.getId(), service);
        Authentication auth = assertion.getPrimaryAuthentication();
        Map attributes = auth.getPrincipal().getAttributes();
        Assert.assertEquals((long)1L, (long)attributes.size());
        Assert.assertEquals((Object)"adopters", attributes.get("groupMembership"));
    }

    @Test
    public void verifyValidateServiceTicketAnonymous() throws Exception {
        Service service = TestUtils.getService("testAnonymous");
        UsernamePasswordCredential cred = TestUtils.getCredentialsWithSameUsernameAndPassword();
        TicketGrantingTicket ticketGrantingTicket = this.getCentralAuthenticationService().createTicketGrantingTicket(new Credential[]{cred});
        ServiceTicket serviceTicket = this.getCentralAuthenticationService().grantServiceTicket(ticketGrantingTicket.getId(), service);
        Assertion assertion = this.getCentralAuthenticationService().validateServiceTicket(serviceTicket.getId(), service);
        Authentication auth = assertion.getPrimaryAuthentication();
        Assert.assertNotEquals((Object)cred.getUsername(), (Object)auth.getPrincipal().getId());
    }

    @Test
    public void verifyValidateServiceTicketWithInvalidUsernameAttribute() throws Exception {
        UsernamePasswordCredential cred = TestUtils.getCredentialsWithSameUsernameAndPassword();
        TicketGrantingTicket ticketGrantingTicket = this.getCentralAuthenticationService().createTicketGrantingTicket(new Credential[]{cred});
        Service svc = TestUtils.getService("eduPersonTestInvalid");
        ServiceTicket serviceTicket = this.getCentralAuthenticationService().grantServiceTicket(ticketGrantingTicket.getId(), svc);
        Assertion assertion = this.getCentralAuthenticationService().validateServiceTicket(serviceTicket.getId(), svc);
        Authentication auth = assertion.getPrimaryAuthentication();
        Assert.assertEquals((Object)auth.getPrincipal().getId(), (Object)cred.getUsername());
    }

    @Test
    public void authenticateTwiceWithRenew() throws TicketException, AuthenticationException {
        CentralAuthenticationService cas = this.getCentralAuthenticationService();
        Service svc = TestUtils.getService("testDefault");
        UsernamePasswordCredential goodCredential = TestUtils.getCredentialsWithSameUsernameAndPassword();
        TicketGrantingTicket tgtId = cas.createTicketGrantingTicket(new Credential[]{goodCredential});
        cas.grantServiceTicket(tgtId.getId(), svc);
        ServiceTicket st2Id = cas.grantServiceTicket(tgtId.getId(), svc, new Credential[]{goodCredential});
        Assertion assertion = cas.validateServiceTicket(st2Id.getId(), svc);
        Cas20WithoutProxyingValidationSpecification validationSpecification = new Cas20WithoutProxyingValidationSpecification();
        Assert.assertTrue((boolean)validationSpecification.isSatisfiedBy(assertion));
    }

    @Test
    public void verifyDestroyRemoteRegistry() throws TicketException, AuthenticationException {
        MockOnlyOneTicketRegistry registry = new MockOnlyOneTicketRegistry();
        TicketGrantingTicketImpl tgt = new TicketGrantingTicketImpl("TGT-1", (Authentication)Mockito.mock(Authentication.class), (ExpirationPolicy)Mockito.mock(ExpirationPolicy.class));
        MockExpireUpdateTicketLogoutManager logoutManager = new MockExpireUpdateTicketLogoutManager(registry);
        registry.addTicket((Ticket)tgt);
        CentralAuthenticationServiceImpl cas = new CentralAuthenticationServiceImpl((TicketRegistry)registry, null, null, null, null, null, null, (LogoutManager)logoutManager);
        cas.destroyTicketGrantingTicket(tgt.getId());
    }
}

