/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jasig.cas.authentication.Authentication;
import org.jasig.cas.authentication.AuthenticationHandler;
import org.jasig.cas.authentication.BasicCredentialMetaData;
import org.jasig.cas.authentication.Credential;
import org.jasig.cas.authentication.CredentialMetaData;
import org.jasig.cas.authentication.DefaultAuthenticationBuilder;
import org.jasig.cas.authentication.DefaultHandlerResult;
import org.jasig.cas.authentication.HandlerResult;
import org.jasig.cas.authentication.HttpBasedServiceCredential;
import org.jasig.cas.authentication.UsernamePasswordCredential;
import org.jasig.cas.authentication.handler.support.SimpleTestUsernamePasswordAuthenticationHandler;
import org.jasig.cas.authentication.principal.CachingPrincipalAttributesRepository;
import org.jasig.cas.authentication.principal.DefaultPrincipalFactory;
import org.jasig.cas.authentication.principal.Principal;
import org.jasig.cas.authentication.principal.PrincipalAttributesRepository;
import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.authentication.principal.SimpleWebApplicationServiceImpl;
import org.jasig.cas.services.AbstractRegisteredService;
import org.jasig.cas.services.AttributeFilter;
import org.jasig.cas.services.AttributeReleasePolicy;
import org.jasig.cas.services.DefaultRegisteredServiceAccessStrategy;
import org.jasig.cas.services.LogoutType;
import org.jasig.cas.services.PrincipalAttributeRegisteredServiceUsernameProvider;
import org.jasig.cas.services.RegexMatchingRegisteredServiceProxyPolicy;
import org.jasig.cas.services.RegexRegisteredService;
import org.jasig.cas.services.RegisteredService;
import org.jasig.cas.services.RegisteredServiceAccessStrategy;
import org.jasig.cas.services.RegisteredServiceProxyPolicy;
import org.jasig.cas.services.RegisteredServicePublicKey;
import org.jasig.cas.services.RegisteredServicePublicKeyImpl;
import org.jasig.cas.services.RegisteredServiceUsernameAttributeProvider;
import org.jasig.cas.services.ReturnAllowedAttributeReleasePolicy;
import org.jasig.cas.services.support.RegisteredServiceRegexAttributeFilter;
import org.jasig.cas.validation.Assertion;
import org.jasig.cas.validation.ImmutableAssertion;
import org.jasig.services.persondir.IPersonAttributeDao;
import org.jasig.services.persondir.support.StubPersonAttributeDao;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.mock.web.MockServletContext;
import org.springframework.validation.BindException;
import org.springframework.webflow.context.ExternalContext;
import org.springframework.webflow.context.servlet.ServletExternalContext;
import org.springframework.webflow.test.MockRequestContext;

public final class TestUtils {
    public static final String CONST_USERNAME = "test";
    public static final String CONST_TEST_URL = "https://test.com";
    public static final String CONST_EXCEPTION_EXPECTED = "Exception expected.";
    public static final String CONST_EXCEPTION_NON_EXPECTED = "Exception not expected.";
    public static final String CONST_GOOD_URL = "https://github.com/";
    private static final String CONST_PASSWORD = "test1";
    private static final String CONST_CREDENTIALS = "credentials";
    private static final String CONST_WEBFLOW_BIND_EXCEPTION = "org.springframework.validation.BindException.credentials";
    private static final String[] CONST_NO_PRINCIPALS = new String[0];

    private TestUtils() {
    }

    public static UsernamePasswordCredential getCredentialsWithSameUsernameAndPassword() {
        return TestUtils.getCredentialsWithSameUsernameAndPassword(CONST_USERNAME);
    }

    public static UsernamePasswordCredential getCredentialsWithSameUsernameAndPassword(String username) {
        return TestUtils.getCredentialsWithDifferentUsernameAndPassword(username, username);
    }

    public static UsernamePasswordCredential getCredentialsWithDifferentUsernameAndPassword() {
        return TestUtils.getCredentialsWithDifferentUsernameAndPassword(CONST_USERNAME, CONST_PASSWORD);
    }

    public static UsernamePasswordCredential getCredentialsWithDifferentUsernameAndPassword(String username, String password) {
        UsernamePasswordCredential usernamePasswordCredentials = new UsernamePasswordCredential();
        usernamePasswordCredentials.setUsername(username);
        usernamePasswordCredentials.setPassword(password);
        return usernamePasswordCredentials;
    }

    public static HttpBasedServiceCredential getHttpBasedServiceCredentials() {
        return TestUtils.getHttpBasedServiceCredentials(CONST_GOOD_URL);
    }

    public static HttpBasedServiceCredential getHttpBasedServiceCredentials(String url) {
        try {
            return new HttpBasedServiceCredential(new URL(url), (RegisteredService)TestUtils.getRegisteredService(url));
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException();
        }
    }

    public static IPersonAttributeDao getAttributeRepository() {
        HashMap<String, ImmutableList> attributes = new HashMap<String, ImmutableList>();
        attributes.put("uid", ImmutableList.of((Object)CONST_USERNAME));
        attributes.put("cn", ImmutableList.of((Object)CONST_USERNAME.toUpperCase()));
        attributes.put("givenName", ImmutableList.of((Object)CONST_USERNAME));
        attributes.put("memberOf", ImmutableList.of((Object)"system", (Object)"admin", (Object)"cas"));
        return new StubPersonAttributeDao(attributes);
    }

    public static Principal getPrincipal() {
        return TestUtils.getPrincipal(CONST_USERNAME);
    }

    public static Principal getPrincipal(String name) {
        return TestUtils.getPrincipal(name, Collections.EMPTY_MAP);
    }

    public static Principal getPrincipal(String name, Map<String, Object> attributes) {
        return new DefaultPrincipalFactory().createPrincipal(name, attributes);
    }

    public static AbstractRegisteredService getRegisteredService(String id) {
        try {
            RegexRegisteredService s = new RegexRegisteredService();
            s.setServiceId(id);
            s.setEvaluationOrder(1);
            s.setName("Test registered service");
            s.setDescription("Registered service description");
            s.setProxyPolicy((RegisteredServiceProxyPolicy)new RegexMatchingRegisteredServiceProxyPolicy("^https?://.+"));
            s.setId((long)new SecureRandom().nextInt(Math.abs(s.hashCode())));
            s.setTheme("exampleTheme");
            s.setUsernameAttributeProvider((RegisteredServiceUsernameAttributeProvider)new PrincipalAttributeRegisteredServiceUsernameProvider("uid"));
            DefaultRegisteredServiceAccessStrategy accessStrategy = new DefaultRegisteredServiceAccessStrategy(true, true);
            accessStrategy.setRequireAllAttributes(true);
            accessStrategy.setRequiredAttributes(TestUtils.getTestAttributes());
            s.setAccessStrategy((RegisteredServiceAccessStrategy)accessStrategy);
            s.setLogo(new URL("https://logo.example.org/logo.png"));
            s.setLogoutType(LogoutType.BACK_CHANNEL);
            s.setLogoutUrl(new URL("https://sys.example.org/logout.png"));
            s.setProxyPolicy((RegisteredServiceProxyPolicy)new RegexMatchingRegisteredServiceProxyPolicy("^http.+"));
            s.setPublicKey((RegisteredServicePublicKey)new RegisteredServicePublicKeyImpl("classpath:pub.key", "RSA"));
            ReturnAllowedAttributeReleasePolicy policy = new ReturnAllowedAttributeReleasePolicy();
            policy.setAuthorizedToReleaseCredentialPassword(true);
            policy.setAuthorizedToReleaseProxyGrantingTicket(true);
            CachingPrincipalAttributesRepository repo = new CachingPrincipalAttributesRepository(10L);
            repo.setMergingStrategy(CachingPrincipalAttributesRepository.MergingStrategy.ADD);
            policy.setPrincipalAttributesRepository((PrincipalAttributesRepository)repo);
            policy.setAttributeFilter((AttributeFilter)new RegisteredServiceRegexAttributeFilter("https://.+"));
            policy.setAllowedAttributes(new ArrayList<String>(TestUtils.getTestAttributes().keySet()));
            s.setAttributeReleasePolicy((AttributeReleasePolicy)policy);
            return s;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Service getService() {
        return TestUtils.getService(CONST_TEST_URL);
    }

    public static Service getService(String name) {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addParameter("service", name);
        return SimpleWebApplicationServiceImpl.createServiceFrom((HttpServletRequest)request);
    }

    public static Authentication getAuthentication() {
        return TestUtils.getAuthentication(CONST_USERNAME);
    }

    public static Authentication getAuthentication(String name) {
        return TestUtils.getAuthentication(TestUtils.getPrincipal(name));
    }

    public static Authentication getAuthentication(Principal principal) {
        return TestUtils.getAuthentication(principal, Collections.emptyMap());
    }

    public static Authentication getAuthentication(Principal principal, Map<String, Object> attributes) {
        SimpleTestUsernamePasswordAuthenticationHandler handler = new SimpleTestUsernamePasswordAuthenticationHandler();
        BasicCredentialMetaData meta = new BasicCredentialMetaData((Credential)new UsernamePasswordCredential());
        return new DefaultAuthenticationBuilder(principal).addCredential((CredentialMetaData)meta).addSuccess("testHandler", (HandlerResult)new DefaultHandlerResult((AuthenticationHandler)handler, (CredentialMetaData)meta)).setAttributes(attributes).build();
    }

    public static Authentication getAuthenticationWithService() {
        return TestUtils.getAuthentication((Principal)TestUtils.getService());
    }

    public static Assertion getAssertion(boolean fromNewLogin) {
        return TestUtils.getAssertion(fromNewLogin, CONST_NO_PRINCIPALS);
    }

    public static Assertion getAssertion(boolean fromNewLogin, String[] extraPrincipals) {
        ArrayList<Authentication> list = new ArrayList<Authentication>();
        list.add(TestUtils.getAuthentication());
        for (int i = 0; i < extraPrincipals.length; ++i) {
            list.add(TestUtils.getAuthentication(extraPrincipals[i]));
        }
        return new ImmutableAssertion(TestUtils.getAuthentication(), list, TestUtils.getService(), fromNewLogin);
    }

    public static MockRequestContext getContext() {
        return TestUtils.getContext(new MockHttpServletRequest());
    }

    public static MockRequestContext getContext(MockHttpServletRequest request) {
        return TestUtils.getContext(request, new MockHttpServletResponse());
    }

    public static MockRequestContext getContext(MockHttpServletRequest request, MockHttpServletResponse response) {
        MockRequestContext context = new MockRequestContext();
        context.setExternalContext((ExternalContext)new ServletExternalContext((ServletContext)new MockServletContext(), (HttpServletRequest)request, (HttpServletResponse)response));
        return context;
    }

    public static MockRequestContext getContextWithCredentials(MockHttpServletRequest request) {
        return TestUtils.getContextWithCredentials(request, new MockHttpServletResponse());
    }

    public static MockRequestContext getContextWithCredentials(MockHttpServletRequest request, MockHttpServletResponse response) {
        MockRequestContext context = TestUtils.getContext(request, response);
        context.getRequestScope().put(CONST_CREDENTIALS, (Object)TestUtils.getCredentialsWithSameUsernameAndPassword());
        context.getRequestScope().put(CONST_WEBFLOW_BIND_EXCEPTION, (Object)new BindException((Object)TestUtils.getCredentialsWithSameUsernameAndPassword(), CONST_CREDENTIALS));
        return context;
    }

    public static Map<String, Set<String>> getTestAttributes() {
        HashMap<String, Set<String>> attributes = new HashMap<String, Set<String>>();
        attributes.put("uid", (Set<String>)ImmutableSet.of((Object)"uid"));
        attributes.put("givenName", (Set<String>)ImmutableSet.of((Object)"CASUser"));
        attributes.put("memberOf", (Set<String>)ImmutableSet.of((Object)"system", (Object)"admin", (Object)"cas"));
        return attributes;
    }
}

