/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.audit.spi;

import org.aspectj.lang.JoinPoint;
import org.jasig.cas.AbstractCentralAuthenticationServiceTest;
import org.jasig.cas.TestUtils;
import org.jasig.cas.audit.spi.TicketOrCredentialPrincipalResolver;
import org.jasig.cas.authentication.Credential;
import org.jasig.cas.authentication.UsernamePasswordCredential;
import org.jasig.cas.ticket.ServiceTicket;
import org.jasig.cas.ticket.TicketGrantingTicket;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;

public class TicketOrCredentialPrincipalResolverTests
extends AbstractCentralAuthenticationServiceTest {
    @Test
    public void verifyResolverByUnknownUser() {
        TicketOrCredentialPrincipalResolver res = new TicketOrCredentialPrincipalResolver(this.getCentralAuthenticationService());
        Assert.assertEquals((Object)res.resolve(), (Object)"audit:unknown");
    }

    @Test
    public void verifyResolverCredential() {
        TicketOrCredentialPrincipalResolver res = new TicketOrCredentialPrincipalResolver(this.getCentralAuthenticationService());
        JoinPoint jp = (JoinPoint)Mockito.mock(JoinPoint.class);
        UsernamePasswordCredential c = TestUtils.getCredentialsWithSameUsernameAndPassword();
        Mockito.when((Object)jp.getArgs()).thenReturn((Object)new Object[]{c});
        String result = res.resolveFrom(jp, null);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)result, (Object)c.toString());
    }

    @Test
    public void verifyResolverServiceTicket() throws Exception {
        UsernamePasswordCredential c = TestUtils.getCredentialsWithSameUsernameAndPassword();
        TicketGrantingTicket ticketId = this.getCentralAuthenticationService().createTicketGrantingTicket(new Credential[]{c});
        ServiceTicket st = this.getCentralAuthenticationService().grantServiceTicket(ticketId.getId(), TestUtils.getService());
        TicketOrCredentialPrincipalResolver res = new TicketOrCredentialPrincipalResolver(this.getCentralAuthenticationService());
        JoinPoint jp = (JoinPoint)Mockito.mock(JoinPoint.class);
        Mockito.when((Object)jp.getArgs()).thenReturn((Object)new Object[]{st.getId()});
        String result = res.resolveFrom(jp, null);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)result, (Object)c.getId());
    }

    @Test
    public void verifyResolverTicketGrantingTicket() throws Exception {
        UsernamePasswordCredential c = TestUtils.getCredentialsWithSameUsernameAndPassword();
        TicketGrantingTicket ticketId = this.getCentralAuthenticationService().createTicketGrantingTicket(new Credential[]{c});
        TicketOrCredentialPrincipalResolver res = new TicketOrCredentialPrincipalResolver(this.getCentralAuthenticationService());
        JoinPoint jp = (JoinPoint)Mockito.mock(JoinPoint.class);
        Mockito.when((Object)jp.getArgs()).thenReturn((Object)new Object[]{ticketId.getId()});
        String result = res.resolveFrom(jp, null);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)result, (Object)c.getId());
    }

    @Test
    public void verifyResolverSecurityContext() throws Exception {
        UserDetails ud = (UserDetails)Mockito.mock(UserDetails.class);
        Mockito.when((Object)ud.getUsername()).thenReturn((Object)"pid");
        Authentication authn = (Authentication)Mockito.mock(Authentication.class);
        Mockito.when((Object)authn.getPrincipal()).thenReturn((Object)ud);
        SecurityContext securityContext = (SecurityContext)Mockito.mock(SecurityContext.class);
        Mockito.when((Object)securityContext.getAuthentication()).thenReturn((Object)authn);
        SecurityContextHolder.setContext((SecurityContext)securityContext);
        TicketOrCredentialPrincipalResolver res = new TicketOrCredentialPrincipalResolver(this.getCentralAuthenticationService());
        JoinPoint jp = (JoinPoint)Mockito.mock(JoinPoint.class);
        Mockito.when((Object)jp.getArgs()).thenReturn((Object)new Object[]{ud});
        String result = res.resolveFrom(jp, null);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)result, (Object)ud.getUsername());
    }
}

