/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.authentication.handler.support;

import javax.security.auth.login.FailedLoginException;
import org.jasig.cas.TestUtils;
import org.jasig.cas.authentication.Credential;
import org.jasig.cas.authentication.handler.support.HttpBasedServiceCredentialsAuthenticationHandler;
import org.jasig.cas.util.http.HttpClient;
import org.jasig.cas.util.http.SimpleHttpClient;
import org.jasig.cas.util.http.SimpleHttpClientFactoryBean;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public final class HttpBasedServiceCredentialsAuthenticationHandlerTests {
    private HttpBasedServiceCredentialsAuthenticationHandler authenticationHandler;

    @Before
    public void setUp() throws Exception {
        this.authenticationHandler = new HttpBasedServiceCredentialsAuthenticationHandler();
        this.authenticationHandler.setHttpClient((HttpClient)new SimpleHttpClientFactoryBean().getObject());
    }

    @Test
    public void verifySupportsProperUserCredentials() {
        Assert.assertTrue((boolean)this.authenticationHandler.supports((Credential)TestUtils.getHttpBasedServiceCredentials()));
    }

    @Test
    public void verifyDoesntSupportBadUserCredentials() {
        Assert.assertFalse((boolean)this.authenticationHandler.supports((Credential)TestUtils.getCredentialsWithSameUsernameAndPassword()));
    }

    @Test
    public void verifyAcceptsProperCertificateCredentials() throws Exception {
        Assert.assertNotNull((Object)this.authenticationHandler.authenticate((Credential)TestUtils.getHttpBasedServiceCredentials()));
    }

    @Test(expected=FailedLoginException.class)
    public void verifyRejectsInProperCertificateCredentials() throws Exception {
        this.authenticationHandler.authenticate((Credential)TestUtils.getHttpBasedServiceCredentials("https://clearinghouse.ja-sig.org"));
    }

    @Test
    public void verifyAcceptsNonHttpsCredentials() throws Exception {
        this.authenticationHandler.setHttpClient((HttpClient)new SimpleHttpClientFactoryBean().getObject());
        Assert.assertNotNull((Object)this.authenticationHandler.authenticate((Credential)TestUtils.getHttpBasedServiceCredentials("http://www.google.com")));
    }

    @Test(expected=FailedLoginException.class)
    public void verifyNoAcceptableStatusCode() throws Exception {
        this.authenticationHandler.authenticate((Credential)TestUtils.getHttpBasedServiceCredentials("https://clue.acs.rutgers.edu"));
    }

    @Test(expected=FailedLoginException.class)
    public void verifyNoAcceptableStatusCodeButOneSet() throws Exception {
        SimpleHttpClientFactoryBean clientFactory = new SimpleHttpClientFactoryBean();
        clientFactory.setAcceptableCodes(new int[]{900});
        SimpleHttpClient httpClient = clientFactory.getObject();
        this.authenticationHandler.setHttpClient((HttpClient)httpClient);
        this.authenticationHandler.authenticate((Credential)TestUtils.getHttpBasedServiceCredentials("https://www.ja-sig.org"));
    }
}

