/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.authentication.handler.support;

import java.security.GeneralSecurityException;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.login.AccountLockedException;
import javax.security.auth.login.CredentialExpiredException;
import javax.security.auth.login.FailedLoginException;
import org.jasig.cas.authentication.AccountDisabledException;
import org.jasig.cas.authentication.AuthenticationHandler;
import org.jasig.cas.authentication.BasicCredentialMetaData;
import org.jasig.cas.authentication.Credential;
import org.jasig.cas.authentication.CredentialMetaData;
import org.jasig.cas.authentication.DefaultHandlerResult;
import org.jasig.cas.authentication.HandlerResult;
import org.jasig.cas.authentication.InvalidLoginLocationException;
import org.jasig.cas.authentication.InvalidLoginTimeException;
import org.jasig.cas.authentication.PreventedException;
import org.jasig.cas.authentication.UsernamePasswordCredential;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public final class SimpleTestUsernamePasswordAuthenticationHandler
implements AuthenticationHandler {
    private static final Map<String, Exception> DEFAULT_USERNAME_ERROR_MAP = new HashMap<String, Exception>();
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Map<String, Exception> usernameErrorMap = DEFAULT_USERNAME_ERROR_MAP;

    public SimpleTestUsernamePasswordAuthenticationHandler() {
        this.logger.warn("{} is only to be used in a testing environment.  NEVER enable this in a production environment.", (Object)this.getName());
    }

    public void setUsernameErrorMap(Map<String, Exception> map) {
        this.usernameErrorMap = map;
    }

    public HandlerResult authenticate(Credential credential) throws GeneralSecurityException, PreventedException {
        UsernamePasswordCredential usernamePasswordCredential = (UsernamePasswordCredential)credential;
        String username = usernamePasswordCredential.getUsername();
        String password = usernamePasswordCredential.getPassword();
        Exception exception = this.usernameErrorMap.get(username);
        if (exception instanceof GeneralSecurityException) {
            throw (GeneralSecurityException)exception;
        }
        if (exception instanceof PreventedException) {
            throw (PreventedException)exception;
        }
        if (exception instanceof RuntimeException) {
            throw (RuntimeException)exception;
        }
        if (exception != null) {
            this.logger.debug("Cannot throw checked exception {} since it is not declared by method signature.", (Throwable)exception);
        }
        if (StringUtils.hasText((String)username) && StringUtils.hasText((String)password) && username.equals(password)) {
            this.logger.debug("User [{}] was successfully authenticated.", (Object)username);
            return new DefaultHandlerResult((AuthenticationHandler)this, (CredentialMetaData)new BasicCredentialMetaData(credential));
        }
        this.logger.debug("User [{}] failed authentication", (Object)username);
        throw new FailedLoginException();
    }

    public boolean supports(Credential credential) {
        return credential instanceof UsernamePasswordCredential;
    }

    public String getName() {
        return this.getClass().getSimpleName();
    }

    static {
        DEFAULT_USERNAME_ERROR_MAP.put("accountDisabled", (Exception)new AccountDisabledException("Account disabled"));
        DEFAULT_USERNAME_ERROR_MAP.put("accountLocked", new AccountLockedException("Account locked"));
        DEFAULT_USERNAME_ERROR_MAP.put("badHours", (Exception)new InvalidLoginTimeException("Invalid logon hours"));
        DEFAULT_USERNAME_ERROR_MAP.put("badWorkstation", (Exception)new InvalidLoginLocationException("Invalid workstation"));
        DEFAULT_USERNAME_ERROR_MAP.put("passwordExpired", new CredentialExpiredException("Password expired"));
    }
}

