/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.authentication.principal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.jasig.cas.authentication.principal.CachingPrincipalAttributesRepository;
import org.jasig.cas.authentication.principal.DefaultPrincipalFactory;
import org.jasig.cas.authentication.principal.Principal;
import org.jasig.cas.authentication.principal.PrincipalFactory;
import org.jasig.services.persondir.IPersonAttributeDao;
import org.jasig.services.persondir.IPersonAttributes;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class CachingPrincipalAttributesRepositoryTests {
    private Map<String, List<Object>> attributes;
    private IPersonAttributeDao dao;
    private final PrincipalFactory principalFactory = new DefaultPrincipalFactory();
    private Principal principal;

    @Before
    public void setup() {
        this.attributes = new HashMap<String, List<Object>>();
        this.attributes.put("a1", new ArrayList<Object>(Arrays.asList("v1", "v2", "v3")));
        this.attributes.put("mail", new ArrayList<Object>(Arrays.asList("final@example.com")));
        this.attributes.put("a6", new ArrayList<Object>(Arrays.asList("v16", "v26", "v63")));
        this.attributes.put("a2", new ArrayList<Object>(Arrays.asList("v4")));
        this.attributes.put("username", new ArrayList<Object>(Arrays.asList("uid")));
        this.dao = (IPersonAttributeDao)Mockito.mock(IPersonAttributeDao.class);
        IPersonAttributes person = (IPersonAttributes)Mockito.mock(IPersonAttributes.class);
        Mockito.when((Object)person.getName()).thenReturn((Object)"uid");
        Mockito.when((Object)person.getAttributes()).thenReturn(this.attributes);
        Mockito.when((Object)this.dao.getPerson((String)Mockito.any(String.class))).thenReturn((Object)person);
        this.principal = this.principalFactory.createPrincipal("uid", Collections.singletonMap("mail", new ArrayList<Object>(Arrays.asList("final@school.com"))));
    }

    @Test
    public void checkExpiredCachedAttributes() throws Exception {
        Assert.assertEquals((long)this.principal.getAttributes().size(), (long)1L);
        CachingPrincipalAttributesRepository repository = new CachingPrincipalAttributesRepository(TimeUnit.MILLISECONDS, 100L);
        repository.setAttributeRepository(this.dao);
        Assert.assertEquals((long)repository.getAttributes(this.principal).size(), (long)this.attributes.size());
        Assert.assertTrue((boolean)repository.getAttributes(this.principal).containsKey("mail"));
        Thread.sleep(200L);
        this.attributes.remove("mail");
        Assert.assertTrue((boolean)repository.getAttributes(this.principal).containsKey("a2"));
        Assert.assertFalse((boolean)repository.getAttributes(this.principal).containsKey("mail"));
        repository.close();
    }

    @Test
    public void ensureCachedAttributesWithUpdate() throws Exception {
        CachingPrincipalAttributesRepository repository = new CachingPrincipalAttributesRepository(TimeUnit.SECONDS, 5L);
        repository.setAttributeRepository(this.dao);
        Assert.assertEquals((long)repository.getAttributes(this.principal).size(), (long)this.attributes.size());
        Assert.assertTrue((boolean)repository.getAttributes(this.principal).containsKey("mail"));
        this.attributes.clear();
        Assert.assertTrue((boolean)repository.getAttributes(this.principal).containsKey("mail"));
        repository.close();
    }

    @Test
    public void verifyMergingStrategyWithNoncollidingAttributeAdder() throws Exception {
        CachingPrincipalAttributesRepository repository = new CachingPrincipalAttributesRepository(TimeUnit.SECONDS, 5L);
        repository.setAttributeRepository(this.dao);
        repository.setMergingStrategy(CachingPrincipalAttributesRepository.MergingStrategy.ADD);
        Assert.assertTrue((boolean)repository.getAttributes(this.principal).containsKey("mail"));
        Assert.assertEquals((Object)repository.getAttributes(this.principal).get("mail").toString(), (Object)"final@school.com");
        repository.close();
    }

    @Test
    public void verifyMergingStrategyWithReplacingAttributeAdder() throws Exception {
        CachingPrincipalAttributesRepository repository = new CachingPrincipalAttributesRepository(TimeUnit.SECONDS, 5L);
        repository.setAttributeRepository(this.dao);
        repository.setMergingStrategy(CachingPrincipalAttributesRepository.MergingStrategy.REPLACE);
        Assert.assertTrue((boolean)repository.getAttributes(this.principal).containsKey("mail"));
        Assert.assertEquals((Object)repository.getAttributes(this.principal).get("mail").toString(), (Object)"final@example.com");
        repository.close();
    }

    @Test
    public void verifyMergingStrategyWithMultivaluedAttributeMerger() throws Exception {
        CachingPrincipalAttributesRepository repository = new CachingPrincipalAttributesRepository(TimeUnit.SECONDS, 5L);
        repository.setAttributeRepository(this.dao);
        repository.setMergingStrategy(CachingPrincipalAttributesRepository.MergingStrategy.MULTIVALUED);
        Assert.assertTrue((boolean)(repository.getAttributes(this.principal).get("mail") instanceof List));
        List values = (List)repository.getAttributes(this.principal).get("mail");
        Assert.assertTrue((boolean)values.contains("final@example.com"));
        Assert.assertTrue((boolean)values.contains("final@school.com"));
        repository.close();
    }
}

