/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.authentication.principal;

import org.jasig.cas.TestUtils;
import org.jasig.cas.authentication.Authentication;
import org.jasig.cas.authentication.AuthenticationBuilder;
import org.jasig.cas.authentication.AuthenticationHandler;
import org.jasig.cas.authentication.BasicCredentialMetaData;
import org.jasig.cas.authentication.Credential;
import org.jasig.cas.authentication.CredentialMetaData;
import org.jasig.cas.authentication.DefaultAuthenticationBuilder;
import org.jasig.cas.authentication.DefaultHandlerResult;
import org.jasig.cas.authentication.HandlerResult;
import org.jasig.cas.authentication.RememberMeUsernamePasswordCredential;
import org.jasig.cas.authentication.UsernamePasswordCredential;
import org.jasig.cas.authentication.handler.support.SimpleTestUsernamePasswordAuthenticationHandler;
import org.jasig.cas.authentication.principal.RememberMeAuthenticationMetaDataPopulator;
import org.junit.Assert;
import org.junit.Test;

public class RememberMeAuthenticationMetaDataPopulatorTests {
    private final RememberMeAuthenticationMetaDataPopulator p = new RememberMeAuthenticationMetaDataPopulator();

    @Test
    public void verifyWithTrueRememberMeCredentials() {
        RememberMeUsernamePasswordCredential c = new RememberMeUsernamePasswordCredential();
        c.setRememberMe(true);
        AuthenticationBuilder builder = this.newBuilder((Credential)c);
        Authentication auth = builder.build();
        Assert.assertEquals((Object)true, auth.getAttributes().get("org.jasig.cas.authentication.principal.REMEMBER_ME"));
    }

    @Test
    public void verifyWithFalseRememberMeCredentials() {
        RememberMeUsernamePasswordCredential c = new RememberMeUsernamePasswordCredential();
        c.setRememberMe(false);
        AuthenticationBuilder builder = this.newBuilder((Credential)c);
        Authentication auth = builder.build();
        Assert.assertNull(auth.getAttributes().get("org.jasig.cas.authentication.principal.REMEMBER_ME"));
    }

    @Test
    public void verifyWithoutRememberMeCredentials() {
        AuthenticationBuilder builder = this.newBuilder((Credential)TestUtils.getCredentialsWithSameUsernameAndPassword());
        Authentication auth = builder.build();
        Assert.assertNull(auth.getAttributes().get("org.jasig.cas.authentication.principal.REMEMBER_ME"));
    }

    private AuthenticationBuilder newBuilder(Credential credential) {
        BasicCredentialMetaData meta = new BasicCredentialMetaData((Credential)new UsernamePasswordCredential());
        SimpleTestUsernamePasswordAuthenticationHandler handler = new SimpleTestUsernamePasswordAuthenticationHandler();
        AuthenticationBuilder builder = new DefaultAuthenticationBuilder(TestUtils.getPrincipal()).addCredential((CredentialMetaData)meta).addSuccess("test", (HandlerResult)new DefaultHandlerResult((AuthenticationHandler)handler, (CredentialMetaData)meta));
        if (this.p.supports(credential)) {
            this.p.populateAttributes(builder, credential);
        }
        return builder;
    }
}

