/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.logout;

import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.authentication.principal.SimpleWebApplicationServiceImpl;
import org.jasig.cas.logout.LogoutManagerImpl;
import org.jasig.cas.logout.LogoutMessageCreator;
import org.jasig.cas.logout.LogoutRequest;
import org.jasig.cas.logout.LogoutRequestStatus;
import org.jasig.cas.logout.SamlCompliantLogoutMessageCreator;
import org.jasig.cas.services.LogoutType;
import org.jasig.cas.services.RegisteredServiceImpl;
import org.jasig.cas.services.ServicesManager;
import org.jasig.cas.ticket.TicketGrantingTicket;
import org.jasig.cas.util.http.HttpClient;
import org.jasig.cas.util.http.HttpMessage;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@RunWith(value=JUnit4.class)
public class LogoutManagerImplTests {
    private static final String ID = "id";
    private static final String URL = "http://www.github.com";
    private LogoutManagerImpl logoutManager;
    @Mock
    private TicketGrantingTicket tgt;
    private Map<String, Service> services;
    private SimpleWebApplicationServiceImpl simpleWebApplicationServiceImpl;
    private RegisteredServiceImpl registeredService;
    @Mock
    private ServicesManager servicesManager;
    @Mock
    private HttpClient client;

    public LogoutManagerImplTests() {
        MockitoAnnotations.initMocks((Object)this);
    }

    @Before
    public void setUp() {
        Mockito.when((Object)this.client.isValidEndPoint((String)Mockito.any(String.class))).thenReturn((Object)true);
        Mockito.when((Object)this.client.isValidEndPoint((URL)Mockito.any(URL.class))).thenReturn((Object)true);
        Mockito.when((Object)this.client.sendMessageToEndPoint((HttpMessage)Mockito.any(HttpMessage.class))).thenReturn((Object)true);
        this.logoutManager = new LogoutManagerImpl(this.servicesManager, this.client, (LogoutMessageCreator)new SamlCompliantLogoutMessageCreator());
        this.services = new HashMap<String, Service>();
        this.simpleWebApplicationServiceImpl = new SimpleWebApplicationServiceImpl(URL);
        this.services.put(ID, (Service)this.simpleWebApplicationServiceImpl);
        Mockito.when((Object)this.tgt.getServices()).thenReturn(this.services);
        this.registeredService = new RegisteredServiceImpl();
        Mockito.when((Object)this.servicesManager.findServiceBy((Service)this.simpleWebApplicationServiceImpl)).thenReturn((Object)this.registeredService);
    }

    @Test
    public void verifyServiceLogoutUrlIsUsed() throws Exception {
        this.registeredService.setLogoutUrl(new URL("https://www.apereo.org"));
        List logoutRequests = this.logoutManager.performLogout(this.tgt);
        LogoutRequest logoutRequest = (LogoutRequest)logoutRequests.iterator().next();
        Assert.assertEquals((Object)logoutRequest.getLogoutUrl(), (Object)this.registeredService.getLogoutUrl());
    }

    @Test
    public void verifyLogoutDisabled() {
        this.logoutManager.setSingleLogoutCallbacksDisabled(true);
        List logoutRequests = this.logoutManager.performLogout(this.tgt);
        Assert.assertEquals((long)0L, (long)logoutRequests.size());
    }

    @Test
    public void verifyLogoutAlreadyLoggedOut() {
        this.simpleWebApplicationServiceImpl.setLoggedOutAlready(true);
        List logoutRequests = this.logoutManager.performLogout(this.tgt);
        Assert.assertEquals((long)0L, (long)logoutRequests.size());
    }

    @Test
    public void verifyLogoutTypeNotSet() {
        List logoutRequests = this.logoutManager.performLogout(this.tgt);
        Assert.assertEquals((long)1L, (long)logoutRequests.size());
        LogoutRequest logoutRequest = (LogoutRequest)logoutRequests.iterator().next();
        Assert.assertEquals((Object)ID, (Object)logoutRequest.getTicketId());
        Assert.assertEquals((Object)this.simpleWebApplicationServiceImpl, (Object)logoutRequest.getService());
        Assert.assertEquals((Object)LogoutRequestStatus.SUCCESS, (Object)logoutRequest.getStatus());
    }

    @Test
    public void verifyLogoutTypeBack() {
        this.registeredService.setLogoutType(LogoutType.BACK_CHANNEL);
        List logoutRequests = this.logoutManager.performLogout(this.tgt);
        Assert.assertEquals((long)1L, (long)logoutRequests.size());
        LogoutRequest logoutRequest = (LogoutRequest)logoutRequests.iterator().next();
        Assert.assertEquals((Object)ID, (Object)logoutRequest.getTicketId());
        Assert.assertEquals((Object)this.simpleWebApplicationServiceImpl, (Object)logoutRequest.getService());
        Assert.assertEquals((Object)LogoutRequestStatus.SUCCESS, (Object)logoutRequest.getStatus());
    }

    @Test
    public void verifyLogoutTypeNone() {
        this.registeredService.setLogoutType(LogoutType.NONE);
        List logoutRequests = this.logoutManager.performLogout(this.tgt);
        Assert.assertEquals((long)0L, (long)logoutRequests.size());
    }

    @Test
    public void verifyLogoutTypeNull() {
        this.registeredService.setLogoutType(null);
        List logoutRequests = this.logoutManager.performLogout(this.tgt);
        Assert.assertEquals((long)1L, (long)logoutRequests.size());
        LogoutRequest logoutRequest = (LogoutRequest)logoutRequests.iterator().next();
        Assert.assertEquals((Object)ID, (Object)logoutRequest.getTicketId());
    }

    @Test
    public void verifyLogoutTypeFront() {
        this.registeredService.setLogoutType(LogoutType.FRONT_CHANNEL);
        List logoutRequests = this.logoutManager.performLogout(this.tgt);
        Assert.assertEquals((long)1L, (long)logoutRequests.size());
        LogoutRequest logoutRequest = (LogoutRequest)logoutRequests.iterator().next();
        Assert.assertEquals((Object)ID, (Object)logoutRequest.getTicketId());
        Assert.assertEquals((Object)this.simpleWebApplicationServiceImpl, (Object)logoutRequest.getService());
        Assert.assertEquals((Object)LogoutRequestStatus.NOT_ATTEMPTED, (Object)logoutRequest.getStatus());
    }

    @Test
    public void verifyAsynchronousLogout() {
        this.registeredService.setLogoutType(LogoutType.BACK_CHANNEL);
        this.logoutManager.setAsynchronous(false);
        List logoutRequests = this.logoutManager.performLogout(this.tgt);
        Assert.assertEquals((long)1L, (long)logoutRequests.size());
    }
}

