/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.logout;

import java.io.ByteArrayInputStream;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jasig.cas.authentication.principal.SingleLogoutService;
import org.jasig.cas.logout.DefaultLogoutRequest;
import org.jasig.cas.logout.LogoutMessageCreator;
import org.jasig.cas.logout.LogoutRequest;
import org.jasig.cas.logout.SamlCompliantLogoutMessageCreator;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mockito;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

@RunWith(value=JUnit4.class)
public class SamlCompliantLogoutMessageCreatorTests {
    private final LogoutMessageCreator builder = new SamlCompliantLogoutMessageCreator();

    @Test
    public void verifyMessageBuilding() throws Exception {
        SingleLogoutService service = (SingleLogoutService)Mockito.mock(SingleLogoutService.class);
        Mockito.when((Object)service.getOriginalUrl()).thenReturn((Object)"https://test.com");
        URL logoutUrl = new URL(service.getOriginalUrl());
        DefaultLogoutRequest request = new DefaultLogoutRequest("TICKET-ID", service, logoutUrl);
        String msg = this.builder.create((LogoutRequest)request);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        ByteArrayInputStream is = new ByteArrayInputStream(msg.getBytes());
        Document document = builder.parse(is);
        NodeList list = document.getDocumentElement().getElementsByTagName("samlp:SessionIndex");
        Assert.assertEquals((long)list.getLength(), (long)1L);
        Assert.assertEquals((Object)list.item(0).getTextContent(), (Object)request.getTicketId());
    }
}

