/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.mock;

import java.util.Date;
import org.jasig.cas.authentication.Authentication;
import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.ticket.ExpirationPolicy;
import org.jasig.cas.ticket.ServiceTicket;
import org.jasig.cas.ticket.TicketGrantingTicket;
import org.jasig.cas.util.DefaultUniqueTicketIdGenerator;
import org.jasig.cas.util.UniqueTicketIdGenerator;

public class MockServiceTicket
implements ServiceTicket {
    private static final long serialVersionUID = 8203377063087967768L;
    private static final UniqueTicketIdGenerator ID_GENERATOR = new DefaultUniqueTicketIdGenerator();
    private final String id;
    private final Date created;
    private final Service service;
    private final TicketGrantingTicket parent;

    public MockServiceTicket(String id, Service service, TicketGrantingTicket parent) {
        this.service = service;
        this.id = id;
        this.parent = parent;
        this.created = new Date();
    }

    public Service getService() {
        return this.service;
    }

    public boolean isFromNewLogin() {
        return false;
    }

    public boolean isValidFor(Service service) {
        return this.service.equals(service);
    }

    public TicketGrantingTicket grantTicketGrantingTicket(String id, Authentication authentication, ExpirationPolicy expirationPolicy) {
        return null;
    }

    public String getId() {
        return this.id;
    }

    public boolean isExpired() {
        return false;
    }

    public TicketGrantingTicket getGrantingTicket() {
        return this.parent;
    }

    public long getCreationTime() {
        return this.created.getTime();
    }

    public int getCountOfUses() {
        return 0;
    }
}

