/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.services;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.jasig.cas.TestUtils;
import org.jasig.cas.authentication.principal.PersistentIdGenerator;
import org.jasig.cas.authentication.principal.Principal;
import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.authentication.principal.ShibbolethCompatiblePersistentIdGenerator;
import org.jasig.cas.services.AbstractRegisteredService;
import org.jasig.cas.services.AnonymousRegisteredServiceUsernameAttributeProvider;
import org.jasig.cas.services.AttributeReleasePolicy;
import org.jasig.cas.services.DefaultRegisteredServiceAccessStrategy;
import org.jasig.cas.services.RegexRegisteredService;
import org.jasig.cas.services.RegisteredService;
import org.jasig.cas.services.RegisteredServiceAccessStrategy;
import org.jasig.cas.services.RegisteredServiceImpl;
import org.jasig.cas.services.RegisteredServiceUsernameAttributeProvider;
import org.jasig.cas.services.ReturnAllAttributeReleasePolicy;
import org.jasig.cas.services.ReturnAllowedAttributeReleasePolicy;
import org.jasig.cas.services.ReturnMappedAttributeReleasePolicy;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class AbstractRegisteredServiceTests {
    private static final long ID = 1000L;
    private static final String DESCRIPTION = "test";
    private static final String SERVICEID = "serviceId";
    private static final String THEME = "theme";
    private static final String NAME = "name";
    private static final boolean ENABLED = false;
    private static final boolean ALLOWED_TO_PROXY = false;
    private static final boolean SSO_ENABLED = false;
    private final AbstractRegisteredService r = new AbstractRegisteredService(){
        private static final long serialVersionUID = 1L;

        public void setServiceId(String id) {
            this.serviceId = id;
        }

        protected AbstractRegisteredService newInstance() {
            return this;
        }

        public boolean matches(Service service) {
            return true;
        }
    };

    @Test
    public void verifyAllowToProxyIsFalseByDefault() {
        RegexRegisteredService regexRegisteredService = new RegexRegisteredService();
        Assert.assertFalse((boolean)regexRegisteredService.getProxyPolicy().isAllowedToProxy());
        RegisteredServiceImpl registeredServiceImpl = new RegisteredServiceImpl();
        Assert.assertFalse((boolean)registeredServiceImpl.getProxyPolicy().isAllowedToProxy());
    }

    @Test
    public void verifySettersAndGetters() {
        this.prepareService();
        Assert.assertEquals((Object)false, (Object)this.r.getProxyPolicy().isAllowedToProxy());
        Assert.assertEquals((Object)DESCRIPTION, (Object)this.r.getDescription());
        Assert.assertEquals((Object)false, (Object)this.r.getAccessStrategy().isServiceAccessAllowed());
        Assert.assertEquals((long)1000L, (long)this.r.getId());
        Assert.assertEquals((Object)NAME, (Object)this.r.getName());
        Assert.assertEquals((Object)SERVICEID, (Object)this.r.getServiceId());
        Assert.assertEquals((Object)false, (Object)this.r.getAccessStrategy().isServiceAccessAllowedForSso());
        Assert.assertEquals((Object)THEME, (Object)this.r.getTheme());
        Assert.assertFalse((boolean)this.r.equals(null));
        Assert.assertFalse((boolean)this.r.equals(new Object()));
        Assert.assertTrue((boolean)this.r.equals((Object)this.r));
    }

    @Test
    public void verifyEquals() throws Exception {
        Assert.assertTrue((boolean)this.r.equals((Object)this.r.clone()));
        Assert.assertFalse((boolean)new RegisteredServiceImpl().equals(null));
        Assert.assertFalse((boolean)new RegisteredServiceImpl().equals(new Object()));
    }

    private void prepareService() {
        this.r.setUsernameAttributeProvider((RegisteredServiceUsernameAttributeProvider)new AnonymousRegisteredServiceUsernameAttributeProvider((PersistentIdGenerator)new ShibbolethCompatiblePersistentIdGenerator("casrox")));
        this.r.setDescription(DESCRIPTION);
        this.r.setId(1000L);
        this.r.setName(NAME);
        this.r.setServiceId(SERVICEID);
        this.r.setTheme(THEME);
        this.r.setAccessStrategy((RegisteredServiceAccessStrategy)new DefaultRegisteredServiceAccessStrategy(false, false));
    }

    @Test
    public void verifyServiceAttributeFilterAllAttributes() {
        this.prepareService();
        this.r.setAttributeReleasePolicy((AttributeReleasePolicy)new ReturnAllAttributeReleasePolicy());
        Principal p = (Principal)Mockito.mock(Principal.class);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("attr1", "value1");
        map.put("attr2", "value2");
        map.put("attr3", Arrays.asList("v3", "v4"));
        Mockito.when((Object)p.getAttributes()).thenReturn(map);
        Mockito.when((Object)p.getId()).thenReturn((Object)"principalId");
        Map attr = this.r.getAttributeReleasePolicy().getAttributes(p);
        Assert.assertEquals((long)attr.size(), (long)map.size());
    }

    @Test
    public void verifyServiceAttributeFilterAllowedAttributes() {
        this.prepareService();
        ReturnAllowedAttributeReleasePolicy policy = new ReturnAllowedAttributeReleasePolicy();
        policy.setAllowedAttributes(Arrays.asList("attr1", "attr3"));
        this.r.setAttributeReleasePolicy((AttributeReleasePolicy)policy);
        Principal p = (Principal)Mockito.mock(Principal.class);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("attr1", "value1");
        map.put("attr2", "value2");
        map.put("attr3", Arrays.asList("v3", "v4"));
        Mockito.when((Object)p.getAttributes()).thenReturn(map);
        Mockito.when((Object)p.getId()).thenReturn((Object)"principalId");
        Map attr = this.r.getAttributeReleasePolicy().getAttributes(p);
        Assert.assertEquals((long)attr.size(), (long)2L);
        Assert.assertTrue((boolean)attr.containsKey("attr1"));
        Assert.assertTrue((boolean)attr.containsKey("attr3"));
    }

    @Test
    public void verifyServiceAttributeFilterMappedAttributes() {
        this.prepareService();
        ReturnMappedAttributeReleasePolicy policy = new ReturnMappedAttributeReleasePolicy();
        HashMap<String, String> mappedAttr = new HashMap<String, String>();
        mappedAttr.put("attr1", "newAttr1");
        policy.setAllowedAttributes(mappedAttr);
        this.r.setAttributeReleasePolicy((AttributeReleasePolicy)policy);
        Principal p = (Principal)Mockito.mock(Principal.class);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("attr1", "value1");
        map.put("attr2", "value2");
        map.put("attr3", Arrays.asList("v3", "v4"));
        Mockito.when((Object)p.getAttributes()).thenReturn(map);
        Mockito.when((Object)p.getId()).thenReturn((Object)"principalId");
        Map attr = this.r.getAttributeReleasePolicy().getAttributes(p);
        Assert.assertEquals((long)attr.size(), (long)1L);
        Assert.assertTrue((boolean)attr.containsKey("newAttr1"));
    }

    @Test
    public void verifyServiceEquality() {
        AbstractRegisteredService svc1 = TestUtils.getRegisteredService(SERVICEID);
        AbstractRegisteredService svc2 = TestUtils.getRegisteredService(SERVICEID);
        Assert.assertEquals((Object)svc1, (Object)svc2);
    }

    @Test
    public void verifyServiceCopy() throws Exception {
        AbstractRegisteredService svc1 = TestUtils.getRegisteredService(SERVICEID);
        RegisteredService svc2 = svc1.clone();
        Assert.assertEquals((Object)svc1, (Object)svc2);
    }
}

