/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.services;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.SerializationUtils;
import org.jasig.cas.authentication.principal.CachingPrincipalAttributesRepository;
import org.jasig.cas.authentication.principal.DefaultPrincipalFactory;
import org.jasig.cas.authentication.principal.Principal;
import org.jasig.cas.authentication.principal.PrincipalAttributesRepository;
import org.jasig.cas.services.AttributeFilter;
import org.jasig.cas.services.ReturnAllAttributeReleasePolicy;
import org.jasig.cas.services.ReturnAllowedAttributeReleasePolicy;
import org.jasig.cas.services.ReturnMappedAttributeReleasePolicy;
import org.jasig.cas.services.support.RegisteredServiceRegexAttributeFilter;
import org.jasig.services.persondir.IPersonAttributeDao;
import org.jasig.services.persondir.IPersonAttributes;
import org.jasig.services.persondir.support.StubPersonAttributeDao;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class AttributeReleasePolicyTests {
    @Test
    public void verifyAttributeFilterMappedAttributes() {
        ReturnMappedAttributeReleasePolicy policy = new ReturnMappedAttributeReleasePolicy();
        HashMap<String, String> mappedAttr = new HashMap<String, String>();
        mappedAttr.put("attr1", "newAttr1");
        policy.setAllowedAttributes(mappedAttr);
        Principal p = (Principal)Mockito.mock(Principal.class);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("attr1", "value1");
        map.put("attr2", "value2");
        map.put("attr3", Arrays.asList("v3", "v4"));
        Mockito.when((Object)p.getAttributes()).thenReturn(map);
        Mockito.when((Object)p.getId()).thenReturn((Object)"principalId");
        Map attr = policy.getAttributes(p);
        Assert.assertEquals((long)attr.size(), (long)1L);
        Assert.assertTrue((boolean)attr.containsKey("newAttr1"));
        byte[] data = SerializationUtils.serialize((Serializable)policy);
        ReturnMappedAttributeReleasePolicy p2 = (ReturnMappedAttributeReleasePolicy)SerializationUtils.deserialize((byte[])data);
        Assert.assertNotNull((Object)p2);
        Assert.assertEquals((Object)p2.getAllowedAttributes(), (Object)policy.getAllowedAttributes());
    }

    @Test
    public void verifyServiceAttributeFilterAllowedAttributes() {
        ReturnAllowedAttributeReleasePolicy policy = new ReturnAllowedAttributeReleasePolicy();
        policy.setAllowedAttributes(Arrays.asList("attr1", "attr3"));
        Principal p = (Principal)Mockito.mock(Principal.class);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("attr1", "value1");
        map.put("attr2", "value2");
        map.put("attr3", Arrays.asList("v3", "v4"));
        Mockito.when((Object)p.getAttributes()).thenReturn(map);
        Mockito.when((Object)p.getId()).thenReturn((Object)"principalId");
        Map attr = policy.getAttributes(p);
        Assert.assertEquals((long)attr.size(), (long)2L);
        Assert.assertTrue((boolean)attr.containsKey("attr1"));
        Assert.assertTrue((boolean)attr.containsKey("attr3"));
        byte[] data = SerializationUtils.serialize((Serializable)policy);
        ReturnAllowedAttributeReleasePolicy p2 = (ReturnAllowedAttributeReleasePolicy)SerializationUtils.deserialize((byte[])data);
        Assert.assertNotNull((Object)p2);
        Assert.assertEquals((Object)p2.getAllowedAttributes(), (Object)policy.getAllowedAttributes());
    }

    @Test
    public void verifyServiceAttributeFilterAllowedAttributesWithARegexFilter() {
        ReturnAllowedAttributeReleasePolicy policy = new ReturnAllowedAttributeReleasePolicy();
        policy.setAllowedAttributes(Arrays.asList("attr1", "attr3", "another"));
        policy.setAttributeFilter((AttributeFilter)new RegisteredServiceRegexAttributeFilter("v3"));
        Principal p = (Principal)Mockito.mock(Principal.class);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("attr1", "value1");
        map.put("attr2", "value2");
        map.put("attr3", Arrays.asList("v3", "v4"));
        Mockito.when((Object)p.getAttributes()).thenReturn(map);
        Mockito.when((Object)p.getId()).thenReturn((Object)"principalId");
        Map attr = policy.getAttributes(p);
        Assert.assertEquals((long)attr.size(), (long)1L);
        Assert.assertTrue((boolean)attr.containsKey("attr3"));
        byte[] data = SerializationUtils.serialize((Serializable)policy);
        ReturnAllowedAttributeReleasePolicy p2 = (ReturnAllowedAttributeReleasePolicy)SerializationUtils.deserialize((byte[])data);
        Assert.assertNotNull((Object)p2);
        Assert.assertEquals((Object)p2.getAllowedAttributes(), (Object)policy.getAllowedAttributes());
        Assert.assertEquals((Object)p2.getAttributeFilter(), (Object)policy.getAttributeFilter());
    }

    @Test
    public void verifyServiceAttributeFilterAllAttributes() {
        ReturnAllAttributeReleasePolicy policy = new ReturnAllAttributeReleasePolicy();
        Principal p = (Principal)Mockito.mock(Principal.class);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("attr1", "value1");
        map.put("attr2", "value2");
        map.put("attr3", Arrays.asList("v3", "v4"));
        Mockito.when((Object)p.getAttributes()).thenReturn(map);
        Mockito.when((Object)p.getId()).thenReturn((Object)"principalId");
        Map attr = policy.getAttributes(p);
        Assert.assertEquals((long)attr.size(), (long)map.size());
        byte[] data = SerializationUtils.serialize((Serializable)policy);
        ReturnAllAttributeReleasePolicy p2 = (ReturnAllAttributeReleasePolicy)SerializationUtils.deserialize((byte[])data);
        Assert.assertNotNull((Object)p2);
    }

    @Test
    public void checkServiceAttributeFilterAllAttributesWithCachingTurnedOn() {
        ReturnAllAttributeReleasePolicy policy = new ReturnAllAttributeReleasePolicy();
        HashMap<String, List<Object>> attributes = new HashMap<String, List<Object>>();
        attributes.put("values", Arrays.asList("v1", "v2", "v3"));
        attributes.put("cn", Arrays.asList("commonName"));
        attributes.put("username", Arrays.asList("uid"));
        StubPersonAttributeDao dao = new StubPersonAttributeDao(attributes);
        IPersonAttributes person = (IPersonAttributes)Mockito.mock(IPersonAttributes.class);
        Mockito.when((Object)person.getName()).thenReturn((Object)"uid");
        Mockito.when((Object)person.getAttributes()).thenReturn(attributes);
        CachingPrincipalAttributesRepository repository = new CachingPrincipalAttributesRepository(TimeUnit.MILLISECONDS, 100L);
        repository.setAttributeRepository((IPersonAttributeDao)dao);
        Principal p = new DefaultPrincipalFactory().createPrincipal("uid", Collections.singletonMap("mail", "final@example.com"));
        policy.setPrincipalAttributesRepository((PrincipalAttributesRepository)repository);
        Map attr = policy.getAttributes(p);
        Assert.assertEquals((long)attr.size(), (long)attributes.size());
    }
}

