/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.services;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jasig.cas.services.DefaultRegisteredServiceAccessStrategy;
import org.junit.Assert;
import org.junit.Test;

public class DefaultRegisteredServiceAccessStrategyTests {
    @Test
    public void checkDefaultAuthzStrategyConfig() {
        DefaultRegisteredServiceAccessStrategy authz = new DefaultRegisteredServiceAccessStrategy();
        Assert.assertTrue((boolean)authz.isServiceAccessAllowed());
        Assert.assertTrue((boolean)authz.isServiceAccessAllowedForSso());
    }

    @Test
    public void checkDisabledAuthzStrategyConfig() {
        DefaultRegisteredServiceAccessStrategy authz = new DefaultRegisteredServiceAccessStrategy(false, true);
        Assert.assertFalse((boolean)authz.isServiceAccessAllowed());
        Assert.assertTrue((boolean)authz.isServiceAccessAllowedForSso());
    }

    @Test
    public void checkDisabledSsoAuthzStrategyConfig() {
        DefaultRegisteredServiceAccessStrategy authz = new DefaultRegisteredServiceAccessStrategy(true, false);
        Assert.assertTrue((boolean)authz.isServiceAccessAllowed());
        Assert.assertFalse((boolean)authz.isServiceAccessAllowedForSso());
    }

    @Test
    public void setAuthzStrategyConfig() {
        DefaultRegisteredServiceAccessStrategy authz = new DefaultRegisteredServiceAccessStrategy(false, false);
        authz.setEnabled(true);
        authz.setSsoEnabled(true);
        Assert.assertTrue((boolean)authz.isServiceAccessAllowed());
        Assert.assertTrue((boolean)authz.isServiceAccessAllowedForSso());
        Assert.assertTrue((boolean)authz.isRequireAllAttributes());
    }

    @Test
    public void checkAuthzPrincipalNoAttrRequirements() {
        DefaultRegisteredServiceAccessStrategy authz = new DefaultRegisteredServiceAccessStrategy();
        Assert.assertTrue((boolean)authz.doPrincipalAttributesAllowServiceAccess(new HashMap()));
    }

    @Test
    public void checkAuthzPrincipalWithAttrRequirementsEmptyPrincipal() {
        DefaultRegisteredServiceAccessStrategy authz = new DefaultRegisteredServiceAccessStrategy();
        authz.setRequiredAttributes(this.getRequiredAttributes());
        Assert.assertFalse((boolean)authz.doPrincipalAttributesAllowServiceAccess(new HashMap()));
    }

    @Test
    public void checkAuthzPrincipalWithAttrRequirementsAll() {
        DefaultRegisteredServiceAccessStrategy authz = new DefaultRegisteredServiceAccessStrategy();
        authz.setRequiredAttributes(this.getRequiredAttributes());
        Assert.assertTrue((boolean)authz.doPrincipalAttributesAllowServiceAccess(this.getPrincipalAttributes()));
    }

    @Test
    public void checkAuthzPrincipalWithAttrRequirementsMissingOne() {
        DefaultRegisteredServiceAccessStrategy authz = new DefaultRegisteredServiceAccessStrategy();
        authz.setRequiredAttributes(this.getRequiredAttributes());
        Map<String, Object> pAttrs = this.getPrincipalAttributes();
        pAttrs.remove("cn");
        Assert.assertFalse((boolean)authz.doPrincipalAttributesAllowServiceAccess(pAttrs));
    }

    @Test
    public void checkAuthzPrincipalWithAttrRequirementsMissingOneButNotAllNeeded() {
        DefaultRegisteredServiceAccessStrategy authz = new DefaultRegisteredServiceAccessStrategy();
        authz.setRequiredAttributes(this.getRequiredAttributes());
        authz.setRequireAllAttributes(false);
        Map<String, Object> pAttrs = this.getPrincipalAttributes();
        pAttrs.remove("cn");
        Assert.assertTrue((boolean)authz.doPrincipalAttributesAllowServiceAccess(pAttrs));
    }

    @Test
    public void checkAuthzPrincipalWithAttrRequirementsNoValueMatch() {
        DefaultRegisteredServiceAccessStrategy authz = new DefaultRegisteredServiceAccessStrategy();
        authz.setRequiredAttributes(this.getRequiredAttributes());
        authz.setRequireAllAttributes(false);
        Map<String, Object> pAttrs = this.getPrincipalAttributes();
        pAttrs.remove("cn");
        pAttrs.put("givenName", "theName");
        Assert.assertFalse((boolean)authz.doPrincipalAttributesAllowServiceAccess(pAttrs));
    }

    @Test
    public void checkAuthzPrincipalWithAttrValueCaseSensitiveComparison() {
        DefaultRegisteredServiceAccessStrategy authz = new DefaultRegisteredServiceAccessStrategy();
        authz.setRequiredAttributes(this.getRequiredAttributes());
        Map<String, Object> pAttrs = this.getPrincipalAttributes();
        pAttrs.put("cn", "CAS");
        pAttrs.put("givenName", "kaz");
        Assert.assertFalse((boolean)authz.doPrincipalAttributesAllowServiceAccess(pAttrs));
    }

    private Map<String, Set<String>> getRequiredAttributes() {
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
        map.put("cn", Sets.newHashSet((Object[])new String[]{"cas", "SSO"}));
        map.put("givenName", Sets.newHashSet((Object[])new String[]{"CAS", "KAZ"}));
        return map;
    }

    private Map<String, Object> getPrincipalAttributes() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("cn", "cas");
        map.put("givenName", Arrays.asList("cas", "KAZ"));
        map.put("sn", "surname");
        map.put("phone", "123-456-7890");
        return map;
    }
}

