/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.services;

import org.jasig.cas.TestUtils;
import org.jasig.cas.services.AbstractRegisteredService;
import org.jasig.cas.services.InMemoryServiceRegistryDaoImpl;
import org.jasig.cas.services.RegisteredService;
import org.junit.Assert;
import org.junit.Test;

public class InMemoryServiceRegistryDaoImplTests {
    @Test
    public void verifySave() {
        InMemoryServiceRegistryDaoImpl reg = new InMemoryServiceRegistryDaoImpl();
        AbstractRegisteredService svc = TestUtils.getRegisteredService("service");
        Assert.assertEquals((Object)reg.save((RegisteredService)svc), (Object)svc);
    }

    @Test
    public void verifyLoadEmpty() {
        InMemoryServiceRegistryDaoImpl reg = new InMemoryServiceRegistryDaoImpl();
        Assert.assertEquals((long)reg.load().size(), (long)0L);
    }

    @Test
    public void verifySaveAndLoad() {
        InMemoryServiceRegistryDaoImpl reg = new InMemoryServiceRegistryDaoImpl();
        AbstractRegisteredService svc = TestUtils.getRegisteredService("service");
        Assert.assertEquals((Object)reg.save((RegisteredService)svc), (Object)svc);
        Assert.assertEquals((long)reg.load().size(), (long)1L);
    }

    @Test
    public void verifySaveAndFind() {
        InMemoryServiceRegistryDaoImpl reg = new InMemoryServiceRegistryDaoImpl();
        AbstractRegisteredService svc = TestUtils.getRegisteredService("service");
        Assert.assertEquals((Object)reg.save((RegisteredService)svc), (Object)svc);
        Assert.assertEquals((Object)reg.findServiceById(svc.getId()), (Object)svc);
    }

    @Test
    public void verifySaveAndDelete() {
        InMemoryServiceRegistryDaoImpl reg = new InMemoryServiceRegistryDaoImpl();
        AbstractRegisteredService svc = TestUtils.getRegisteredService("service");
        Assert.assertEquals((Object)reg.save((RegisteredService)svc), (Object)svc);
        Assert.assertTrue((boolean)reg.delete((RegisteredService)svc));
        Assert.assertEquals((long)reg.load().size(), (long)0L);
    }
}

