/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.ticket.proxy.support;

import java.net.URL;
import org.jasig.cas.TestUtils;
import org.jasig.cas.authentication.Credential;
import org.jasig.cas.authentication.HttpBasedServiceCredential;
import org.jasig.cas.services.RegisteredService;
import org.jasig.cas.ticket.TicketGrantingTicket;
import org.jasig.cas.ticket.proxy.support.Cas20ProxyHandler;
import org.jasig.cas.util.DefaultUniqueTicketIdGenerator;
import org.jasig.cas.util.UniqueTicketIdGenerator;
import org.jasig.cas.util.http.HttpClient;
import org.jasig.cas.util.http.SimpleHttpClient;
import org.jasig.cas.util.http.SimpleHttpClientFactoryBean;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class Cas20ProxyHandlerTests {
    private Cas20ProxyHandler handler;
    @Mock
    private TicketGrantingTicket proxyGrantingTicket;

    public Cas20ProxyHandlerTests() {
        MockitoAnnotations.initMocks((Object)this);
    }

    @Before
    public void setUp() throws Exception {
        this.handler = new Cas20ProxyHandler();
        SimpleHttpClientFactoryBean factory = new SimpleHttpClientFactoryBean();
        factory.setConnectionTimeout(10000);
        factory.setReadTimeout(10000);
        this.handler.setHttpClient((HttpClient)factory.getObject());
        this.handler.setUniqueTicketIdGenerator((UniqueTicketIdGenerator)new DefaultUniqueTicketIdGenerator());
        Mockito.when((Object)this.proxyGrantingTicket.getId()).thenReturn((Object)"proxyGrantingTicket");
    }

    @Test
    public void verifyValidProxyTicketWithoutQueryString() throws Exception {
        Assert.assertNotNull((Object)this.handler.handle((Credential)new HttpBasedServiceCredential(new URL("https://www.google.com/"), (RegisteredService)TestUtils.getRegisteredService("https://some.app.edu")), this.proxyGrantingTicket));
    }

    @Test
    public void verifyValidProxyTicketWithQueryString() throws Exception {
        Assert.assertNotNull((Object)this.handler.handle((Credential)new HttpBasedServiceCredential(new URL("https://www.google.com/?test=test"), (RegisteredService)TestUtils.getRegisteredService("https://some.app.edu")), this.proxyGrantingTicket));
    }

    @Test
    public void verifyNonValidProxyTicket() throws Exception {
        SimpleHttpClientFactoryBean clientFactory = new SimpleHttpClientFactoryBean();
        clientFactory.setAcceptableCodes(new int[]{900});
        SimpleHttpClient httpClient = clientFactory.getObject();
        this.handler.setHttpClient((HttpClient)httpClient);
        Assert.assertNull((Object)this.handler.handle((Credential)new HttpBasedServiceCredential(new URL("http://www.rutgers.edu"), (RegisteredService)TestUtils.getRegisteredService("https://some.app.edu")), this.proxyGrantingTicket));
    }
}

