/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.ticket.registry;

import java.util.Collection;
import org.jasig.cas.TestUtils;
import org.jasig.cas.ticket.ExpirationPolicy;
import org.jasig.cas.ticket.Ticket;
import org.jasig.cas.ticket.TicketGrantingTicketImpl;
import org.jasig.cas.ticket.registry.RegistryCleaner;
import org.jasig.cas.ticket.registry.TicketRegistry;
import org.jasig.cas.ticket.support.NeverExpiresExpirationPolicy;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class AbstractRegistryCleanerTests {
    protected TicketRegistry ticketRegistry;
    private RegistryCleaner registryCleaner;

    @Before
    public void setUp() throws Exception {
        this.ticketRegistry = this.getNewTicketRegistry();
        this.registryCleaner = this.getNewRegistryCleaner(this.ticketRegistry);
    }

    public abstract RegistryCleaner getNewRegistryCleaner(TicketRegistry var1);

    public abstract TicketRegistry getNewTicketRegistry();

    @Test
    public void verifyCleanEmptyTicketRegistry() {
        this.clean();
        Assert.assertTrue((boolean)this.ticketRegistry.getTickets().isEmpty());
    }

    @Test
    public void verifyCleanRegistryOfExpiredTicketsAllExpired() {
        this.populateRegistryWithExpiredTickets();
        this.clean();
        Assert.assertTrue((boolean)this.ticketRegistry.getTickets().isEmpty());
    }

    @Test
    public void verifyCleanRegistryOneNonExpired() {
        this.populateRegistryWithExpiredTickets();
        TicketGrantingTicketImpl ticket = new TicketGrantingTicketImpl("testNoExpire", TestUtils.getAuthentication(), (ExpirationPolicy)new NeverExpiresExpirationPolicy());
        this.ticketRegistry.addTicket((Ticket)ticket);
        this.clean();
        Assert.assertEquals((long)this.ticketRegistry.getTickets().size(), (long)1L);
    }

    protected void populateRegistryWithExpiredTickets() {
        for (int i = 0; i < 10; ++i) {
            TicketGrantingTicketImpl ticket = new TicketGrantingTicketImpl("test" + i, TestUtils.getAuthentication(), (ExpirationPolicy)new NeverExpiresExpirationPolicy());
            ticket.markTicketExpired();
            this.ticketRegistry.addTicket((Ticket)ticket);
        }
    }

    private void clean() {
        this.beforeCleaning();
        this.afterCleaning(this.registryCleaner.clean());
    }

    protected void beforeCleaning() {
    }

    protected void afterCleaning(Collection<Ticket> removedCol) {
    }
}

