/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.ticket.registry;

import java.util.ArrayList;
import java.util.Collection;
import org.jasig.cas.TestUtils;
import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.ticket.ExpirationPolicy;
import org.jasig.cas.ticket.ServiceTicket;
import org.jasig.cas.ticket.Ticket;
import org.jasig.cas.ticket.TicketGrantingTicket;
import org.jasig.cas.ticket.TicketGrantingTicketImpl;
import org.jasig.cas.ticket.registry.TicketRegistry;
import org.jasig.cas.ticket.support.NeverExpiresExpirationPolicy;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class AbstractTicketRegistryTests {
    private static final int TICKETS_IN_REGISTRY = 10;
    private TicketRegistry ticketRegistry;

    @Before
    public void setUp() throws Exception {
        this.ticketRegistry = this.getNewTicketRegistry();
    }

    public abstract TicketRegistry getNewTicketRegistry() throws Exception;

    @Test
    public void verifyAddTicketToCache() {
        try {
            this.ticketRegistry.addTicket((Ticket)new TicketGrantingTicketImpl("TEST", TestUtils.getAuthentication(), (ExpirationPolicy)new NeverExpiresExpirationPolicy()));
        }
        catch (Exception e) {
            Assert.fail((String)"Caught an exception. But no exception should have been thrown.");
        }
    }

    @Test
    public void verifyGetNullTicket() {
        try {
            this.ticketRegistry.getTicket(null, TicketGrantingTicket.class);
        }
        catch (Exception e) {
            Assert.fail((String)"Exception caught.  None expected.");
        }
    }

    @Test
    public void verifyGetNonExistingTicket() {
        try {
            this.ticketRegistry.getTicket("FALALALALALAL", TicketGrantingTicket.class);
        }
        catch (Exception e) {
            Assert.fail((String)"Exception caught.  None expected.");
        }
    }

    @Test
    public void verifyGetExistingTicketWithProperClass() {
        try {
            this.ticketRegistry.addTicket((Ticket)new TicketGrantingTicketImpl("TEST", TestUtils.getAuthentication(), (ExpirationPolicy)new NeverExpiresExpirationPolicy()));
            this.ticketRegistry.getTicket("TEST", TicketGrantingTicket.class);
        }
        catch (Exception e) {
            Assert.fail((String)"Caught an exception. But no exception should have been thrown.");
        }
    }

    @Test
    public void verifyGetExistingTicketWithInproperClass() {
        try {
            this.ticketRegistry.addTicket((Ticket)new TicketGrantingTicketImpl("TEST", TestUtils.getAuthentication(), (ExpirationPolicy)new NeverExpiresExpirationPolicy()));
            this.ticketRegistry.getTicket("TEST", ServiceTicket.class);
        }
        catch (ClassCastException e) {
            return;
        }
        Assert.fail((String)"ClassCastfinal Exception expected.");
    }

    @Test
    public void verifyGetNullTicketWithoutClass() {
        try {
            this.ticketRegistry.getTicket(null);
        }
        catch (Exception e) {
            Assert.fail((String)"Exception caught.  None expected.");
        }
    }

    @Test
    public void verifyGetNonExistingTicketWithoutClass() {
        try {
            this.ticketRegistry.getTicket("FALALALALALAL");
        }
        catch (Exception e) {
            Assert.fail((String)"Exception caught.  None expected.");
        }
    }

    @Test
    public void verifyGetExistingTicket() {
        try {
            this.ticketRegistry.addTicket((Ticket)new TicketGrantingTicketImpl("TEST", TestUtils.getAuthentication(), (ExpirationPolicy)new NeverExpiresExpirationPolicy()));
            this.ticketRegistry.getTicket("TEST");
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)"Caught an exception. But no exception should have been thrown.");
        }
    }

    @Test
    public void verifyDeleteExistingTicket() {
        try {
            this.ticketRegistry.addTicket((Ticket)new TicketGrantingTicketImpl("TEST", TestUtils.getAuthentication(), (ExpirationPolicy)new NeverExpiresExpirationPolicy()));
            Assert.assertTrue((String)"Ticket was not deleted.", (boolean)this.ticketRegistry.deleteTicket("TEST"));
        }
        catch (Exception e) {
            Assert.fail((String)"Caught an exception. But no exception should have been thrown.");
        }
    }

    @Test
    public void verifyDeleteNonExistingTicket() {
        try {
            this.ticketRegistry.addTicket((Ticket)new TicketGrantingTicketImpl("TEST", TestUtils.getAuthentication(), (ExpirationPolicy)new NeverExpiresExpirationPolicy()));
            Assert.assertFalse((String)"Ticket was deleted.", (boolean)this.ticketRegistry.deleteTicket("TEST1"));
        }
        catch (Exception e) {
            Assert.fail((String)"Caught an exception. But no exception should have been thrown.");
        }
    }

    @Test
    public void verifyDeleteNullTicket() {
        try {
            this.ticketRegistry.addTicket((Ticket)new TicketGrantingTicketImpl("TEST", TestUtils.getAuthentication(), (ExpirationPolicy)new NeverExpiresExpirationPolicy()));
            Assert.assertFalse((String)"Ticket was deleted.", (boolean)this.ticketRegistry.deleteTicket(null));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)"Caught an exception. But no exception should have been thrown.");
        }
    }

    @Test
    public void verifyGetTicketsIsZero() {
        try {
            Assert.assertEquals((String)"The size of the empty registry is not zero.", (long)this.ticketRegistry.getTickets().size(), (long)0L);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)"Caught an exception. But no exception should have been thrown.");
        }
    }

    @Test
    public void verifyGetTicketsFromRegistryEqualToTicketsAdded() {
        ArrayList<Object> tickets = new ArrayList<Object>();
        for (int i = 0; i < 10; ++i) {
            TicketGrantingTicketImpl ticketGrantingTicket = new TicketGrantingTicketImpl("TEST" + i, TestUtils.getAuthentication(), (ExpirationPolicy)new NeverExpiresExpirationPolicy());
            ServiceTicket serviceTicket = ticketGrantingTicket.grantServiceTicket("tests" + i, TestUtils.getService(), (ExpirationPolicy)new NeverExpiresExpirationPolicy(), false);
            tickets.add(ticketGrantingTicket);
            tickets.add(serviceTicket);
            this.ticketRegistry.addTicket((Ticket)ticketGrantingTicket);
            this.ticketRegistry.addTicket((Ticket)serviceTicket);
        }
        try {
            Collection ticketRegistryTickets = this.ticketRegistry.getTickets();
            Assert.assertEquals((String)"The size of the registry is not the same as the collection.", (long)ticketRegistryTickets.size(), (long)tickets.size());
            for (Ticket ticket : tickets) {
                if (ticketRegistryTickets.contains(ticket)) continue;
                Assert.fail((String)"Ticket was added to registry but was not found in retrieval of collection of all tickets.");
            }
        }
        catch (Exception e) {
            Assert.fail((String)"Caught an exception. But no exception should have been thrown.");
        }
    }

    @Test
    public void verifyDeleteTicketWithChildren() {
        try {
            this.ticketRegistry.addTicket((Ticket)new TicketGrantingTicketImpl("TGT", TestUtils.getAuthentication(), (ExpirationPolicy)new NeverExpiresExpirationPolicy()));
            TicketGrantingTicket tgt = (TicketGrantingTicket)this.ticketRegistry.getTicket("TGT", TicketGrantingTicket.class);
            Service service = TestUtils.getService("TGT_DELETE_TEST");
            ServiceTicket st1 = tgt.grantServiceTicket("ST1", service, (ExpirationPolicy)new NeverExpiresExpirationPolicy(), true);
            ServiceTicket st2 = tgt.grantServiceTicket("ST2", service, (ExpirationPolicy)new NeverExpiresExpirationPolicy(), true);
            ServiceTicket st3 = tgt.grantServiceTicket("ST3", service, (ExpirationPolicy)new NeverExpiresExpirationPolicy(), true);
            this.ticketRegistry.addTicket((Ticket)st1);
            this.ticketRegistry.addTicket((Ticket)st2);
            this.ticketRegistry.addTicket((Ticket)st3);
            Assert.assertNotNull((Object)this.ticketRegistry.getTicket("TGT", TicketGrantingTicket.class));
            Assert.assertNotNull((Object)this.ticketRegistry.getTicket("ST1", ServiceTicket.class));
            Assert.assertNotNull((Object)this.ticketRegistry.getTicket("ST2", ServiceTicket.class));
            Assert.assertNotNull((Object)this.ticketRegistry.getTicket("ST3", ServiceTicket.class));
            this.ticketRegistry.deleteTicket(tgt.getId());
            Assert.assertNull((Object)this.ticketRegistry.getTicket("TGT", TicketGrantingTicket.class));
            Assert.assertNull((Object)this.ticketRegistry.getTicket("ST1", ServiceTicket.class));
            Assert.assertNull((Object)this.ticketRegistry.getTicket("ST2", ServiceTicket.class));
            Assert.assertNull((Object)this.ticketRegistry.getTicket("ST3", ServiceTicket.class));
        }
        catch (Exception e) {
            Assert.fail((String)"Caught an exception. But no exception should have been thrown.");
        }
    }
}

