/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.ticket.registry;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jasig.cas.TestUtils;
import org.jasig.cas.ticket.ExpirationPolicy;
import org.jasig.cas.ticket.ServiceTicket;
import org.jasig.cas.ticket.Ticket;
import org.jasig.cas.ticket.TicketGrantingTicket;
import org.jasig.cas.ticket.TicketGrantingTicketImpl;
import org.jasig.cas.ticket.registry.AbstractDistributedTicketRegistry;
import org.jasig.cas.ticket.support.NeverExpiresExpirationPolicy;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public final class DistributedTicketRegistryTests {
    private TestDistributedTicketRegistry ticketRegistry;
    private boolean wasTicketUpdated;

    public void setWasTicketUpdated(boolean wasTicketUpdated) {
        this.wasTicketUpdated = wasTicketUpdated;
    }

    @Before
    public void setUp() throws Exception {
        this.ticketRegistry = new TestDistributedTicketRegistry(this);
        this.wasTicketUpdated = false;
    }

    @Test
    public void verifyProxiedInstancesEqual() {
        TicketGrantingTicketImpl t = new TicketGrantingTicketImpl("test", TestUtils.getAuthentication(), (ExpirationPolicy)new NeverExpiresExpirationPolicy());
        this.ticketRegistry.addTicket((Ticket)t);
        TicketGrantingTicket returned = (TicketGrantingTicket)this.ticketRegistry.getTicket("test");
        Assert.assertEquals((Object)t, (Object)returned);
        Assert.assertEquals((Object)returned, (Object)t);
        Assert.assertEquals((long)t.getCreationTime(), (long)returned.getCreationTime());
        Assert.assertEquals((Object)t.getAuthentication(), (Object)returned.getAuthentication());
        Assert.assertEquals((long)t.getCountOfUses(), (long)returned.getCountOfUses());
        Assert.assertEquals((Object)t.getGrantingTicket(), (Object)returned.getGrantingTicket());
        Assert.assertEquals((Object)t.getId(), (Object)returned.getId());
        Assert.assertEquals((Object)t.getChainedAuthentications(), (Object)returned.getChainedAuthentications());
        Assert.assertEquals((Object)t.isExpired(), (Object)returned.isExpired());
        Assert.assertEquals((Object)t.isRoot(), (Object)returned.isRoot());
        ServiceTicket s = t.grantServiceTicket("stest", TestUtils.getService(), (ExpirationPolicy)new NeverExpiresExpirationPolicy(), false);
        this.ticketRegistry.addTicket((Ticket)s);
        ServiceTicket sreturned = (ServiceTicket)this.ticketRegistry.getTicket("stest");
        Assert.assertEquals((Object)s, (Object)sreturned);
        Assert.assertEquals((Object)sreturned, (Object)s);
        Assert.assertEquals((long)s.getCreationTime(), (long)sreturned.getCreationTime());
        Assert.assertEquals((long)s.getCountOfUses(), (long)sreturned.getCountOfUses());
        Assert.assertEquals((Object)s.getGrantingTicket(), (Object)sreturned.getGrantingTicket());
        Assert.assertEquals((Object)s.getId(), (Object)sreturned.getId());
        Assert.assertEquals((Object)s.isExpired(), (Object)sreturned.isExpired());
        Assert.assertEquals((Object)s.getService(), (Object)sreturned.getService());
        Assert.assertEquals((Object)s.isFromNewLogin(), (Object)sreturned.isFromNewLogin());
    }

    @Test
    public void verifyUpdateOfRegistry() {
        TicketGrantingTicketImpl t = new TicketGrantingTicketImpl("test", TestUtils.getAuthentication(), (ExpirationPolicy)new NeverExpiresExpirationPolicy());
        this.ticketRegistry.addTicket((Ticket)t);
        TicketGrantingTicket returned = (TicketGrantingTicket)this.ticketRegistry.getTicket("test");
        ServiceTicket s = returned.grantServiceTicket("test2", TestUtils.getService(), (ExpirationPolicy)new NeverExpiresExpirationPolicy(), true);
        this.ticketRegistry.addTicket((Ticket)s);
        ServiceTicket s2 = (ServiceTicket)this.ticketRegistry.getTicket("test2");
        Assert.assertNotNull((Object)s2.grantTicketGrantingTicket("ff", TestUtils.getAuthentication(), (ExpirationPolicy)new NeverExpiresExpirationPolicy()));
        Assert.assertTrue((boolean)s2.isValidFor(TestUtils.getService()));
        Assert.assertTrue((boolean)this.wasTicketUpdated);
        returned.markTicketExpired();
        Assert.assertTrue((boolean)t.isExpired());
    }

    @Test
    public void verifyTicketDoesntExist() {
        Assert.assertNull((Object)this.ticketRegistry.getTicket("fdfas"));
    }

    private static class TestDistributedTicketRegistry
    extends AbstractDistributedTicketRegistry {
        private final DistributedTicketRegistryTests parent;
        private final Map<String, Ticket> tickets = new HashMap<String, Ticket>();

        public TestDistributedTicketRegistry(DistributedTicketRegistryTests parent) {
            this.parent = parent;
        }

        protected void updateTicket(Ticket ticket) {
            this.parent.setWasTicketUpdated(true);
        }

        public void addTicket(Ticket ticket) {
            this.tickets.put(ticket.getId(), ticket);
        }

        public boolean deleteTicket(String ticketId) {
            return this.tickets.remove(ticketId) != null;
        }

        public Ticket getTicket(String ticketId) {
            return this.getProxiedTicketInstance(this.tickets.get(ticketId));
        }

        public Collection<Ticket> getTickets() {
            return this.tickets.values();
        }

        protected boolean needsCallback() {
            return true;
        }
    }
}

