/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.util.http;

import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.jasig.cas.util.http.SimpleHttpClient;
import org.jasig.cas.util.http.SimpleHttpClientFactoryBean;
import org.junit.Assert;
import org.junit.Test;

public class SimpleHttpClientTests {
    private SimpleHttpClient getHttpClient() throws Exception {
        SimpleHttpClient httpClient = new SimpleHttpClientFactoryBean().getObject();
        return httpClient;
    }

    @Test
    public void verifyOkayUrl() throws Exception {
        Assert.assertTrue((boolean)this.getHttpClient().isValidEndPoint("http://www.google.com"));
    }

    @Test
    public void verifyBadUrl() throws Exception {
        Assert.assertFalse((boolean)this.getHttpClient().isValidEndPoint("https://www.abc1234.org"));
    }

    @Test
    public void verifyInvalidHttpsUrl() throws Exception {
        SimpleHttpClient client = this.getHttpClient();
        Assert.assertFalse((boolean)client.isValidEndPoint("https://static.ak.connect.facebook.com"));
    }

    @Test
    public void verifyBypassedInvalidHttpsUrl() throws Exception {
        SimpleHttpClientFactoryBean clientFactory = new SimpleHttpClientFactoryBean();
        clientFactory.setSslSocketFactory(this.getFriendlyToAllSSLSocketFactory());
        clientFactory.setHostnameVerifier((HostnameVerifier)new NoopHostnameVerifier());
        clientFactory.setAcceptableCodes(new int[]{200, 403});
        SimpleHttpClient client = clientFactory.getObject();
        Assert.assertTrue((boolean)client.isValidEndPoint("https://static.ak.connect.facebook.com"));
    }

    private SSLConnectionSocketFactory getFriendlyToAllSSLSocketFactory() throws Exception {
        X509TrustManager trm = new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        };
        SSLContext sc = SSLContext.getInstance("SSL");
        sc.init(null, new TrustManager[]{trm}, null);
        return new SSLConnectionSocketFactory(sc, (HostnameVerifier)new NoopHostnameVerifier());
    }
}

