/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.impl;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.jasig.cas.ticket.InvalidTicketException;
import org.jasig.cas.ticket.TicketGrantingTicket;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.helpers.Util;
import org.slf4j.impl.CasDelegatingLogger;

public class CasLoggerFactoryTests {
    private static final File LOG_FILE = new File("target", "slf4j.log");
    private static final String ID1 = "TGT-1-B0tjWgMIhUU4kgCZdXbxnWccTFYpTbRbArjaoutXnlNMbIShEu-cas";
    private static final String ID2 = "PGT-1-B0tjWgMIhUU4kgCZd32xnWccTFYpTbRbArjaoutXnlNMbIShEu-cas";
    private static final String ID3 = "PGTIOU-1-B0tjWgMIhUU4kgCZd32xnWccTFYpTbRbArjaoutXnlNMbIShEu-cas";
    private Logger logger;

    @BeforeClass
    public static void beforeClass() throws IOException {
        if (LOG_FILE.exists()) {
            Util.report((String)("Initializing log file " + LOG_FILE.getCanonicalPath()));
            FileUtils.write((File)LOG_FILE, (CharSequence)"", (boolean)false);
        }
    }

    @After
    public void after() throws IOException {
        FileUtils.write((File)LOG_FILE, (CharSequence)"", (boolean)false);
    }

    @Before
    public void beforeTest() {
        this.logger = LoggerFactory.getLogger(CasLoggerFactoryTests.class);
    }

    @Test
    public void verifyLoggerSelectedCorrectly() {
        Assert.assertTrue((boolean)(this.logger instanceof CasDelegatingLogger));
    }

    @Test
    public void verifyLogging1() {
        this.logger.trace(this.getMarker("trace"), this.getMessageToLogWithParams(), null, null);
        this.validateLogData();
    }

    @Test
    public void verifyLogging2() {
        this.logger.trace(this.getMarker("trace"), this.getMessageToLog());
        this.validateLogData();
    }

    @Test
    public void verifyLogging3() {
        this.logger.trace(this.getMarker("trace"), this.getMessageToLogWithParams(), (Object)ID2, (Object)ID1);
        this.validateLogData();
    }

    @Test
    public void verifyLogging4() {
        this.logger.trace(this.getMarker("trace"), this.getMessageToLogWithParams(), new Object[]{ID2, ID1, ID2});
        this.validateLogData();
    }

    @Test
    public void verifyLogging5() {
        this.logger.trace(this.getMarker("trace"), this.getMessageToLog(), (Throwable)new RuntimeException(ID1, (Throwable)new InvalidTicketException(ID2)));
        this.validateLogData();
    }

    @Test
    public void verifyLogging6() {
        this.logger.trace(this.getMessageToLog());
        this.validateLogData();
    }

    @Test
    public void verifyLogging7() {
        this.logger.trace(this.getMessageToLogWithParams(), (Object)ID2, (Object)ID1);
        this.validateLogData();
    }

    @Test
    public void verifyLogging8() {
        this.logger.trace(this.getMessageToLogWithParams(), new Object[]{ID2, ID1, ID2});
        this.validateLogData();
    }

    @Test
    public void verifyLogging9() {
        this.logger.trace(this.getMessageToLog(), (Throwable)new RuntimeException(ID1, (Throwable)new InvalidTicketException(ID2)));
        this.validateLogData();
    }

    @Test
    public void verifyLogging10() {
        this.logger.debug(this.getMarker("debug"), this.getMessageToLogWithParams(), (Object)ID3, (Object)ID1);
        this.validateLogData();
    }

    @Test
    public void verifyLogging21() {
        this.logger.debug(this.getMarker("debug"), this.getMessageToLog());
        this.validateLogData();
    }

    @Test
    public void verifyLogging31() {
        this.logger.debug(this.getMarker("debug"), this.getMessageToLogWithParams(), (Object)ID2, (Object)ID1);
        this.validateLogData();
    }

    @Test
    public void verifyLogging41() {
        this.logger.debug(this.getMarker("debug"), this.getMessageToLogWithParams(), new Object[]{ID2, ID1, ID2});
        this.validateLogData();
    }

    @Test
    public void verifyLogging51() {
        this.logger.debug(this.getMarker("debug"), this.getMessageToLog(), (Throwable)new RuntimeException(ID1, (Throwable)new InvalidTicketException(ID2)));
        this.validateLogData();
    }

    @Test
    public void verifyLogging61() {
        this.logger.debug(this.getMessageToLog());
        this.validateLogData();
    }

    @Test
    public void verifyLogging771() {
        TicketGrantingTicket t = (TicketGrantingTicket)Mockito.mock(TicketGrantingTicket.class);
        Mockito.when((Object)t.getId()).thenReturn((Object)ID1);
        Mockito.when((Object)t.toString()).thenReturn((Object)ID1);
        this.logger.debug(this.getMessageToLogWithParams(), (Object)ID2, (Object)t);
        this.validateLogData();
    }

    @Test
    public void verifyLogging71() {
        this.logger.debug(this.getMessageToLogWithParams(), (Object)ID2, (Object)ID1);
        this.validateLogData();
    }

    @Test
    public void verifyLogging81() {
        this.logger.debug(this.getMessageToLogWithParams(), new Object[]{ID2, ID1, ID2});
        this.validateLogData();
    }

    @Test
    public void verifyLogging91() {
        this.logger.debug(this.getMessageToLog(), (Throwable)new RuntimeException(ID1, (Throwable)new InvalidTicketException(ID2)));
        this.validateLogData();
    }

    @Test
    public void verifyLogging211() {
        this.logger.info(this.getMarker("info"), this.getMessageToLog());
        this.validateLogData();
    }

    @Test
    public void verifyLogging311() {
        this.logger.info(this.getMarker("info"), this.getMessageToLogWithParams(), (Object)ID2, (Object)ID1);
        this.validateLogData();
    }

    @Test
    public void verifyLogging411() {
        this.logger.info(this.getMarker("info"), this.getMessageToLogWithParams(), new Object[]{ID2, ID1, ID2});
        this.validateLogData();
    }

    @Test
    public void verifyLogging511() {
        this.logger.info(this.getMarker("info"), this.getMessageToLog(), (Throwable)new RuntimeException(ID1, (Throwable)new InvalidTicketException(ID2)));
        this.validateLogData();
    }

    @Test
    public void verifyLogging611() {
        this.logger.info(this.getMessageToLog());
        this.validateLogData();
    }

    @Test
    public void verifyLogging711() {
        this.logger.info(this.getMessageToLogWithParams(), (Object)ID2, (Object)ID1);
        this.validateLogData();
    }

    @Test
    public void verifyLogging811() {
        this.logger.info(this.getMessageToLogWithParams(), new Object[]{ID2, ID1, ID2});
        this.validateLogData();
    }

    @Test
    public void verifyLogging911() {
        this.logger.info(this.getMessageToLog(), (Throwable)new RuntimeException(ID1, (Throwable)new InvalidTicketException(ID2)));
        this.validateLogData();
    }

    @Test
    public void verifyLogging2111() {
        this.logger.warn(this.getMarker("warn"), this.getMessageToLog());
        this.validateLogData();
    }

    @Test
    public void verifyLogging3111() {
        this.logger.warn(this.getMarker("warn"), this.getMessageToLogWithParams(), (Object)ID2, (Object)ID1);
        this.validateLogData();
    }

    @Test
    public void verifyLogging4111() {
        this.logger.warn(this.getMarker("warn"), this.getMessageToLogWithParams(), new Object[]{ID2, ID1, ID2});
        this.validateLogData();
    }

    @Test
    public void verifyLogging5111() {
        this.logger.warn(this.getMarker("warn"), this.getMessageToLog(), (Throwable)new RuntimeException(ID1, (Throwable)new InvalidTicketException(ID2)));
        this.validateLogData();
    }

    @Test
    public void verifyLogging6111() {
        this.logger.warn(this.getMessageToLog());
        this.validateLogData();
    }

    @Test
    public void verifyLogging7111() {
        this.logger.warn(this.getMessageToLogWithParams(), (Object)ID2, (Object)ID1);
        this.validateLogData();
    }

    @Test
    public void verifyLogging8111() {
        this.logger.warn(this.getMessageToLogWithParams(), new Object[]{ID2, ID1, ID2});
        this.validateLogData();
    }

    @Test
    public void verifyLogging9111() {
        this.logger.warn(this.getMessageToLog(), (Throwable)new RuntimeException(ID1, (Throwable)new InvalidTicketException(ID2)));
        this.validateLogData();
    }

    @Test
    public void verifyLogging21110() {
        this.logger.error(this.getMarker("error"), this.getMessageToLog());
        this.validateLogData();
    }

    @Test
    public void verifyLogging31110() {
        this.logger.error(this.getMarker("error"), this.getMessageToLogWithParams(), (Object)ID2, (Object)ID1);
        this.validateLogData();
    }

    @Test
    public void verifyLogging41110() {
        this.logger.error(this.getMarker("error"), this.getMessageToLogWithParams(), new Object[]{ID2, ID1, ID2});
        this.validateLogData();
    }

    @Test
    public void verifyLogging51110() {
        this.logger.error(this.getMarker("error"), this.getMessageToLog(), (Throwable)new RuntimeException(ID1, (Throwable)new InvalidTicketException(ID2)));
        this.validateLogData();
    }

    @Test
    public void verifyLogging61110() {
        this.logger.error(this.getMessageToLog());
        this.validateLogData();
    }

    @Test
    public void verifyLogging71110() {
        this.logger.error(this.getMessageToLogWithParams(), (Object)ID2, (Object)ID1);
        this.validateLogData();
    }

    @Test
    public void verifyLogging81110() {
        this.logger.error(this.getMessageToLogWithParams(), new Object[]{ID2, ID1, ID2});
        this.validateLogData();
    }

    @Test
    public void verifyLogging91110() {
        this.logger.error(this.getMessageToLog(), (Throwable)new RuntimeException(ID1, (Throwable)new InvalidTicketException(ID2)));
        this.validateLogData();
    }

    private String getMessageToLog() {
        return String.format("Here is one %s and here is another %s", ID1, ID2);
    }

    private String getMessageToLogWithParams() {
        return "Here is one {} and here is another {}";
    }

    private void validateLogData() {
        try {
            Assert.assertTrue((String)("Log file " + LOG_FILE.getCanonicalPath() + " does not exist"), (boolean)LOG_FILE.exists());
            String data = FileUtils.readFileToString((File)LOG_FILE);
            Assert.assertTrue((String)("Logged buffer data is blank in " + LOG_FILE.getCanonicalPath()), (boolean)StringUtils.isNotBlank((CharSequence)data));
            Assert.assertFalse((String)"Logged buffer data should not contain TGT-1-B0tjWgMIhUU4kgCZdXbxnWccTFYpTbRbArjaoutXnlNMbIShEu-cas", (boolean)data.contains(ID1));
            Assert.assertFalse((String)"Logged buffer data should not contain PGT-1-B0tjWgMIhUU4kgCZd32xnWccTFYpTbRbArjaoutXnlNMbIShEu-cas", (boolean)data.contains(ID2));
            Assert.assertFalse((String)"Logged buffer data should not contain PGTIOU-1-B0tjWgMIhUU4kgCZd32xnWccTFYpTbRbArjaoutXnlNMbIShEu-cas", (boolean)data.contains(ID3));
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    private Marker getMarker(String name) {
        Marker marker = (Marker)Mockito.mock(Marker.class);
        Mockito.when((Object)marker.getName()).thenReturn((Object)name);
        return marker;
    }
}

