/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas;

import com.codahale.metrics.annotation.Counted;
import com.codahale.metrics.annotation.Metered;
import com.codahale.metrics.annotation.Timed;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections4.Predicate;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.jasig.cas.CentralAuthenticationService;
import org.jasig.cas.CentralAuthenticationServiceImpl$AjcClosure1;
import org.jasig.cas.CentralAuthenticationServiceImpl$AjcClosure11;
import org.jasig.cas.CentralAuthenticationServiceImpl$AjcClosure13;
import org.jasig.cas.CentralAuthenticationServiceImpl$AjcClosure15;
import org.jasig.cas.CentralAuthenticationServiceImpl$AjcClosure3;
import org.jasig.cas.CentralAuthenticationServiceImpl$AjcClosure5;
import org.jasig.cas.CentralAuthenticationServiceImpl$AjcClosure7;
import org.jasig.cas.CentralAuthenticationServiceImpl$AjcClosure9;
import org.jasig.cas.authentication.AcceptAnyAuthenticationPolicyFactory;
import org.jasig.cas.authentication.Authentication;
import org.jasig.cas.authentication.AuthenticationBuilder;
import org.jasig.cas.authentication.AuthenticationException;
import org.jasig.cas.authentication.AuthenticationManager;
import org.jasig.cas.authentication.ContextualAuthenticationPolicy;
import org.jasig.cas.authentication.ContextualAuthenticationPolicyFactory;
import org.jasig.cas.authentication.Credential;
import org.jasig.cas.authentication.DefaultAuthenticationBuilder;
import org.jasig.cas.authentication.MixedPrincipalException;
import org.jasig.cas.authentication.principal.DefaultPrincipalFactory;
import org.jasig.cas.authentication.principal.PersistentIdGenerator;
import org.jasig.cas.authentication.principal.Principal;
import org.jasig.cas.authentication.principal.PrincipalFactory;
import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.logout.LogoutManager;
import org.jasig.cas.logout.LogoutRequest;
import org.jasig.cas.services.AttributeReleasePolicy;
import org.jasig.cas.services.RegisteredService;
import org.jasig.cas.services.ServiceContext;
import org.jasig.cas.services.ServicesManager;
import org.jasig.cas.services.UnauthorizedProxyingException;
import org.jasig.cas.services.UnauthorizedServiceException;
import org.jasig.cas.services.UnauthorizedServiceForPrincipalException;
import org.jasig.cas.services.UnauthorizedSsoServiceException;
import org.jasig.cas.ticket.ExpirationPolicy;
import org.jasig.cas.ticket.InvalidTicketException;
import org.jasig.cas.ticket.ServiceTicket;
import org.jasig.cas.ticket.Ticket;
import org.jasig.cas.ticket.TicketCreationException;
import org.jasig.cas.ticket.TicketException;
import org.jasig.cas.ticket.TicketGrantingTicket;
import org.jasig.cas.ticket.TicketGrantingTicketImpl;
import org.jasig.cas.ticket.UnrecognizableServiceForServiceTicketValidationException;
import org.jasig.cas.ticket.UnsatisfiedAuthenticationPolicyException;
import org.jasig.cas.ticket.registry.TicketRegistry;
import org.jasig.cas.util.DefaultUniqueTicketIdGenerator;
import org.jasig.cas.util.UniqueTicketIdGenerator;
import org.jasig.cas.validation.Assertion;
import org.jasig.cas.validation.ImmutableAssertion;
import org.jasig.inspektr.aspect.TraceLogAspect;
import org.jasig.inspektr.audit.annotation.Audit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public final class CentralAuthenticationServiceImpl
implements CentralAuthenticationService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @NotNull
    private final TicketRegistry ticketRegistry;
    @NotNull
    private final AuthenticationManager authenticationManager;
    @NotNull
    private final UniqueTicketIdGenerator ticketGrantingTicketUniqueTicketIdGenerator;
    @NotNull
    private final Map<String, UniqueTicketIdGenerator> uniqueTicketIdGeneratorsForService;
    @NotNull
    private final ServicesManager servicesManager;
    @NotNull
    private final LogoutManager logoutManager;
    @NotNull
    private ExpirationPolicy ticketGrantingTicketExpirationPolicy;
    @NotNull
    private ExpirationPolicy serviceTicketExpirationPolicy;
    @NotNull
    private ContextualAuthenticationPolicyFactory<ServiceContext> serviceContextAuthenticationPolicyFactory = new AcceptAnyAuthenticationPolicyFactory();
    @NotNull
    private PrincipalFactory principalFactory = new DefaultPrincipalFactory();
    @NotNull
    private final UniqueTicketIdGenerator defaultServiceTicketIdGenerator = new DefaultUniqueTicketIdGenerator();
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;

    public CentralAuthenticationServiceImpl(TicketRegistry ticketRegistry, AuthenticationManager authenticationManager, UniqueTicketIdGenerator ticketGrantingTicketUniqueTicketIdGenerator, Map<String, UniqueTicketIdGenerator> uniqueTicketIdGeneratorsForService, ExpirationPolicy ticketGrantingTicketExpirationPolicy, ExpirationPolicy serviceTicketExpirationPolicy, ServicesManager servicesManager, LogoutManager logoutManager) {
        this.ticketRegistry = ticketRegistry;
        this.authenticationManager = authenticationManager;
        this.ticketGrantingTicketUniqueTicketIdGenerator = ticketGrantingTicketUniqueTicketIdGenerator;
        this.uniqueTicketIdGeneratorsForService = uniqueTicketIdGeneratorsForService;
        this.ticketGrantingTicketExpirationPolicy = ticketGrantingTicketExpirationPolicy;
        this.serviceTicketExpirationPolicy = serviceTicketExpirationPolicy;
        this.servicesManager = servicesManager;
        this.logoutManager = logoutManager;
    }

    @Audit(action="TICKET_GRANTING_TICKET_DESTROYED", actionResolverName="DESTROY_TICKET_GRANTING_TICKET_RESOLVER", resourceResolverName="DESTROY_TICKET_GRANTING_TICKET_RESOURCE_RESOLVER")
    @Timed(name="DESTROY_TICKET_GRANTING_TICKET_TIMER")
    @Metered(name="DESTROY_TICKET_GRANTING_TICKET_METER")
    @Counted(name="DESTROY_TICKET_GRANTING_TICKET_COUNTER", monotonic=true)
    public List<LogoutRequest> destroyTicketGrantingTicket(@NotNull String ticketGrantingTicketId) {
        String string = ticketGrantingTicketId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        return (List)TraceLogAspect.aspectOf().traceMethod(new CentralAuthenticationServiceImpl$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
    }

    @Audit(action="SERVICE_TICKET", actionResolverName="GRANT_SERVICE_TICKET_RESOLVER", resourceResolverName="GRANT_SERVICE_TICKET_RESOURCE_RESOLVER")
    @Timed(name="GRANT_SERVICE_TICKET_TIMER")
    @Metered(name="GRANT_SERVICE_TICKET_METER")
    @Counted(name="GRANT_SERVICE_TICKET_COUNTER", monotonic=true)
    public ServiceTicket grantServiceTicket(String ticketGrantingTicketId, Service service, Credential ... credentials) throws AuthenticationException, TicketException {
        String string = ticketGrantingTicketId;
        Service service2 = service;
        Credential[] credentialArray = credentials;
        Object[] objectArray = new Object[]{string, service2, credentialArray};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, string, service2, credentialArray, joinPoint};
        return (ServiceTicket)TraceLogAspect.aspectOf().traceMethod(new CentralAuthenticationServiceImpl$AjcClosure3(objectArray2).linkClosureAndJoinPoint(69648));
    }

    private static Set<Credential> sanitizeCredentials(Credential[] credentials) {
        if (credentials != null && credentials.length > 0) {
            HashSet<Credential> set = new HashSet<Credential>(Arrays.asList(credentials));
            Iterator it = set.iterator();
            while (it.hasNext()) {
                if (it.next() != null) continue;
                it.remove();
            }
            return set;
        }
        return Collections.emptySet();
    }

    @Audit(action="SERVICE_TICKET", actionResolverName="GRANT_SERVICE_TICKET_RESOLVER", resourceResolverName="GRANT_SERVICE_TICKET_RESOURCE_RESOLVER")
    @Timed(name="GRANT_SERVICE_TICKET_TIMER")
    @Metered(name="GRANT_SERVICE_TICKET_METER")
    @Counted(name="GRANT_SERVICE_TICKET_COUNTER", monotonic=true)
    public ServiceTicket grantServiceTicket(String ticketGrantingTicketId, Service service) throws TicketException {
        String string = ticketGrantingTicketId;
        Service service2 = service;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)string, (Object)service2);
        Object[] objectArray = new Object[]{this, string, service2, joinPoint};
        return (ServiceTicket)TraceLogAspect.aspectOf().traceMethod(new CentralAuthenticationServiceImpl$AjcClosure5(objectArray).linkClosureAndJoinPoint(69648));
    }

    @Audit(action="PROXY_GRANTING_TICKET", actionResolverName="GRANT_PROXY_GRANTING_TICKET_RESOLVER", resourceResolverName="GRANT_PROXY_GRANTING_TICKET_RESOURCE_RESOLVER")
    @Timed(name="GRANT_PROXY_GRANTING_TICKET_TIMER")
    @Metered(name="GRANT_PROXY_GRANTING_TICKET_METER")
    @Counted(name="GRANT_PROXY_GRANTING_TICKET_COUNTER", monotonic=true)
    public TicketGrantingTicket delegateTicketGrantingTicket(String serviceTicketId, Credential ... credentials) throws AuthenticationException, TicketException {
        String string = serviceTicketId;
        Credential[] credentialArray = credentials;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)string, (Object)credentialArray);
        Object[] objectArray = new Object[]{this, string, credentialArray, joinPoint};
        return (TicketGrantingTicket)TraceLogAspect.aspectOf().traceMethod(new CentralAuthenticationServiceImpl$AjcClosure7(objectArray).linkClosureAndJoinPoint(69648));
    }

    @Audit(action="SERVICE_TICKET_VALIDATE", actionResolverName="VALIDATE_SERVICE_TICKET_RESOLVER", resourceResolverName="VALIDATE_SERVICE_TICKET_RESOURCE_RESOLVER")
    @Timed(name="VALIDATE_SERVICE_TICKET_TIMER")
    @Metered(name="VALIDATE_SERVICE_TICKET_METER")
    @Counted(name="VALIDATE_SERVICE_TICKET_COUNTER", monotonic=true)
    public Assertion validateServiceTicket(String serviceTicketId, Service service) throws TicketException {
        String string = serviceTicketId;
        Service service2 = service;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)string, (Object)service2);
        Object[] objectArray = new Object[]{this, string, service2, joinPoint};
        return (Assertion)TraceLogAspect.aspectOf().traceMethod(new CentralAuthenticationServiceImpl$AjcClosure9(objectArray).linkClosureAndJoinPoint(69648));
    }

    @Audit(action="TICKET_GRANTING_TICKET", actionResolverName="CREATE_TICKET_GRANTING_TICKET_RESOLVER", resourceResolverName="CREATE_TICKET_GRANTING_TICKET_RESOURCE_RESOLVER")
    @Timed(name="CREATE_TICKET_GRANTING_TICKET_TIMER")
    @Metered(name="CREATE_TICKET_GRANTING_TICKET_METER")
    @Counted(name="CREATE_TICKET_GRANTING_TICKET_COUNTER", monotonic=true)
    public TicketGrantingTicket createTicketGrantingTicket(Credential ... credentials) throws AuthenticationException, TicketException {
        Credential[] credentialArray = credentials;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)credentialArray);
        Object[] objectArray = new Object[]{this, credentialArray, joinPoint};
        return (TicketGrantingTicket)TraceLogAspect.aspectOf().traceMethod(new CentralAuthenticationServiceImpl$AjcClosure11(objectArray).linkClosureAndJoinPoint(69648));
    }

    @Timed(name="GET_TICKET_TIMER")
    @Metered(name="GET_TICKET_METER")
    @Counted(name="GET_TICKET_COUNTER", monotonic=true)
    public <T extends Ticket> T getTicket(String ticketId, Class<? extends Ticket> clazz) throws InvalidTicketException {
        String string = ticketId;
        Class<? extends Ticket> clazz2 = clazz;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)string, clazz2);
        Object[] objectArray = new Object[]{this, string, clazz2, joinPoint};
        return (T)((Ticket)TraceLogAspect.aspectOf().traceMethod(new CentralAuthenticationServiceImpl$AjcClosure13(objectArray).linkClosureAndJoinPoint(69648)));
    }

    @Timed(name="GET_TICKETS_TIMER")
    @Metered(name="GET_TICKETS_METER")
    @Counted(name="GET_TICKETS_COUNTER", monotonic=true)
    public Collection<Ticket> getTickets(Predicate predicate) {
        Predicate predicate2 = predicate;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object)predicate2);
        Object[] objectArray = new Object[]{this, predicate2, joinPoint};
        return (Collection)TraceLogAspect.aspectOf().traceMethod(new CentralAuthenticationServiceImpl$AjcClosure15(objectArray).linkClosureAndJoinPoint(69648));
    }

    public void setServiceContextAuthenticationPolicyFactory(ContextualAuthenticationPolicyFactory<ServiceContext> policy) {
        this.serviceContextAuthenticationPolicyFactory = policy;
    }

    public void setTicketGrantingTicketExpirationPolicy(ExpirationPolicy ticketGrantingTicketExpirationPolicy) {
        this.ticketGrantingTicketExpirationPolicy = ticketGrantingTicketExpirationPolicy;
    }

    public void setServiceTicketExpirationPolicy(ExpirationPolicy serviceTicketExpirationPolicy) {
        this.serviceTicketExpirationPolicy = serviceTicketExpirationPolicy;
    }

    @Deprecated
    public void setPersistentIdGenerator(PersistentIdGenerator persistentIdGenerator) {
        this.logger.warn("setPersistentIdGenerator() is deprecated and no longer available. Consider configuring the an attribute provider for service definitions.");
    }

    public void setPrincipalFactory(PrincipalFactory principalFactory) {
        this.principalFactory = principalFactory;
    }

    private Authentication getAuthenticationSatisfiedByPolicy(TicketGrantingTicket ticket, ServiceContext context) throws TicketException {
        ContextualAuthenticationPolicy policy = this.serviceContextAuthenticationPolicyFactory.createPolicy((Object)context);
        if (policy.isSatisfiedBy(ticket.getAuthentication())) {
            return ticket.getAuthentication();
        }
        for (Authentication auth : ticket.getSupplementalAuthentications()) {
            if (!policy.isSatisfiedBy(auth)) continue;
            return auth;
        }
        throw new UnsatisfiedAuthenticationPolicyException(policy);
    }

    private void verifyRegisteredServiceProperties(RegisteredService registeredService, Service service) {
        if (registeredService == null) {
            String msg = String.format("ServiceManagement: Unauthorized Service Access. Service [%s] is not found in service registry.", service.getId());
            this.logger.warn(msg);
            throw new UnauthorizedServiceException("screen.service.error.message", msg);
        }
        if (!registeredService.getAccessStrategy().isServiceAccessAllowed()) {
            String msg = String.format("ServiceManagement: Unauthorized Service Access. Service [%s] is not enabled in service registry.", service.getId());
            this.logger.warn(msg);
            throw new UnauthorizedServiceException("screen.service.error.message", msg);
        }
    }

    static {
        CentralAuthenticationServiceImpl.ajc$preClinit();
    }

    static final /* synthetic */ List destroyTicketGrantingTicket_aroundBody0(CentralAuthenticationServiceImpl ajc$this, String ticketGrantingTicketId, JoinPoint joinPoint) {
        try {
            ajc$this.logger.debug("Removing ticket [{}] from registry...", (Object)ticketGrantingTicketId);
            TicketGrantingTicket ticket = (TicketGrantingTicket)ajc$this.getTicket(ticketGrantingTicketId, TicketGrantingTicket.class);
            ajc$this.logger.debug("Ticket found. Processing logout requests and then deleting the ticket...");
            List logoutRequests = ajc$this.logoutManager.performLogout(ticket);
            ajc$this.ticketRegistry.deleteTicket(ticketGrantingTicketId);
            return logoutRequests;
        }
        catch (InvalidTicketException e) {
            ajc$this.logger.debug("TicketGrantingTicket [{}] cannot be found in the ticket registry.", (Object)ticketGrantingTicketId);
            return Collections.emptyList();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    static final /* synthetic */ ServiceTicket grantServiceTicket_aroundBody2(CentralAuthenticationServiceImpl ajc$this, String ticketGrantingTicketId, Service service, Credential[] credentials, JoinPoint joinPoint) {
        TicketGrantingTicket ticketGrantingTicket = (TicketGrantingTicket)ajc$this.getTicket(ticketGrantingTicketId, TicketGrantingTicket.class);
        RegisteredService registeredService = ajc$this.servicesManager.findServiceBy(service);
        ajc$this.verifyRegisteredServiceProperties(registeredService, service);
        Set<Credential> sanitizedCredentials = CentralAuthenticationServiceImpl.sanitizeCredentials(credentials);
        Authentication currentAuthentication = null;
        if (sanitizedCredentials.size() > 0) {
            currentAuthentication = ajc$this.authenticationManager.authenticate(sanitizedCredentials.toArray(new Credential[0]));
            Authentication original = ticketGrantingTicket.getAuthentication();
            if (!currentAuthentication.getPrincipal().equals(original.getPrincipal())) {
                throw new MixedPrincipalException(currentAuthentication, currentAuthentication.getPrincipal(), original.getPrincipal());
            }
            ticketGrantingTicket.getSupplementalAuthentications().add(currentAuthentication);
        }
        if (currentAuthentication == null && !registeredService.getAccessStrategy().isServiceAccessAllowedForSso()) {
            ajc$this.logger.warn("ServiceManagement: Service [{}] is not allowed to use SSO.", (Object)service.getId());
            throw new UnauthorizedSsoServiceException();
        }
        Service proxiedBy = ticketGrantingTicket.getProxiedBy();
        if (proxiedBy != null) {
            ajc$this.logger.debug("TGT is proxied by [{}]. Locating proxy service in registry...", (Object)proxiedBy.getId());
            RegisteredService proxyingService = ajc$this.servicesManager.findServiceBy(proxiedBy);
            if (proxyingService == null) {
                ajc$this.logger.warn("No proxying service found. Proxy attempt by service [{}] (registered service [{}]) is not allowed.", (Object)service.getId(), (Object)registeredService.getId());
                throw new UnauthorizedProxyingException("Proxying is not allowed for registered service " + registeredService.getId());
            }
            ajc$this.logger.debug("Located proxying service [{}] in the service registry", (Object)proxyingService);
            if (!proxyingService.getProxyPolicy().isAllowedToProxy()) {
                ajc$this.logger.warn("Found proxying service {}, but it is not authorized to fulfill the proxy attempt made by {}", (Object)proxyingService.getId(), (Object)service.getId());
                throw new UnauthorizedProxyingException("Proxying is not allowed for registered service " + registeredService.getId());
            }
        } else {
            ajc$this.logger.trace("TGT is not proxied by another service");
        }
        ajc$this.getAuthenticationSatisfiedByPolicy(ticketGrantingTicket, new ServiceContext(service, registeredService));
        List authentications = ticketGrantingTicket.getChainedAuthentications();
        Principal principal = ((Authentication)authentications.get(authentications.size() - 1)).getPrincipal();
        Map principalAttrs = registeredService.getAttributeReleasePolicy().getAttributes(principal);
        if (!registeredService.getAccessStrategy().doPrincipalAttributesAllowServiceAccess(principalAttrs)) {
            ajc$this.logger.warn("ServiceManagement: Cannot grant service ticket because Service [{}] is not authorized for use by [{}].", (Object)service.getId(), (Object)principal);
            throw new UnauthorizedServiceForPrincipalException();
        }
        String uniqueTicketIdGenKey = service.getClass().getName();
        ajc$this.logger.debug("Looking up service ticket id generator for [{}]", (Object)uniqueTicketIdGenKey);
        UniqueTicketIdGenerator serviceTicketUniqueTicketIdGenerator = ajc$this.uniqueTicketIdGeneratorsForService.get(uniqueTicketIdGenKey);
        if (serviceTicketUniqueTicketIdGenerator == null) {
            serviceTicketUniqueTicketIdGenerator = ajc$this.defaultServiceTicketIdGenerator;
            ajc$this.logger.debug("Service ticket id generator not found for [{}]. Using the default generator...", (Object)uniqueTicketIdGenKey);
        }
        String ticketPrefix = authentications.size() == 1 ? "ST" : "PT";
        String ticketId = serviceTicketUniqueTicketIdGenerator.getNewTicketId(ticketPrefix);
        ServiceTicket serviceTicket = ticketGrantingTicket.grantServiceTicket(ticketId, service, ajc$this.serviceTicketExpirationPolicy, currentAuthentication != null);
        ajc$this.ticketRegistry.addTicket((Ticket)serviceTicket);
        ajc$this.logger.info("Granted ticket [{}] for service [{}] for user [{}]", new Object[]{serviceTicket.getId(), service.getId(), principal.getId()});
        return serviceTicket;
    }

    static final /* synthetic */ ServiceTicket grantServiceTicket_aroundBody4(CentralAuthenticationServiceImpl ajc$this, String ticketGrantingTicketId, Service service, JoinPoint joinPoint) {
        try {
            return ajc$this.grantServiceTicket(ticketGrantingTicketId, service, null);
        }
        catch (AuthenticationException e) {
            throw new IllegalStateException("Unexpected authentication exception", e);
        }
    }

    static final /* synthetic */ TicketGrantingTicket delegateTicketGrantingTicket_aroundBody6(CentralAuthenticationServiceImpl ajc$this, String serviceTicketId, Credential[] credentials, JoinPoint joinPoint) {
        ServiceTicket serviceTicket = (ServiceTicket)ajc$this.ticketRegistry.getTicket(serviceTicketId, ServiceTicket.class);
        if (serviceTicket == null || serviceTicket.isExpired()) {
            ajc$this.logger.debug("ServiceTicket [{}] has expired or cannot be found in the ticket registry", (Object)serviceTicketId);
            throw new InvalidTicketException(serviceTicketId);
        }
        RegisteredService registeredService = ajc$this.servicesManager.findServiceBy(serviceTicket.getService());
        ajc$this.verifyRegisteredServiceProperties(registeredService, serviceTicket.getService());
        if (!registeredService.getProxyPolicy().isAllowedToProxy()) {
            ajc$this.logger.warn("ServiceManagement: Service [{}] attempted to proxy, but is not allowed.", (Object)serviceTicket.getService().getId());
            throw new UnauthorizedProxyingException();
        }
        Authentication authentication = ajc$this.authenticationManager.authenticate(credentials);
        String pgtId = ajc$this.ticketGrantingTicketUniqueTicketIdGenerator.getNewTicketId("PGT");
        TicketGrantingTicket proxyGrantingTicket = serviceTicket.grantTicketGrantingTicket(pgtId, authentication, ajc$this.ticketGrantingTicketExpirationPolicy);
        ajc$this.logger.debug("Generated proxy granting ticket [{}] based off of [{}]", (Object)proxyGrantingTicket, (Object)serviceTicketId);
        ajc$this.ticketRegistry.addTicket((Ticket)proxyGrantingTicket);
        return proxyGrantingTicket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final /* synthetic */ Assertion validateServiceTicket_aroundBody8(CentralAuthenticationServiceImpl ajc$this, String serviceTicketId, Service service, JoinPoint joinPoint) {
        RegisteredService registeredService = ajc$this.servicesManager.findServiceBy(service);
        ajc$this.verifyRegisteredServiceProperties(registeredService, service);
        ServiceTicket serviceTicket = (ServiceTicket)ajc$this.ticketRegistry.getTicket(serviceTicketId, ServiceTicket.class);
        if (serviceTicket == null) {
            ajc$this.logger.info("Service ticket [{}] does not exist.", (Object)serviceTicketId);
            throw new InvalidTicketException(serviceTicketId);
        }
        try {
            ServiceTicket serviceTicket2 = serviceTicket;
            synchronized (serviceTicket2) {
                if (serviceTicket.isExpired()) {
                    ajc$this.logger.info("ServiceTicket [{}] has expired.", (Object)serviceTicketId);
                    throw new InvalidTicketException(serviceTicketId);
                }
                if (!serviceTicket.isValidFor(service)) {
                    ajc$this.logger.error("Service ticket [{}] with service [{}] does not match supplied service [{}]", new Object[]{serviceTicketId, serviceTicket.getService().getId(), service});
                    throw new UnrecognizableServiceForServiceTicketValidationException(serviceTicket.getService());
                }
            }
            TicketGrantingTicket root = serviceTicket.getGrantingTicket().getRoot();
            Authentication authentication = ajc$this.getAuthenticationSatisfiedByPolicy(root, new ServiceContext(serviceTicket.getService(), registeredService));
            Principal principal = authentication.getPrincipal();
            AttributeReleasePolicy attributePolicy = registeredService.getAttributeReleasePolicy();
            ajc$this.logger.debug("Attribute policy [{}] is associated with service [{}]", (Object)attributePolicy, (Object)registeredService);
            Map attributesToRelease = attributePolicy != null ? attributePolicy.getAttributes(principal) : Collections.EMPTY_MAP;
            String principalId = registeredService.getUsernameAttributeProvider().resolveUsername(principal, service);
            Principal modifiedPrincipal = ajc$this.principalFactory.createPrincipal(principalId, attributesToRelease);
            AuthenticationBuilder builder = DefaultAuthenticationBuilder.newInstance(authentication);
            builder.setPrincipal(modifiedPrincipal);
            ImmutableAssertion immutableAssertion = new ImmutableAssertion(builder.build(), serviceTicket.getGrantingTicket().getChainedAuthentications(), serviceTicket.getService(), serviceTicket.isFromNewLogin());
            return immutableAssertion;
        }
        finally {
            if (serviceTicket.isExpired()) {
                ajc$this.ticketRegistry.deleteTicket(serviceTicketId);
            }
        }
    }

    static final /* synthetic */ TicketGrantingTicket createTicketGrantingTicket_aroundBody10(CentralAuthenticationServiceImpl ajc$this, Credential[] credentials, JoinPoint joinPoint) {
        Set<Credential> sanitizedCredentials = CentralAuthenticationServiceImpl.sanitizeCredentials(credentials);
        if (!sanitizedCredentials.isEmpty()) {
            Authentication authentication = ajc$this.authenticationManager.authenticate(credentials);
            TicketGrantingTicketImpl ticketGrantingTicket = new TicketGrantingTicketImpl(ajc$this.ticketGrantingTicketUniqueTicketIdGenerator.getNewTicketId("TGT"), authentication, ajc$this.ticketGrantingTicketExpirationPolicy);
            ajc$this.ticketRegistry.addTicket((Ticket)ticketGrantingTicket);
            return ticketGrantingTicket;
        }
        String msg = "No credentials were specified in the request for creating a new ticket-granting ticket";
        ajc$this.logger.warn("No credentials were specified in the request for creating a new ticket-granting ticket");
        throw new TicketCreationException(new IllegalArgumentException("No credentials were specified in the request for creating a new ticket-granting ticket"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final /* synthetic */ Ticket getTicket_aroundBody12(CentralAuthenticationServiceImpl ajc$this, String ticketId, Class clazz, JoinPoint joinPoint) {
        Assert.notNull((Object)ticketId, (String)"ticketId cannot be null");
        Ticket ticket = ajc$this.ticketRegistry.getTicket(ticketId, clazz);
        if (ticket == null) {
            ajc$this.logger.debug("Ticket [{}] by type [{}] cannot be found in the ticket registry.", (Object)ticketId, (Object)clazz.getSimpleName());
            throw new InvalidTicketException(ticketId);
        }
        if (ticket instanceof TicketGrantingTicket) {
            Ticket ticket2 = ticket;
            synchronized (ticket2) {
                if (ticket.isExpired()) {
                    ajc$this.ticketRegistry.deleteTicket(ticketId);
                    ajc$this.logger.debug("Ticket [{}] has expired and is now deleted from the ticket registry.", (Object)ticketId);
                    throw new InvalidTicketException(ticketId);
                }
            }
        }
        return ticket;
    }

    static final /* synthetic */ Collection getTickets_aroundBody14(CentralAuthenticationServiceImpl ajc$this, Predicate predicate, JoinPoint joinPoint) {
        HashSet c = new HashSet(ajc$this.ticketRegistry.getTickets());
        Iterator it = c.iterator();
        while (it.hasNext()) {
            if (predicate.evaluate(it.next())) continue;
            it.remove();
        }
        return c;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("CentralAuthenticationServiceImpl.java", CentralAuthenticationServiceImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "destroyTicketGrantingTicket", "org.jasig.cas.CentralAuthenticationServiceImpl", "java.lang.String", "ticketGrantingTicketId", "", "java.util.List"), 215);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("81", "grantServiceTicket", "org.jasig.cas.CentralAuthenticationServiceImpl", "java.lang.String:org.jasig.cas.authentication.principal.Service:[Lorg.jasig.cas.authentication.Credential;", "ticketGrantingTicketId:service:credentials", "org.jasig.cas.authentication.AuthenticationException:org.jasig.cas.ticket.TicketException", "org.jasig.cas.ticket.ServiceTicket"), 241);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "grantServiceTicket", "org.jasig.cas.CentralAuthenticationServiceImpl", "java.lang.String:org.jasig.cas.authentication.principal.Service", "ticketGrantingTicketId:service", "org.jasig.cas.ticket.TicketException", "org.jasig.cas.ticket.ServiceTicket"), 358);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("81", "delegateTicketGrantingTicket", "org.jasig.cas.CentralAuthenticationServiceImpl", "java.lang.String:[Lorg.jasig.cas.authentication.Credential;", "serviceTicketId:credentials", "org.jasig.cas.authentication.AuthenticationException:org.jasig.cas.ticket.TicketException", "org.jasig.cas.ticket.TicketGrantingTicket"), 375);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "validateServiceTicket", "org.jasig.cas.CentralAuthenticationServiceImpl", "java.lang.String:org.jasig.cas.authentication.principal.Service", "serviceTicketId:service", "org.jasig.cas.ticket.TicketException", "org.jasig.cas.validation.Assertion"), 420);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("81", "createTicketGrantingTicket", "org.jasig.cas.CentralAuthenticationServiceImpl", "[Lorg.jasig.cas.authentication.Credential;", "credentials", "org.jasig.cas.authentication.AuthenticationException:org.jasig.cas.ticket.TicketException", "org.jasig.cas.ticket.TicketGrantingTicket"), 484);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTicket", "org.jasig.cas.CentralAuthenticationServiceImpl", "java.lang.String:java.lang.Class", "ticketId:clazz", "org.jasig.cas.ticket.InvalidTicketException", "org.jasig.cas.ticket.Ticket"), 515);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTickets", "org.jasig.cas.CentralAuthenticationServiceImpl", "org.apache.commons.collections4.Predicate", "predicate", "", "java.util.Collection"), 542);
    }
}

