/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.authentication;

import com.codahale.metrics.annotation.Counted;
import com.codahale.metrics.annotation.Metered;
import com.codahale.metrics.annotation.Timed;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.jasig.cas.authentication.AnyAuthenticationPolicy;
import org.jasig.cas.authentication.Authentication;
import org.jasig.cas.authentication.AuthenticationBuilder;
import org.jasig.cas.authentication.AuthenticationException;
import org.jasig.cas.authentication.AuthenticationHandler;
import org.jasig.cas.authentication.AuthenticationManager;
import org.jasig.cas.authentication.AuthenticationMetaDataPopulator;
import org.jasig.cas.authentication.AuthenticationPolicy;
import org.jasig.cas.authentication.BasicCredentialMetaData;
import org.jasig.cas.authentication.Credential;
import org.jasig.cas.authentication.DefaultAuthenticationBuilder;
import org.jasig.cas.authentication.HandlerResult;
import org.jasig.cas.authentication.PolicyBasedAuthenticationManager$AjcClosure1;
import org.jasig.cas.authentication.PreventedException;
import org.jasig.cas.authentication.UnresolvedPrincipalException;
import org.jasig.cas.authentication.principal.NullPrincipal;
import org.jasig.cas.authentication.principal.Principal;
import org.jasig.cas.authentication.principal.PrincipalResolver;
import org.jasig.inspektr.aspect.TraceLogAspect;
import org.jasig.inspektr.audit.annotation.Audit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class PolicyBasedAuthenticationManager
implements AuthenticationManager {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    @NotNull
    private List<AuthenticationMetaDataPopulator> authenticationMetaDataPopulators = new ArrayList<AuthenticationMetaDataPopulator>();
    @NotNull
    private AuthenticationPolicy authenticationPolicy = new AnyAuthenticationPolicy();
    @NotNull
    private final Map<AuthenticationHandler, PrincipalResolver> handlerResolverMap;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public PolicyBasedAuthenticationManager(AuthenticationHandler ... handlers) {
        this(Arrays.asList(handlers));
    }

    public PolicyBasedAuthenticationManager(List<AuthenticationHandler> handlers) {
        Assert.notEmpty(handlers, (String)"At least one authentication handler is required");
        this.handlerResolverMap = new LinkedHashMap<AuthenticationHandler, PrincipalResolver>(handlers.size());
        for (AuthenticationHandler handler : handlers) {
            this.handlerResolverMap.put(handler, null);
        }
    }

    public PolicyBasedAuthenticationManager(Map<AuthenticationHandler, PrincipalResolver> map) {
        Assert.notEmpty(map, (String)"At least one authentication handler is required");
        this.handlerResolverMap = map;
    }

    @Audit(action="AUTHENTICATION", actionResolverName="AUTHENTICATION_RESOLVER", resourceResolverName="AUTHENTICATION_RESOURCE_RESOLVER")
    @Timed(name="AUTHENTICATE")
    @Metered(name="AUTHENTICATE")
    @Counted(name="AUTHENTICATE", monotonic=true)
    public final Authentication authenticate(Credential ... credentials) throws AuthenticationException {
        Credential[] credentialArray = credentials;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)credentialArray);
        Object[] objectArray = new Object[]{this, credentialArray, joinPoint};
        return (Authentication)TraceLogAspect.aspectOf().traceMethod(new PolicyBasedAuthenticationManager$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
    }

    public final void setAuthenticationMetaDataPopulators(List<AuthenticationMetaDataPopulator> populators) {
        this.authenticationMetaDataPopulators = populators;
    }

    public void setAuthenticationPolicy(AuthenticationPolicy policy) {
        this.authenticationPolicy = policy;
    }

    protected AuthenticationBuilder authenticateInternal(Credential ... credentials) throws AuthenticationException {
        DefaultAuthenticationBuilder builder = new DefaultAuthenticationBuilder(NullPrincipal.getInstance());
        for (Credential c : credentials) {
            builder.addCredential(new BasicCredentialMetaData(c));
        }
        for (Credential credential : credentials) {
            boolean found = false;
            for (Map.Entry<AuthenticationHandler, PrincipalResolver> entry : this.handlerResolverMap.entrySet()) {
                AuthenticationHandler handler = entry.getKey();
                if (!handler.supports(credential)) continue;
                found = true;
                try {
                    Principal principal;
                    HandlerResult result = handler.authenticate(credential);
                    builder.addSuccess(handler.getName(), result);
                    this.logger.info("{} successfully authenticated {}", (Object)handler.getName(), (Object)credential);
                    PrincipalResolver resolver = entry.getValue();
                    if (resolver == null) {
                        principal = result.getPrincipal();
                        this.logger.debug("No resolver configured for {}. Falling back to handler principal {}", (Object)handler.getName(), (Object)principal);
                    } else {
                        principal = this.resolvePrincipal(handler.getName(), resolver, credential);
                    }
                    if (principal != null) {
                        builder.setPrincipal(principal);
                    }
                    if (!this.authenticationPolicy.isSatisfiedBy(builder.build())) continue;
                    return builder;
                }
                catch (GeneralSecurityException e) {
                    this.logger.info("{} failed authenticating {}", (Object)handler.getName(), (Object)credential);
                    this.logger.debug("{} exception details: {}", (Object)handler.getName(), (Object)e.getMessage());
                    builder.addFailure(handler.getName(), e.getClass());
                }
                catch (PreventedException e) {
                    this.logger.error("{}: {}  (Details: {})", new Object[]{handler.getName(), e.getMessage(), e.getCause().getMessage()});
                    builder.addFailure(handler.getName(), ((Object)((Object)e)).getClass());
                }
            }
            if (found) continue;
            this.logger.warn("Cannot find authentication handler that supports {}, which suggests a configuration problem.", (Object)credential);
        }
        if (builder.getSuccesses().isEmpty()) {
            throw new AuthenticationException(builder.getFailures(), builder.getSuccesses());
        }
        if (!this.authenticationPolicy.isSatisfiedBy(builder.build())) {
            throw new AuthenticationException(builder.getFailures(), builder.getSuccesses());
        }
        return builder;
    }

    protected Principal resolvePrincipal(String handlerName, PrincipalResolver resolver, Credential credential) {
        if (resolver.supports(credential)) {
            try {
                Principal p = resolver.resolve(credential);
                this.logger.debug("{} resolved {} from {}", new Object[]{resolver, p, credential});
                return p;
            }
            catch (Exception e) {
                this.logger.error("{} failed to resolve principal from {}", new Object[]{resolver, credential, e});
            }
        } else {
            this.logger.warn("{} is configured to use {} but it does not support {}, which suggests a configuration problem.", new Object[]{handlerName, resolver, credential});
        }
        return null;
    }

    static {
        PolicyBasedAuthenticationManager.ajc$preClinit();
    }

    static final /* synthetic */ Authentication authenticate_aroundBody0(PolicyBasedAuthenticationManager ajc$this, Credential[] credentials, JoinPoint joinPoint) {
        AuthenticationBuilder builder = ajc$this.authenticateInternal(credentials);
        Authentication authentication = builder.build();
        Principal principal = authentication.getPrincipal();
        if (principal instanceof NullPrincipal) {
            throw new UnresolvedPrincipalException(authentication);
        }
        for (HandlerResult result : authentication.getSuccesses().values()) {
            builder.addAttribute("authenticationMethod", (Object)result.getHandlerName());
        }
        ajc$this.logger.info("Authenticated {} with credentials {}.", (Object)principal, Arrays.asList(credentials));
        ajc$this.logger.debug("Attribute map for {}: {}", (Object)principal.getId(), (Object)principal.getAttributes());
        for (AuthenticationMetaDataPopulator populator : ajc$this.authenticationMetaDataPopulators) {
            for (Credential credential : credentials) {
                if (!populator.supports(credential)) continue;
                populator.populateAttributes(builder, credential);
            }
        }
        return builder.build();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("PolicyBasedAuthenticationManager.java", PolicyBasedAuthenticationManager.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("91", "authenticate", "org.jasig.cas.authentication.PolicyBasedAuthenticationManager", "[Lorg.jasig.cas.authentication.Credential;", "credentials", "org.jasig.cas.authentication.AuthenticationException", "org.jasig.cas.authentication.Authentication"), 149);
    }
}

