/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.authentication.handler.support;

import java.security.GeneralSecurityException;
import java.security.Principal;
import java.util.Set;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.validation.constraints.NotNull;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.jasig.cas.authentication.HandlerResult;
import org.jasig.cas.authentication.PreventedException;
import org.jasig.cas.authentication.UsernamePasswordCredential;
import org.jasig.cas.authentication.handler.support.AbstractUsernamePasswordAuthenticationHandler;
import org.jasig.cas.authentication.handler.support.JaasAuthenticationHandler$UsernamePasswordCallbackHandler$AjcClosure1;
import org.jasig.inspektr.aspect.TraceLogAspect;
import org.springframework.util.Assert;

public class JaasAuthenticationHandler
extends AbstractUsernamePasswordAuthenticationHandler {
    private static final String DEFAULT_REALM = "CAS";
    private static final String SYS_PROP_KRB5_REALM = "java.security.krb5.realm";
    private static final String SYS_PROP_KERB5_KDC = "java.security.krb5.kdc";
    @NotNull
    private String realm = "CAS";
    private String kerberosRealmSystemProperty;
    private String kerberosKdcSystemProperty;

    public JaasAuthenticationHandler() {
        Assert.notNull((Object)Configuration.getConfiguration(), (String)"Static Configuration cannot be null. Did you remember to specify \"java.security.auth.login.config\"?");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final HandlerResult authenticateUsernamePasswordInternal(UsernamePasswordCredential credential) throws GeneralSecurityException, PreventedException {
        if (this.kerberosKdcSystemProperty != null) {
            this.logger.debug("Setting kerberos system property {} to {}", (Object)SYS_PROP_KERB5_KDC, (Object)this.kerberosKdcSystemProperty);
            System.setProperty(SYS_PROP_KERB5_KDC, this.kerberosKdcSystemProperty);
        }
        if (this.kerberosRealmSystemProperty != null) {
            this.logger.debug("Setting kerberos system property {} to {}", (Object)SYS_PROP_KRB5_REALM, (Object)this.kerberosRealmSystemProperty);
            System.setProperty(SYS_PROP_KRB5_REALM, this.kerberosRealmSystemProperty);
        }
        String username = credential.getUsername();
        String password = this.getPasswordEncoder().encode(credential.getPassword());
        LoginContext lc = new LoginContext(this.realm, new UsernamePasswordCallbackHandler(username, password));
        try {
            this.logger.debug("Attempting authentication for: {}", (Object)username);
            lc.login();
        }
        finally {
            lc.logout();
        }
        org.jasig.cas.authentication.principal.Principal principal = null;
        Set<Principal> principals = lc.getSubject().getPrincipals();
        if (principals != null && principals.size() > 0) {
            principal = this.principalFactory.createPrincipal(principals.iterator().next().getName());
        }
        return this.createHandlerResult(credential, principal, null);
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    public final void setKerberosRealmSystemProperty(String kerberosRealmSystemProperty) {
        this.kerberosRealmSystemProperty = kerberosRealmSystemProperty;
    }

    public final void setKerberosKdcSystemProperty(String kerberosKdcSystemProperty) {
        this.kerberosKdcSystemProperty = kerberosKdcSystemProperty;
    }

    protected static final class UsernamePasswordCallbackHandler
    implements CallbackHandler {
        private final String userName;
        private final String password;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

        protected UsernamePasswordCallbackHandler(String userName, String password) {
            this.userName = userName;
            this.password = password;
        }

        @Override
        public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
            Callback[] callbackArray = callbacks;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)callbackArray);
            Object[] objectArray = new Object[]{this, callbackArray, joinPoint};
            TraceLogAspect.aspectOf().traceMethod(new JaasAuthenticationHandler$UsernamePasswordCallbackHandler$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
        }

        static {
            UsernamePasswordCallbackHandler.ajc$preClinit();
        }

        static final /* synthetic */ void handle_aroundBody0(UsernamePasswordCallbackHandler ajc$this, Callback[] callbacks, JoinPoint joinPoint) {
            for (Callback callback : callbacks) {
                if (callback.getClass().equals(NameCallback.class)) {
                    ((NameCallback)callback).setName(ajc$this.userName);
                    continue;
                }
                if (callback.getClass().equals(PasswordCallback.class)) {
                    ((PasswordCallback)callback).setPassword(ajc$this.password.toCharArray());
                    continue;
                }
                throw new UnsupportedCallbackException(callback, "Unrecognized Callback");
            }
        }

        private static /* synthetic */ void ajc$preClinit() {
            Factory factory = new Factory("JaasAuthenticationHandler.java", UsernamePasswordCallbackHandler.class);
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "handle", "org.jasig.cas.authentication.handler.support.JaasAuthenticationHandler$UsernamePasswordCallbackHandler", "[Ljavax.security.auth.callback.Callback;", "callbacks", "javax.security.auth.callback.UnsupportedCallbackException", "void"), 220);
        }
    }
}

