/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.services;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.jasig.cas.services.AbstractRegisteredService;
import org.jasig.cas.services.JsonServiceRegistryConfigWatcher;
import org.jasig.cas.services.JsonServiceRegistryDao$AjcClosure1;
import org.jasig.cas.services.JsonServiceRegistryDao$AjcClosure3;
import org.jasig.cas.services.JsonServiceRegistryDao$AjcClosure5;
import org.jasig.cas.services.JsonServiceRegistryDao$AjcClosure7;
import org.jasig.cas.services.RegisteredService;
import org.jasig.cas.services.ReloadableServicesManager;
import org.jasig.cas.services.ServiceRegistryDao;
import org.jasig.cas.util.JsonSerializer;
import org.jasig.cas.util.LockedOutputStream;
import org.jasig.cas.util.services.RegisteredServiceJsonSerializer;
import org.jasig.inspektr.aspect.TraceLogAspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.util.Assert;

public class JsonServiceRegistryDao
implements ServiceRegistryDao,
ApplicationContextAware {
    private static final Logger LOGGER;
    private static final String FILE_EXTENSION = "json";
    private Map<Long, RegisteredService> serviceMap = new ConcurrentHashMap<Long, RegisteredService>();
    private final Path serviceRegistryDirectory;
    private final JsonSerializer<RegisteredService> registeredServiceJsonSerializer;
    private ApplicationContext applicationContext;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;

    public JsonServiceRegistryDao(Path configDirectory, JsonSerializer<RegisteredService> registeredServiceJsonSerializer) {
        this.serviceRegistryDirectory = configDirectory;
        Assert.isTrue((boolean)this.serviceRegistryDirectory.toFile().exists(), (String)(this.serviceRegistryDirectory + " does not exist"));
        Assert.isTrue((boolean)this.serviceRegistryDirectory.toFile().isDirectory(), (String)(this.serviceRegistryDirectory + " is not a directory"));
        this.registeredServiceJsonSerializer = registeredServiceJsonSerializer;
        this.initializeWatchServiceThread();
    }

    public JsonServiceRegistryDao(Path configDirectory) {
        this(configDirectory, new RegisteredServiceJsonSerializer());
    }

    public JsonServiceRegistryDao(File configDirectory) throws IOException {
        this(Paths.get(configDirectory.getCanonicalPath(), new String[0]));
    }

    public final RegisteredService save(RegisteredService service) {
        RegisteredService registeredService = service;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)registeredService);
        Object[] objectArray = new Object[]{this, registeredService, joinPoint};
        return (RegisteredService)TraceLogAspect.aspectOf().traceMethod(new JsonServiceRegistryDao$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
    }

    public final synchronized boolean delete(RegisteredService service) {
        RegisteredService registeredService = service;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)registeredService);
        Object[] objectArray = new Object[]{this, registeredService, joinPoint};
        return Conversions.booleanValue((Object)TraceLogAspect.aspectOf().traceMethod(new JsonServiceRegistryDao$AjcClosure3(objectArray).linkClosureAndJoinPoint(69648)));
    }

    public final synchronized List<RegisteredService> load() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        return (List)TraceLogAspect.aspectOf().traceMethod(new JsonServiceRegistryDao$AjcClosure5(objectArray).linkClosureAndJoinPoint(69648));
    }

    public final RegisteredService findServiceById(long id) {
        long l = id;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)Conversions.longObject((long)l));
        Object[] objectArray = new Object[]{this, Conversions.longObject((long)l), joinPoint};
        return (RegisteredService)TraceLogAspect.aspectOf().traceMethod(new JsonServiceRegistryDao$AjcClosure7(objectArray).linkClosureAndJoinPoint(69648));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    RegisteredService loadRegisteredServiceFromFile(File file) {
        if (!file.canRead()) {
            LOGGER.warn("[{}] is not readable. Check file permissions", (Object)file.getName());
            return null;
        }
        if (!file.exists()) {
            LOGGER.warn("[{}] is not found at the path specified", (Object)file.getName());
            return null;
        }
        if (file.length() == 0L) {
            LOGGER.debug("[{}] appears to be empty so no service definition will be loaded", (Object)file.getName());
            return null;
        }
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));){
            RegisteredService registeredService = this.registeredServiceJsonSerializer.fromJson(in);
            return registeredService;
        }
        catch (Exception e) {
            LOGGER.error("Error reading configuration file " + file.getName(), (Throwable)e);
            return null;
        }
    }

    void updateRegisteredService(RegisteredService service) {
        this.serviceMap.put(service.getId(), service);
    }

    Path getServiceRegistryDirectory() {
        return this.serviceRegistryDirectory;
    }

    protected File makeFile(RegisteredService service) {
        String fileName = StringUtils.remove((String)(service.getName() + '-' + service.getId() + '.' + FILE_EXTENSION), (String)" ");
        try {
            File svcFile = new File(this.serviceRegistryDirectory.toFile(), fileName);
            LOGGER.debug("Using [{}] as the service definition file", (Object)svcFile.getCanonicalPath());
            return svcFile;
        }
        catch (IOException e) {
            LOGGER.warn("Service file name {} is invalid; Examine for illegal characters in the name.", (Object)fileName);
            throw new IllegalArgumentException(e);
        }
    }

    private void initializeWatchServiceThread() {
        Thread thread = new Thread(new JsonServiceRegistryConfigWatcher(this));
        thread.start();
    }

    void refreshServicesManager() {
        if (this.applicationContext == null) {
            LOGGER.debug("Application context has failed to initializeService definition may not take immediate effect, which suggests a configuration problem");
            return;
        }
        ReloadableServicesManager manager = (ReloadableServicesManager)this.applicationContext.getBean(ReloadableServicesManager.class);
        if (manager != null) {
            manager.reload();
        } else {
            LOGGER.warn("Services manger could not be obtained from the application context. Service definition may not take immediate effect, which suggests a configuration problem");
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    static {
        JsonServiceRegistryDao.ajc$preClinit();
        LOGGER = LoggerFactory.getLogger(JsonServiceRegistryDao.class);
    }

    static final /* synthetic */ RegisteredService save_aroundBody0(JsonServiceRegistryDao ajc$this, RegisteredService service, JoinPoint joinPoint) {
        if (service.getId() == -9223372036854775807L && service instanceof AbstractRegisteredService) {
            LOGGER.debug("Service id not set. Calculating id based on system time...");
            ((AbstractRegisteredService)service).setId(System.nanoTime());
        }
        File f = ajc$this.makeFile(service);
        try (LockedOutputStream out = new LockedOutputStream(new FileOutputStream(f));){
            ajc$this.registeredServiceJsonSerializer.toJson(out, service);
            if (ajc$this.serviceMap.containsKey(service.getId())) {
                LOGGER.debug("Found existing service definition by id [{}]. Saving...", (Object)service.getId());
            }
            ajc$this.serviceMap.put(service.getId(), service);
            LOGGER.debug("Saved service to [{}]", (Object)f.getCanonicalPath());
        }
        catch (IOException e) {
            throw new RuntimeException("IO error opening file stream.", e);
        }
        return ajc$this.findServiceById(service.getId());
    }

    static final /* synthetic */ boolean delete_aroundBody2(JsonServiceRegistryDao ajc$this, RegisteredService service, JoinPoint joinPoint) {
        try {
            File f = ajc$this.makeFile(service);
            boolean result = f.delete();
            if (!result) {
                LOGGER.warn("Failed to delete service definition file [{}]", (Object)f.getCanonicalPath());
            } else {
                ajc$this.serviceMap.remove(service.getId());
                LOGGER.debug("Successfully deleted service definition file [{}]", (Object)f.getCanonicalPath());
            }
            return result;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static final /* synthetic */ List load_aroundBody4(JsonServiceRegistryDao ajc$this, JoinPoint joinPoint) {
        ConcurrentHashMap<Long, RegisteredService> temp = new ConcurrentHashMap<Long, RegisteredService>();
        int errorCount = 0;
        Collection c = FileUtils.listFiles((File)ajc$this.serviceRegistryDirectory.toFile(), (String[])new String[]{FILE_EXTENSION}, (boolean)true);
        for (File file : c) {
            if (file.length() <= 0L) continue;
            RegisteredService service = ajc$this.loadRegisteredServiceFromFile(file);
            if (service == null) {
                ++errorCount;
                continue;
            }
            if (temp.containsKey(service.getId())) {
                LOGGER.warn("Found a service definition [{}] with a duplicate id [{}]. This will overwrite previous service definitions and is likely a configuration problem. Make sure all services have a unique id and try again.", (Object)service.getServiceId(), (Object)service.getId());
            }
            temp.put(service.getId(), service);
        }
        if (errorCount == 0) {
            ajc$this.serviceMap = temp;
        }
        return new ArrayList<RegisteredService>(ajc$this.serviceMap.values());
    }

    static final /* synthetic */ RegisteredService findServiceById_aroundBody6(JsonServiceRegistryDao ajc$this, long id, JoinPoint joinPoint) {
        return ajc$this.serviceMap.get(id);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("JsonServiceRegistryDao.java", JsonServiceRegistryDao.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("11", "save", "org.jasig.cas.services.JsonServiceRegistryDao", "org.jasig.cas.services.RegisteredService", "service", "", "org.jasig.cas.services.RegisteredService"), 155);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("31", "delete", "org.jasig.cas.services.JsonServiceRegistryDao", "org.jasig.cas.services.RegisteredService", "service", "", "boolean"), 177);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("31", "load", "org.jasig.cas.services.JsonServiceRegistryDao", "", "", "", "java.util.List"), 193);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("11", "findServiceById", "org.jasig.cas.services.JsonServiceRegistryDao", "long", "id", "", "org.jasig.cas.services.RegisteredService"), 220);
    }
}

