/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.ticket.registry;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.jasig.cas.ticket.ServiceTicket;
import org.jasig.cas.ticket.Ticket;
import org.jasig.cas.ticket.TicketGrantingTicket;
import org.jasig.cas.ticket.registry.AbstractTicketRegistry;
import org.jasig.cas.ticket.registry.DefaultTicketRegistry$AjcClosure1;
import org.jasig.cas.ticket.registry.DefaultTicketRegistry$AjcClosure11;
import org.jasig.cas.ticket.registry.DefaultTicketRegistry$AjcClosure3;
import org.jasig.cas.ticket.registry.DefaultTicketRegistry$AjcClosure5;
import org.jasig.cas.ticket.registry.DefaultTicketRegistry$AjcClosure7;
import org.jasig.cas.ticket.registry.DefaultTicketRegistry$AjcClosure9;
import org.jasig.inspektr.aspect.TraceLogAspect;
import org.springframework.util.Assert;

public final class DefaultTicketRegistry
extends AbstractTicketRegistry {
    private final Map<String, Ticket> cache;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;

    public DefaultTicketRegistry() {
        this.cache = new ConcurrentHashMap<String, Ticket>();
    }

    public DefaultTicketRegistry(int initialCapacity, float loadFactor, int concurrencyLevel) {
        this.cache = new ConcurrentHashMap<String, Ticket>(initialCapacity, loadFactor, concurrencyLevel);
    }

    public void addTicket(Ticket ticket) {
        Ticket ticket2 = ticket;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)ticket2);
        Object[] objectArray = new Object[]{this, ticket2, joinPoint};
        TraceLogAspect.aspectOf().traceMethod(new DefaultTicketRegistry$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
    }

    public Ticket getTicket(String ticketId) {
        String string = ticketId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        return (Ticket)TraceLogAspect.aspectOf().traceMethod(new DefaultTicketRegistry$AjcClosure3(objectArray).linkClosureAndJoinPoint(69648));
    }

    public boolean deleteTicket(String ticketId) {
        String string = ticketId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        return Conversions.booleanValue((Object)TraceLogAspect.aspectOf().traceMethod(new DefaultTicketRegistry$AjcClosure5(objectArray).linkClosureAndJoinPoint(69648)));
    }

    private void deleteChildren(TicketGrantingTicket ticket) {
        Map services = ticket.getServices();
        if (services != null && !services.isEmpty()) {
            for (Map.Entry entry : services.entrySet()) {
                if (this.cache.remove(entry.getKey()) != null) {
                    this.logger.trace("Removed service ticket [{}]", entry.getKey());
                    continue;
                }
                this.logger.trace("Unable to remove service ticket [{}]", entry.getKey());
            }
        }
    }

    public Collection<Ticket> getTickets() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        return (Collection)TraceLogAspect.aspectOf().traceMethod(new DefaultTicketRegistry$AjcClosure7(objectArray).linkClosureAndJoinPoint(69648));
    }

    @Override
    public int sessionCount() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        return Conversions.intValue((Object)TraceLogAspect.aspectOf().traceMethod(new DefaultTicketRegistry$AjcClosure9(objectArray).linkClosureAndJoinPoint(69648)));
    }

    @Override
    public int serviceTicketCount() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        return Conversions.intValue((Object)TraceLogAspect.aspectOf().traceMethod(new DefaultTicketRegistry$AjcClosure11(objectArray).linkClosureAndJoinPoint(69648)));
    }

    static {
        DefaultTicketRegistry.ajc$preClinit();
    }

    static final /* synthetic */ void addTicket_aroundBody0(DefaultTicketRegistry ajc$this, Ticket ticket, JoinPoint joinPoint) {
        Assert.notNull((Object)ticket, (String)"ticket cannot be null");
        ajc$this.logger.debug("Added ticket [{}] to registry.", (Object)ticket.getId());
        ajc$this.cache.put(ticket.getId(), ticket);
    }

    static final /* synthetic */ Ticket getTicket_aroundBody2(DefaultTicketRegistry ajc$this, String ticketId, JoinPoint joinPoint) {
        if (ticketId == null) {
            return null;
        }
        ajc$this.logger.debug("Attempting to retrieve ticket [{}]", (Object)ticketId);
        Ticket ticket = ajc$this.cache.get(ticketId);
        if (ticket != null) {
            ajc$this.logger.debug("Ticket [{}] found in registry.", (Object)ticketId);
        }
        return ticket;
    }

    static final /* synthetic */ boolean deleteTicket_aroundBody4(DefaultTicketRegistry ajc$this, String ticketId, JoinPoint joinPoint) {
        if (ticketId == null) {
            return false;
        }
        Ticket ticket = ajc$this.getTicket(ticketId);
        if (ticket == null) {
            return false;
        }
        if (ticket instanceof TicketGrantingTicket) {
            ajc$this.logger.debug("Removing children of ticket [{}] from the registry.", (Object)ticket);
            ajc$this.deleteChildren((TicketGrantingTicket)ticket);
        }
        ajc$this.logger.debug("Removing ticket [{}] from the registry.", (Object)ticket);
        return ajc$this.cache.remove(ticketId) != null;
    }

    static final /* synthetic */ Collection getTickets_aroundBody6(DefaultTicketRegistry ajc$this, JoinPoint joinPoint) {
        return Collections.unmodifiableCollection(ajc$this.cache.values());
    }

    static final /* synthetic */ int sessionCount_aroundBody8(DefaultTicketRegistry ajc$this, JoinPoint joinPoint) {
        int count = 0;
        for (Ticket t : ajc$this.cache.values()) {
            if (!(t instanceof TicketGrantingTicket)) continue;
            ++count;
        }
        return count;
    }

    static final /* synthetic */ int serviceTicketCount_aroundBody10(DefaultTicketRegistry ajc$this, JoinPoint joinPoint) {
        int count = 0;
        for (Ticket t : ajc$this.cache.values()) {
            if (!(t instanceof ServiceTicket)) continue;
            ++count;
        }
        return count;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("DefaultTicketRegistry.java", DefaultTicketRegistry.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "addTicket", "org.jasig.cas.ticket.registry.DefaultTicketRegistry", "org.jasig.cas.ticket.Ticket", "ticket", "", "void"), 73);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTicket", "org.jasig.cas.ticket.registry.DefaultTicketRegistry", "java.lang.String", "ticketId", "", "org.jasig.cas.ticket.Ticket"), 81);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteTicket", "org.jasig.cas.ticket.registry.DefaultTicketRegistry", "java.lang.String", "ticketId", "", "boolean"), 97);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTickets", "org.jasig.cas.ticket.registry.DefaultTicketRegistry", "", "", "", "java.util.Collection"), 135);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "sessionCount", "org.jasig.cas.ticket.registry.DefaultTicketRegistry", "", "", "", "int"), 140);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "serviceTicketCount", "org.jasig.cas.ticket.registry.DefaultTicketRegistry", "", "", "", "int"), 151);
    }
}

