/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.ticket.registry.support;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections4.Predicate;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.jasig.cas.CentralAuthenticationService;
import org.jasig.cas.logout.LogoutManager;
import org.jasig.cas.ticket.ServiceTicket;
import org.jasig.cas.ticket.Ticket;
import org.jasig.cas.ticket.TicketGrantingTicket;
import org.jasig.cas.ticket.registry.RegistryCleaner;
import org.jasig.cas.ticket.registry.TicketRegistry;
import org.jasig.cas.ticket.registry.support.DefaultTicketRegistryCleaner$1$AjcClosure1;
import org.jasig.cas.ticket.registry.support.DefaultTicketRegistryCleaner$AjcClosure1;
import org.jasig.cas.ticket.registry.support.LockingStrategy;
import org.jasig.cas.ticket.registry.support.NoOpLockingStrategy;
import org.jasig.inspektr.aspect.TraceLogAspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultTicketRegistryCleaner
implements RegistryCleaner {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @NotNull
    private final CentralAuthenticationService centralAuthenticationService;
    @NotNull
    private LockingStrategy lock = new NoOpLockingStrategy();
    @NotNull
    private TicketRegistry ticketRegistry;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public DefaultTicketRegistryCleaner(CentralAuthenticationService centralAuthenticationService, TicketRegistry ticketRegistry) {
        this.centralAuthenticationService = centralAuthenticationService;
        this.ticketRegistry = ticketRegistry;
    }

    public Collection<Ticket> clean() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        return (Collection)TraceLogAspect.aspectOf().traceMethod(new DefaultTicketRegistryCleaner$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
    }

    @Deprecated
    public void setTicketRegistry(TicketRegistry ticketRegistry) {
        this.logger.warn("Invoking setTicketRegistry() is deprecated and has no impact.");
    }

    @Deprecated
    public void setLock(LockingStrategy strategy) {
        this.lock = strategy;
    }

    @Deprecated
    public void setLogUserOutOfServices(boolean logUserOutOfServices) {
        this.logger.warn("Invoking setLogUserOutOfServices() is deprecated and has no impact.");
    }

    @Deprecated
    public void setLogoutManager(LogoutManager logoutManager) {
        this.logger.warn("Invoking setLogoutManager() is deprecated and has no impact.");
    }

    static {
        DefaultTicketRegistryCleaner.ajc$preClinit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final /* synthetic */ Collection clean_aroundBody0(DefaultTicketRegistryCleaner ajc$this, JoinPoint joinPoint) {
        try {
            ajc$this.logger.info("Beginning ticket cleanup.");
            ajc$this.logger.debug("Attempting to acquire ticket cleanup lock.");
            if (!ajc$this.lock.acquire()) {
                ajc$this.logger.info("Could not obtain lock.  Aborting cleanup.");
                List list = Collections.emptyList();
                return list;
            }
            ajc$this.logger.debug("Acquired lock.  Proceeding with cleanup.");
            Collection ticketsToRemove = ajc$this.centralAuthenticationService.getTickets(new Predicate(){
                private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

                public boolean evaluate(Object o) {
                    Object object = o;
                    JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)object);
                    Object[] objectArray = new Object[]{this, object, joinPoint};
                    return Conversions.booleanValue((Object)TraceLogAspect.aspectOf().traceMethod(new DefaultTicketRegistryCleaner$1$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648)));
                }

                static {
                    1.ajc$preClinit();
                }

                static final /* synthetic */ boolean evaluate_aroundBody0(1 ajc$this, Object o, JoinPoint joinPoint) {
                    Ticket ticket = (Ticket)o;
                    return ticket.isExpired();
                }

                private static /* synthetic */ void ajc$preClinit() {
                    Factory factory = new Factory("DefaultTicketRegistryCleaner.java", 1.class);
                    ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "evaluate", "org.jasig.cas.ticket.registry.support.DefaultTicketRegistryCleaner$1", "java.lang.Object", "o", "", "boolean"), 107);
                }
            });
            ajc$this.logger.info("{} expired tickets found to be removed.", (Object)ticketsToRemove.size());
            try {
                for (Ticket ticket : ticketsToRemove) {
                    if (ticket instanceof TicketGrantingTicket) {
                        ajc$this.logger.debug("Cleaning up expired ticket-granting ticket [{}]", (Object)ticket.getId());
                        ajc$this.centralAuthenticationService.destroyTicketGrantingTicket(ticket.getId());
                        continue;
                    }
                    if (ticket instanceof ServiceTicket) {
                        ajc$this.logger.debug("Cleaning up expired service ticket [{}]", (Object)ticket.getId());
                        ajc$this.ticketRegistry.deleteTicket(ticket.getId());
                        continue;
                    }
                    ajc$this.logger.warn("Unknown ticket type [{} found to clean", (Object)ticket.getClass().getSimpleName());
                }
            }
            catch (Exception e) {
                ajc$this.logger.error(e.getMessage(), (Throwable)e);
            }
            Collection collection = ticketsToRemove;
            return collection;
        }
        finally {
            ajc$this.logger.debug("Releasing ticket cleanup lock.");
            ajc$this.lock.release();
            ajc$this.logger.info("Finished ticket cleanup.");
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("DefaultTicketRegistryCleaner.java", DefaultTicketRegistryCleaner.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "clean", "org.jasig.cas.ticket.registry.support.DefaultTicketRegistryCleaner", "", "", "", "java.util.Collection"), 96);
    }
}

