/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.authentication.principal;

import com.google.common.io.ByteSource;
import java.io.IOException;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.jasig.cas.authentication.principal.PersistentIdGenerator;
import org.jasig.cas.authentication.principal.Principal;
import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.util.CompressionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ShibbolethCompatiblePersistentIdGenerator
implements PersistentIdGenerator {
    private static final long serialVersionUID = 6182838799563190289L;
    private static final Logger LOGGER = LoggerFactory.getLogger(ShibbolethCompatiblePersistentIdGenerator.class);
    private static final byte CONST_SEPARATOR = 33;
    private static final int CONST_DEFAULT_SALT_COUNT = 16;
    private byte[] salt;

    public ShibbolethCompatiblePersistentIdGenerator() {
        this.salt = RandomStringUtils.randomAlphanumeric((int)16).getBytes(Charset.defaultCharset());
    }

    public ShibbolethCompatiblePersistentIdGenerator(@NotNull String salt) {
        this.salt = salt.getBytes(Charset.defaultCharset());
    }

    @Deprecated
    public void setSalt(String salt) {
        this.salt = salt.getBytes(Charset.defaultCharset());
        LOGGER.warn("setSalt() is deprecated and will be removed. Use the constructor instead.");
    }

    public byte[] getSalt() {
        try {
            return ByteSource.wrap((byte[])this.salt).read();
        }
        catch (IOException e) {
            LOGGER.warn("Salt cannot be read because the byte array from source could not be consumed");
            return null;
        }
    }

    public String generate(Principal principal, Service service) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA");
            Charset charset = Charset.defaultCharset();
            md.update(service.getId().getBytes(charset));
            md.update((byte)33);
            md.update(principal.getId().getBytes(charset));
            md.update((byte)33);
            String result = CompressionUtils.encodeBase64(md.digest(this.salt));
            return result.replaceAll(System.getProperty("line.separator"), "");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        ShibbolethCompatiblePersistentIdGenerator rhs = (ShibbolethCompatiblePersistentIdGenerator)obj;
        return new EqualsBuilder().append(this.salt, rhs.salt).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.salt).toHashCode();
    }
}

