/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.monitor;

import com.google.common.collect.ImmutableList;
import org.jasig.cas.monitor.CacheStatistics;
import org.jasig.cas.monitor.Status;
import org.jasig.cas.monitor.StatusCode;

public class CacheStatus
extends Status {
    private final CacheStatistics[] statistics;

    public CacheStatus(StatusCode code, String description, CacheStatistics ... statistics) {
        super(code, CacheStatus.buildDescription(description, statistics));
        this.statistics = statistics;
    }

    public CacheStatus(Exception e) {
        super(StatusCode.ERROR, String.format("Error fetching cache status: %s::%s", e.getClass().getSimpleName(), e.getMessage()));
        this.statistics = null;
    }

    public CacheStatistics[] getStatistics() {
        return (CacheStatistics[])ImmutableList.copyOf((Object[])this.statistics).toArray((Object[])new CacheStatistics[this.statistics.length]);
    }

    private static String buildDescription(String desc, CacheStatistics ... statistics) {
        if (statistics == null || statistics.length == 0) {
            return desc;
        }
        StringBuilder sb = new StringBuilder();
        if (desc != null) {
            sb.append(desc);
            if (!desc.endsWith(".")) {
                sb.append('.');
            }
            sb.append(' ');
        }
        sb.append("Cache statistics: [");
        int i = 0;
        for (CacheStatistics stats : statistics) {
            if (i++ > 0) {
                sb.append('|');
            }
            stats.toString(sb);
        }
        sb.append(']');
        return sb.toString();
    }
}

