/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.services;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.jasig.cas.services.RegisteredServiceAccessStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRegisteredServiceAccessStrategy
implements RegisteredServiceAccessStrategy {
    private static final long serialVersionUID = 1245279151345635245L;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private boolean enabled = true;
    private boolean ssoEnabled = true;
    private boolean requireAllAttributes = true;
    private Map<String, Set<String>> requiredAttributes = new HashMap<String, Set<String>>();

    public DefaultRegisteredServiceAccessStrategy() {
        this(true, true);
    }

    public DefaultRegisteredServiceAccessStrategy(boolean enabled, boolean ssoEnabled) {
        this.enabled = enabled;
        this.ssoEnabled = ssoEnabled;
    }

    public final void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public final void setSsoEnabled(boolean ssoEnabled) {
        this.ssoEnabled = ssoEnabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isSsoEnabled() {
        return this.ssoEnabled;
    }

    public final void setRequireAllAttributes(boolean requireAllAttributes) {
        this.requireAllAttributes = requireAllAttributes;
    }

    public final boolean isRequireAllAttributes() {
        return this.requireAllAttributes;
    }

    public Map<String, Set<String>> getRequiredAttributes() {
        return new HashMap<String, Set<String>>(this.requiredAttributes);
    }

    public final void setRequiredAttributes(Map<String, Set<String>> requiredAttributes) {
        this.requiredAttributes = requiredAttributes;
    }

    public boolean doPrincipalAttributesAllowServiceAccess(Map<String, Object> principalAttributes) {
        if (this.requiredAttributes.isEmpty()) {
            this.logger.debug("No required attributes are specified");
            return true;
        }
        if (principalAttributes.isEmpty()) {
            this.logger.debug("No principal attributes are found to satisfy attribute requirements");
            return false;
        }
        if (principalAttributes.size() < this.requiredAttributes.size()) {
            this.logger.debug("The size of the principal attributes that are [{}] does not match requirements, which means the principal is not carrying enough data to grant authorization", principalAttributes);
            return false;
        }
        Map<String, Set<String>> requiredAttrs = this.getRequiredAttributes();
        this.logger.debug("These required attributes [{}] are examined against [{}] before service can proceed.", requiredAttrs, principalAttributes);
        Sets.SetView difference = Sets.intersection(requiredAttrs.keySet(), principalAttributes.keySet());
        ImmutableSet copy = difference.immutableCopy();
        if (this.requireAllAttributes && copy.size() < this.requiredAttributes.size()) {
            this.logger.debug("Not all required attributes are available to the principal");
            return false;
        }
        for (String key : copy) {
            Sets.SetView differenceInValues;
            HashSet availableValues;
            Set<String> requiredValues = this.requiredAttributes.get(key);
            Object objVal = principalAttributes.get(key);
            if (objVal instanceof Collection) {
                Collection valCol = (Collection)objVal;
                availableValues = Sets.newHashSet((Object[])valCol.toArray());
            } else {
                availableValues = Collections.singleton(objVal);
            }
            if ((differenceInValues = Sets.intersection(availableValues, requiredValues)).isEmpty()) continue;
            this.logger.info("Principal is authorized to access the service");
            return true;
        }
        this.logger.info("Principal is denied access as the required attributes for the registered service are missing");
        return false;
    }

    public boolean isServiceAccessAllowedForSso() {
        if (!this.ssoEnabled) {
            this.logger.trace("Service is not authorized to participate in SSO.");
        }
        return this.ssoEnabled;
    }

    public boolean isServiceAccessAllowed() {
        if (!this.enabled) {
            this.logger.trace("Service is not enabled in service registry.");
        }
        return this.enabled;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        DefaultRegisteredServiceAccessStrategy rhs = (DefaultRegisteredServiceAccessStrategy)obj;
        return new EqualsBuilder().append(this.enabled, rhs.enabled).append(this.ssoEnabled, rhs.ssoEnabled).append(this.requireAllAttributes, rhs.requireAllAttributes).append(this.requiredAttributes, rhs.requiredAttributes).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.enabled).append(this.ssoEnabled).append(this.requireAllAttributes).append(this.requiredAttributes).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("enabled", this.enabled).append("ssoEnabled", this.ssoEnabled).append("requireAllAttributes", this.requireAllAttributes).append("requiredAttributes", this.requiredAttributes).toString();
    }
}

