/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.services;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jasig.cas.services.JsonServiceRegistryDao;
import org.jasig.cas.services.RegisteredService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JsonServiceRegistryConfigWatcher
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonServiceRegistryConfigWatcher.class);
    private final AtomicBoolean running = new AtomicBoolean(false);
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Lock readLock = this.lock.readLock();
    private final WatchService watcher;
    private final JsonServiceRegistryDao serviceRegistryDao;

    public JsonServiceRegistryConfigWatcher(JsonServiceRegistryDao serviceRegistryDao) {
        try {
            this.serviceRegistryDao = serviceRegistryDao;
            this.watcher = FileSystems.getDefault().newWatchService();
            WatchEvent.Kind[] kinds = (WatchEvent.Kind[])Arrays.asList(StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY).toArray();
            this.serviceRegistryDao.getServiceRegistryDirectory().register(this.watcher, kinds);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void run() {
        if (this.running.compareAndSet(false, true)) {
            while (this.running.get()) {
                WatchKey key = null;
                try {
                    key = this.watcher.take();
                    this.handleEvent(key);
                    boolean valid = key != null && key.reset();
                    if (valid) continue;
                }
                catch (InterruptedException e) {
                    boolean valid2;
                    boolean bl = valid2 = key != null && key.reset();
                    if (!valid2) {
                        LOGGER.warn("Directory key is no longer valid. Quitting watcher service");
                        break;
                    }
                    return;
                    catch (Throwable throwable) {
                        boolean valid22;
                        boolean bl2 = valid22 = key != null && key.reset();
                        if (!valid22) {
                            LOGGER.warn("Directory key is no longer valid. Quitting watcher service");
                            break;
                        }
                        throw throwable;
                    }
                }
                LOGGER.warn("Directory key is no longer valid. Quitting watcher service");
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleEvent(WatchKey key) {
        this.readLock.lock();
        try {
            for (WatchEvent<?> event : key.pollEvents()) {
                if (event.count() > 1) continue;
                WatchEvent.Kind<?> kind = event.kind();
                WatchEvent<?> ev = event;
                Path filename = (Path)ev.context();
                Path parent = (Path)key.watchable();
                Path fullPath = parent.resolve(filename);
                File file = fullPath.toFile();
                LOGGER.trace("Detected event [{}] on file [{}]. Loading change...", kind, (Object)file);
                if (kind.name().equals(StandardWatchEventKinds.ENTRY_CREATE.name()) && file.exists()) {
                    this.handleCreateEvent(file);
                    continue;
                }
                if (kind.name().equals(StandardWatchEventKinds.ENTRY_DELETE.name())) {
                    this.handleDeleteEvent();
                    continue;
                }
                if (!kind.name().equals(StandardWatchEventKinds.ENTRY_MODIFY.name()) || !file.exists()) continue;
                this.handleModifyEvent(file);
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    private void handleModifyEvent(File file) {
        RegisteredService newService = this.serviceRegistryDao.loadRegisteredServiceFromFile(file);
        if (newService == null) {
            LOGGER.warn("New service definition could not be loaded from [{}]", (Object)file.getAbsolutePath());
        } else {
            RegisteredService oldService = this.serviceRegistryDao.findServiceById(newService.getId());
            if (!newService.equals(oldService)) {
                this.serviceRegistryDao.updateRegisteredService(newService);
                this.serviceRegistryDao.refreshServicesManager();
            } else {
                LOGGER.debug("Service [{}] loaded from [{}] is idential to the existing entry. Services manager will not reload", (Object)newService.getId(), (Object)file.getName());
            }
        }
    }

    private void handleDeleteEvent() {
        this.serviceRegistryDao.load();
        this.serviceRegistryDao.refreshServicesManager();
    }

    private void handleCreateEvent(File file) {
        RegisteredService service = this.serviceRegistryDao.loadRegisteredServiceFromFile(file);
        if (service == null) {
            LOGGER.warn("No service definition was loaded from [{}]", (Object)file);
            return;
        }
        if (this.serviceRegistryDao.findServiceById(service.getId()) != null) {
            LOGGER.warn("Found a service definition [{}] with a duplicate id [{}] in [{}]. This will overwrite previous service definitions and is likely a configuration problem. Make sure all services have a unique id and try again.", new Object[]{service.getServiceId(), service.getId(), file.getAbsolutePath()});
        }
        this.serviceRegistryDao.updateRegisteredService(service);
        this.serviceRegistryDao.refreshServicesManager();
    }
}

