/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.ticket;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Lob;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.jasig.cas.authentication.Authentication;
import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.ticket.AbstractTicket;
import org.jasig.cas.ticket.ExpirationPolicy;
import org.jasig.cas.ticket.ServiceTicket;
import org.jasig.cas.ticket.Ticket;
import org.jasig.cas.ticket.TicketGrantingTicket;
import org.jasig.cas.ticket.TicketGrantingTicketImpl;
import org.springframework.util.Assert;

@Entity
@Table(name="SERVICETICKET")
public final class ServiceTicketImpl
extends AbstractTicket
implements ServiceTicket {
    private static final long serialVersionUID = -4223319704861765405L;
    @Lob
    @Column(name="SERVICE", nullable=false)
    private Service service;
    @Column(name="FROM_NEW_LOGIN", nullable=false)
    private boolean fromNewLogin;
    @Column(name="TICKET_ALREADY_GRANTED", nullable=false)
    private Boolean grantedTicketAlready = Boolean.FALSE;

    public ServiceTicketImpl() {
    }

    protected ServiceTicketImpl(String id, @NotNull TicketGrantingTicketImpl ticket, @NotNull Service service, boolean fromNewLogin, ExpirationPolicy policy) {
        super(id, ticket, policy);
        Assert.notNull((Object)service, (String)"service cannot be null");
        Assert.notNull((Object)ticket, (String)"ticket cannot be null");
        this.service = service;
        this.fromNewLogin = fromNewLogin;
    }

    public boolean isFromNewLogin() {
        return this.fromNewLogin;
    }

    public Service getService() {
        return this.service;
    }

    public boolean isValidFor(Service serviceToValidate) {
        this.updateState();
        return serviceToValidate.matches(this.service);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof ServiceTicket)) {
            return false;
        }
        Ticket ticket = (Ticket)object;
        return new EqualsBuilder().append((Object)ticket.getId(), (Object)this.getId()).isEquals();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TicketGrantingTicket grantTicketGrantingTicket(String id, Authentication authentication, ExpirationPolicy expirationPolicy) {
        ServiceTicketImpl serviceTicketImpl = this;
        synchronized (serviceTicketImpl) {
            if (this.grantedTicketAlready.booleanValue()) {
                throw new IllegalStateException("TicketGrantingTicket already generated for this ServiceTicket.  Cannot grant more than one TGT for ServiceTicket");
            }
            this.grantedTicketAlready = Boolean.TRUE;
        }
        return new TicketGrantingTicketImpl(id, this.service, this.getGrantingTicket(), authentication, expirationPolicy);
    }

    public Authentication getAuthentication() {
        return null;
    }
}

