/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.ticket;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Lob;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.jasig.cas.authentication.Authentication;
import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.ticket.AbstractTicket;
import org.jasig.cas.ticket.ExpirationPolicy;
import org.jasig.cas.ticket.ServiceTicket;
import org.jasig.cas.ticket.ServiceTicketImpl;
import org.jasig.cas.ticket.Ticket;
import org.jasig.cas.ticket.TicketGrantingTicket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

@Entity
@Table(name="TICKETGRANTINGTICKET")
public final class TicketGrantingTicketImpl
extends AbstractTicket
implements TicketGrantingTicket {
    private static final long serialVersionUID = -8608149809180911599L;
    private static final Logger LOGGER = LoggerFactory.getLogger(TicketGrantingTicketImpl.class);
    @Lob
    @Column(name="AUTHENTICATION", nullable=false, length=1000000)
    private Authentication authentication;
    @Column(name="EXPIRED", nullable=false)
    private Boolean expired = Boolean.FALSE;
    @Column(name="PROXIED_BY", nullable=true)
    private Service proxiedBy;
    @Lob
    @Column(name="SERVICES_GRANTED_ACCESS_TO", nullable=false, length=1000000)
    private final HashMap<String, Service> services = new HashMap();
    @Lob
    @Column(name="SUPPLEMENTAL_AUTHENTICATIONS", nullable=false, length=1000000)
    private final ArrayList<Authentication> supplementalAuthentications = new ArrayList();

    public TicketGrantingTicketImpl() {
    }

    public TicketGrantingTicketImpl(String id, Service proxiedBy, TicketGrantingTicket parentTicketGrantingTicket, @NotNull Authentication authentication, ExpirationPolicy policy) {
        super(id, parentTicketGrantingTicket, policy);
        if (parentTicketGrantingTicket != null && proxiedBy == null) {
            throw new IllegalArgumentException("Must specify proxiedBy when providing parent TGT");
        }
        Assert.notNull((Object)authentication, (String)"authentication cannot be null");
        this.authentication = authentication;
        this.proxiedBy = proxiedBy;
    }

    public TicketGrantingTicketImpl(String id, Authentication authentication, ExpirationPolicy policy) {
        this(id, null, null, authentication, policy);
    }

    public Authentication getAuthentication() {
        return this.authentication;
    }

    public synchronized ServiceTicket grantServiceTicket(String id, Service service, ExpirationPolicy expirationPolicy, boolean credentialsProvided) {
        ServiceTicketImpl serviceTicket = new ServiceTicketImpl(id, this, service, this.getCountOfUses() == 0 || credentialsProvided, expirationPolicy);
        this.updateState();
        List<Authentication> authentications = this.getChainedAuthentications();
        service.setPrincipal(authentications.get(authentications.size() - 1).getPrincipal());
        this.services.put(id, service);
        return serviceTicket;
    }

    public synchronized Map<String, Service> getServices() {
        return ImmutableMap.copyOf(this.services);
    }

    public void removeAllServices() {
        this.services.clear();
    }

    public boolean isRoot() {
        return this.getGrantingTicket() == null;
    }

    public void markTicketExpired() {
        this.expired = Boolean.TRUE;
    }

    public TicketGrantingTicket getRoot() {
        TicketGrantingTicketImpl current = this;
        TicketGrantingTicket parent = current.getGrantingTicket();
        while (parent != null) {
            current = parent;
            parent = current.getGrantingTicket();
        }
        return current;
    }

    @Override
    public boolean isExpiredInternal() {
        return this.expired;
    }

    public List<Authentication> getSupplementalAuthentications() {
        return this.supplementalAuthentications;
    }

    public List<Authentication> getChainedAuthentications() {
        ArrayList<Authentication> list = new ArrayList<Authentication>();
        list.add(this.getAuthentication());
        if (this.getGrantingTicket() == null) {
            return Collections.unmodifiableList(list);
        }
        list.addAll(this.getGrantingTicket().getChainedAuthentications());
        return Collections.unmodifiableList(list);
    }

    public Service getProxiedBy() {
        return this.proxiedBy;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof TicketGrantingTicket)) {
            return false;
        }
        Ticket ticket = (Ticket)object;
        return new EqualsBuilder().append((Object)ticket.getId(), (Object)this.getId()).isEquals();
    }
}

