/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.util;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.jasig.cas.util.DefaultUniqueTicketIdGenerator;

public final class HostNameBasedUniqueTicketIdGenerator
extends DefaultUniqueTicketIdGenerator {
    public HostNameBasedUniqueTicketIdGenerator(int maxLength) {
        super(maxLength, HostNameBasedUniqueTicketIdGenerator.determineTicketSuffixByHostName());
    }

    private static String determineTicketSuffixByHostName() {
        try {
            String hostName = InetAddress.getLocalHost().getCanonicalHostName();
            int index = hostName.indexOf(46);
            if (index > 0) {
                return hostName.substring(0, index);
            }
            return hostName;
        }
        catch (UnknownHostException e) {
            throw new RuntimeException("Host name could not be determined automatically for the ticket suffix.", e);
        }
    }
}

