/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.authentication.principal;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.jasig.cas.authentication.Credential;
import org.jasig.cas.authentication.principal.DefaultPrincipalFactory;
import org.jasig.cas.authentication.principal.Principal;
import org.jasig.cas.authentication.principal.PrincipalFactory;
import org.jasig.cas.authentication.principal.PrincipalResolver;
import org.jasig.cas.util.Pair;
import org.jasig.services.persondir.IPersonAttributeDao;
import org.jasig.services.persondir.IPersonAttributes;
import org.jasig.services.persondir.support.StubPersonAttributeDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersonDirectoryPrincipalResolver
implements PrincipalResolver {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    @NotNull
    protected IPersonAttributeDao attributeRepository = new StubPersonAttributeDao(new HashMap());
    @NotNull
    protected PrincipalFactory principalFactory = new DefaultPrincipalFactory();
    protected boolean returnNullIfNoAttributes;
    protected String principalAttributeName;

    public boolean supports(Credential credential) {
        return true;
    }

    public Principal resolve(Credential credential) {
        this.logger.debug("Attempting to resolve a principal...");
        String principalId = this.extractPrincipalId(credential);
        if (principalId == null) {
            this.logger.debug("Got null for extracted principal ID; returning null.");
            return null;
        }
        this.logger.debug("Creating SimplePrincipal for [{}]", (Object)principalId);
        Map<String, List<Object>> attributes = this.retrievePersonAttributes(principalId);
        if (attributes == null || attributes.isEmpty()) {
            if (!this.returnNullIfNoAttributes) {
                return this.principalFactory.createPrincipal(principalId);
            }
            return null;
        }
        Pair<String, Map<String, Object>> pair = this.convertPersonAttributesToPrincipal(principalId, attributes);
        return this.principalFactory.createPrincipal(pair.getFirst(), pair.getSecond());
    }

    protected Pair<String, Map<String, Object>> convertPersonAttributesToPrincipal(String extractedPrincipalId, Map<String, List<Object>> attributes) {
        HashMap<String, Object> convertedAttributes = new HashMap<String, Object>();
        String principalId = extractedPrincipalId;
        for (Map.Entry<String, List<Object>> entry : attributes.entrySet()) {
            String key = entry.getKey();
            List<Object> values = entry.getValue();
            if (key.equalsIgnoreCase(this.principalAttributeName)) {
                if (values.isEmpty()) {
                    this.logger.debug("{} is empty, using {} for principal", (Object)this.principalAttributeName, (Object)extractedPrincipalId);
                    continue;
                }
                principalId = values.get(0).toString();
                this.logger.debug("Found principal attribute value {}; removing {} from attribute map.", (Object)extractedPrincipalId, (Object)this.principalAttributeName);
                continue;
            }
            convertedAttributes.put(key, values.size() == 1 ? values.get(0) : values);
        }
        return new Pair<String, Map<String, Object>>(principalId, convertedAttributes);
    }

    protected Map<String, List<Object>> retrievePersonAttributes(String principalId) {
        IPersonAttributes personAttributes = this.attributeRepository.getPerson(principalId);
        Map attributes = personAttributes == null ? null : personAttributes.getAttributes();
        return attributes;
    }

    public void setReturnNullIfNoAttributes(boolean returnNullIfNoAttributes) {
        this.returnNullIfNoAttributes = returnNullIfNoAttributes;
    }

    public void setPrincipalAttributeName(String attribute) {
        this.principalAttributeName = attribute;
    }

    public void setPrincipalFactory(PrincipalFactory principalFactory) {
        this.principalFactory = principalFactory;
    }

    public void setAttributeRepository(IPersonAttributeDao attributeRepository) {
        this.attributeRepository = attributeRepository;
    }

    protected String extractPrincipalId(Credential credential) {
        return credential.getId();
    }
}

