/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.services;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.jasig.cas.services.RegisteredServiceAccessStrategy;
import org.jasig.cas.util.RegexUtils;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRegisteredServiceAccessStrategy
implements RegisteredServiceAccessStrategy {
    private static final long serialVersionUID = 1245279151345635245L;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private boolean enabled = true;
    private boolean ssoEnabled = true;
    private String startingDateTime;
    private String endingDateTime;
    private URI unauthorizedRedirectUrl;
    private boolean requireAllAttributes = true;
    private Map<String, Set<String>> requiredAttributes = new HashMap<String, Set<String>>();
    private boolean caseInsensitive;

    public DefaultRegisteredServiceAccessStrategy() {
        this(true, true);
    }

    public DefaultRegisteredServiceAccessStrategy(boolean enabled, boolean ssoEnabled) {
        this.enabled = enabled;
        this.ssoEnabled = ssoEnabled;
    }

    public final void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public final void setSsoEnabled(boolean ssoEnabled) {
        this.ssoEnabled = ssoEnabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isSsoEnabled() {
        return this.ssoEnabled;
    }

    public final void setRequireAllAttributes(boolean requireAllAttributes) {
        this.requireAllAttributes = requireAllAttributes;
    }

    public final boolean isRequireAllAttributes() {
        return this.requireAllAttributes;
    }

    public Map<String, Set<String>> getRequiredAttributes() {
        return new HashMap<String, Set<String>>(this.requiredAttributes);
    }

    public String getStartingDateTime() {
        return this.startingDateTime;
    }

    public String getEndingDateTime() {
        return this.endingDateTime;
    }

    public void setStartingDateTime(String startingDateTime) {
        this.startingDateTime = startingDateTime;
    }

    public void setEndingDateTime(String endingDateTime) {
        this.endingDateTime = endingDateTime;
    }

    public void setUnauthorizedRedirectUrl(URI unauthorizedRedirectUrl) {
        this.unauthorizedRedirectUrl = unauthorizedRedirectUrl;
    }

    public URI getUnauthorizedRedirectUrl() {
        return this.unauthorizedRedirectUrl;
    }

    public boolean isCaseInsensitive() {
        return this.caseInsensitive;
    }

    public void setCaseInsensitive(boolean caseInsensitive) {
        this.caseInsensitive = caseInsensitive;
    }

    public final void setRequiredAttributes(Map<String, Set<String>> requiredAttributes) {
        this.requiredAttributes = requiredAttributes;
    }

    public boolean doPrincipalAttributesAllowServiceAccess(Map<String, Object> principalAttributes) {
        if (this.requiredAttributes.isEmpty()) {
            this.logger.debug("No required attributes are specified");
            return true;
        }
        if (principalAttributes.isEmpty()) {
            this.logger.debug("No principal attributes are found to satisfy attribute requirements");
            return false;
        }
        if (principalAttributes.size() < this.requiredAttributes.size()) {
            this.logger.debug("The size of the principal attributes that are [{}] does not match requirements, which means the principal is not carrying enough data to grant authorization", principalAttributes);
            return false;
        }
        Map<String, Set<String>> requiredAttrs = this.getRequiredAttributes();
        this.logger.debug("These required attributes [{}] are examined against [{}] before service can proceed.", requiredAttrs, principalAttributes);
        Sets.SetView difference = Sets.intersection(requiredAttrs.keySet(), principalAttributes.keySet());
        ImmutableSet copy = difference.immutableCopy();
        if (this.requireAllAttributes && copy.size() < this.requiredAttributes.size()) {
            this.logger.debug("Not all required attributes are available to the principal");
            return false;
        }
        for (String key : copy) {
            Pattern pattern;
            Object differenceInValues;
            HashSet availableValues;
            Set<String> requiredValues = this.requiredAttributes.get(key);
            Object objVal = principalAttributes.get(key);
            if (objVal instanceof Collection) {
                Collection valCol = (Collection)objVal;
                availableValues = Sets.newHashSet(valCol.iterator());
            } else {
                availableValues = Sets.newHashSet((Object[])new String[]{objVal.toString()});
            }
            if ((differenceInValues = (pattern = RegexUtils.concatenate(requiredValues, this.caseInsensitive)) != null ? Sets.filter((Set)availableValues, (Predicate)Predicates.contains((Pattern)pattern)) : Sets.intersection((Set)availableValues, requiredValues)).isEmpty()) continue;
            this.logger.info("Principal is authorized to access the service");
            return true;
        }
        this.logger.info("Principal is denied access as the required attributes for the registered service are missing");
        return false;
    }

    public boolean isServiceAccessAllowedForSso() {
        if (!this.ssoEnabled) {
            this.logger.trace("Service is not authorized to participate in SSO.");
        }
        return this.ssoEnabled;
    }

    public boolean isServiceAccessAllowed() {
        DateTime et;
        DateTime st;
        if (!this.enabled) {
            this.logger.trace("Service is not enabled in service registry.");
        }
        DateTime now = DateTime.now();
        if (this.startingDateTime != null && now.isBefore((ReadableInstant)(st = DateTime.parse((String)this.startingDateTime)))) {
            this.logger.warn("Service access not allowed because it starts at {}. Now is {}", (Object)this.startingDateTime, (Object)now);
            return false;
        }
        if (this.endingDateTime != null && now.isAfter((ReadableInstant)(et = DateTime.parse((String)this.endingDateTime)))) {
            this.logger.warn("Service access not allowed because it ended at {}. Now is {}", (Object)this.endingDateTime, (Object)now);
            return false;
        }
        return this.enabled;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        DefaultRegisteredServiceAccessStrategy rhs = (DefaultRegisteredServiceAccessStrategy)obj;
        return new EqualsBuilder().append(this.enabled, rhs.enabled).append(this.ssoEnabled, rhs.ssoEnabled).append(this.requireAllAttributes, rhs.requireAllAttributes).append(this.requiredAttributes, rhs.requiredAttributes).append((Object)this.startingDateTime, (Object)rhs.startingDateTime).append((Object)this.endingDateTime, (Object)rhs.endingDateTime).append((Object)this.unauthorizedRedirectUrl, (Object)rhs.unauthorizedRedirectUrl).append(this.caseInsensitive, rhs.caseInsensitive).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.enabled).append(this.ssoEnabled).append(this.requireAllAttributes).append(this.requiredAttributes).append((Object)this.startingDateTime).append((Object)this.endingDateTime).append((Object)this.unauthorizedRedirectUrl).append(this.caseInsensitive).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("enabled", this.enabled).append("ssoEnabled", this.ssoEnabled).append("requireAllAttributes", this.requireAllAttributes).append("requiredAttributes", this.requiredAttributes).append("startingDateTime", (Object)this.startingDateTime).append("endingDateTime", (Object)this.endingDateTime).append("unauthorizedRedirectUrl", (Object)this.unauthorizedRedirectUrl).append("caseInsensitive", this.caseInsensitive).toString();
    }
}

