/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.services;

import java.util.regex.Pattern;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.services.AbstractRegisteredService;

@Entity
@DiscriminatorValue(value="regex")
public class RegexRegisteredService
extends AbstractRegisteredService {
    private static final long serialVersionUID = -8258660210826975771L;
    private transient Pattern servicePattern;

    @Override
    public void setServiceId(String id) {
        this.serviceId = id;
        this.servicePattern = null;
    }

    public boolean matches(Service service) {
        if (this.servicePattern == null) {
            this.servicePattern = this.createPattern(this.serviceId);
        }
        return service != null && this.servicePattern.matcher(service.getId()).matches();
    }

    @Override
    protected AbstractRegisteredService newInstance() {
        return new RegexRegisteredService();
    }

    private Pattern createPattern(String pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException("Pattern cannot be null.");
        }
        return Pattern.compile(pattern, 2);
    }
}

