/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.ticket.registry;

import org.jasig.cas.monitor.TicketRegistryState;
import org.jasig.cas.ticket.Ticket;
import org.jasig.cas.ticket.registry.TicketRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public abstract class AbstractTicketRegistry
implements TicketRegistry,
TicketRegistryState {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    public final <T extends Ticket> T getTicket(String ticketId, Class<? extends Ticket> clazz) {
        Assert.notNull(clazz, (String)"clazz cannot be null");
        Ticket ticket = this.getTicket(ticketId);
        if (ticket == null) {
            return null;
        }
        if (!clazz.isAssignableFrom(ticket.getClass())) {
            throw new ClassCastException("Ticket [" + ticket.getId() + " is of type " + ticket.getClass() + " when we were expecting " + clazz);
        }
        return (T)ticket;
    }

    public int sessionCount() {
        this.logger.debug("sessionCount() operation is not implemented by the ticket registry instance {}. Returning unknown as {}", (Object)this.getClass().getName(), (Object)Integer.MIN_VALUE);
        return Integer.MIN_VALUE;
    }

    public int serviceTicketCount() {
        this.logger.debug("serviceTicketCount() operation is not implemented by the ticket registry instance {}. Returning unknown as {}", (Object)this.getClass().getName(), (Object)Integer.MIN_VALUE);
        return Integer.MIN_VALUE;
    }
}

