/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.ticket.registry.support;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections4.Predicate;
import org.jasig.cas.CentralAuthenticationService;
import org.jasig.cas.logout.LogoutManager;
import org.jasig.cas.ticket.ServiceTicket;
import org.jasig.cas.ticket.Ticket;
import org.jasig.cas.ticket.TicketGrantingTicket;
import org.jasig.cas.ticket.registry.RegistryCleaner;
import org.jasig.cas.ticket.registry.TicketRegistry;
import org.jasig.cas.ticket.registry.support.LockingStrategy;
import org.jasig.cas.ticket.registry.support.NoOpLockingStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultTicketRegistryCleaner
implements RegistryCleaner {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @NotNull
    private final CentralAuthenticationService centralAuthenticationService;
    @NotNull
    private LockingStrategy lock = new NoOpLockingStrategy();
    @NotNull
    private TicketRegistry ticketRegistry;

    public DefaultTicketRegistryCleaner(CentralAuthenticationService centralAuthenticationService, TicketRegistry ticketRegistry) {
        this.centralAuthenticationService = centralAuthenticationService;
        this.ticketRegistry = ticketRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Ticket> clean() {
        try {
            this.logger.info("Beginning ticket cleanup.");
            this.logger.debug("Attempting to acquire ticket cleanup lock.");
            if (!this.lock.acquire()) {
                this.logger.info("Could not obtain lock.  Aborting cleanup.");
                List<Ticket> list = Collections.emptyList();
                return list;
            }
            this.logger.debug("Acquired lock.  Proceeding with cleanup.");
            Collection ticketsToRemove = this.centralAuthenticationService.getTickets(new Predicate(){

                public boolean evaluate(Object o) {
                    Ticket ticket = (Ticket)o;
                    return ticket.isExpired();
                }
            });
            this.logger.info("{} expired tickets found to be removed.", (Object)ticketsToRemove.size());
            try {
                for (Ticket ticket : ticketsToRemove) {
                    if (ticket instanceof TicketGrantingTicket) {
                        this.logger.debug("Cleaning up expired ticket-granting ticket [{}]", (Object)ticket.getId());
                        this.centralAuthenticationService.destroyTicketGrantingTicket(ticket.getId());
                        continue;
                    }
                    if (ticket instanceof ServiceTicket) {
                        this.logger.debug("Cleaning up expired service ticket [{}]", (Object)ticket.getId());
                        this.ticketRegistry.deleteTicket(ticket.getId());
                        continue;
                    }
                    this.logger.warn("Unknown ticket type [{} found to clean", (Object)ticket.getClass().getSimpleName());
                }
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
            Collection collection = ticketsToRemove;
            return collection;
        }
        finally {
            this.logger.debug("Releasing ticket cleanup lock.");
            this.lock.release();
            this.logger.info("Finished ticket cleanup.");
        }
    }

    @Deprecated
    public void setTicketRegistry(TicketRegistry ticketRegistry) {
        this.logger.warn("Invoking setTicketRegistry() is deprecated and has no impact.");
    }

    @Deprecated
    public void setLock(LockingStrategy strategy) {
        this.lock = strategy;
    }

    @Deprecated
    public void setLogUserOutOfServices(boolean logUserOutOfServices) {
        this.logger.warn("Invoking setLogUserOutOfServices() is deprecated and has no impact.");
    }

    @Deprecated
    public void setLogoutManager(LogoutManager logoutManager) {
        this.logger.warn("Invoking setLogoutManager() is deprecated and has no impact.");
    }
}

