/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.ticket.support;

import java.util.concurrent.TimeUnit;
import org.jasig.cas.ticket.TicketState;
import org.jasig.cas.ticket.support.AbstractCasExpirationPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public final class TicketGrantingTicketExpirationPolicy
extends AbstractCasExpirationPolicy
implements InitializingBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(TicketGrantingTicketExpirationPolicy.class);
    private static final long serialVersionUID = 7670537200691354820L;
    private long maxTimeToLiveInMilliSeconds;
    private long timeToKillInMilliSeconds;

    @Deprecated
    public TicketGrantingTicketExpirationPolicy() {
        this.maxTimeToLiveInMilliSeconds = 0L;
        this.timeToKillInMilliSeconds = 0L;
    }

    public TicketGrantingTicketExpirationPolicy(long maxTimeToLive, long timeToKill, TimeUnit timeUnit) {
        this.maxTimeToLiveInMilliSeconds = timeUnit.toMillis(maxTimeToLive);
        this.timeToKillInMilliSeconds = timeUnit.toMillis(timeToKill);
    }

    @Deprecated
    public void setMaxTimeToLiveInMilliSeconds(long maxTimeToLiveInMilliSeconds) {
        this.maxTimeToLiveInMilliSeconds = maxTimeToLiveInMilliSeconds;
    }

    @Deprecated
    public void setTimeToKillInMilliSeconds(long timeToKillInMilliSeconds) {
        this.timeToKillInMilliSeconds = timeToKillInMilliSeconds;
    }

    @Deprecated
    public void setMaxTimeToLiveInSeconds(long maxTimeToLiveInSeconds) {
        if (this.maxTimeToLiveInMilliSeconds == 0L) {
            this.maxTimeToLiveInMilliSeconds = TimeUnit.SECONDS.toMillis(maxTimeToLiveInSeconds);
        }
    }

    @Deprecated
    public void setTimeToKillInSeconds(long timeToKillInSeconds) {
        if (this.timeToKillInMilliSeconds == 0L) {
            this.timeToKillInMilliSeconds = TimeUnit.SECONDS.toMillis(timeToKillInSeconds);
        }
    }

    public void afterPropertiesSet() throws Exception {
        Assert.isTrue((this.maxTimeToLiveInMilliSeconds >= this.timeToKillInMilliSeconds ? 1 : 0) != 0, (String)"maxTimeToLiveInMilliSeconds must be greater than or equal to timeToKillInMilliSeconds.");
    }

    public boolean isExpired(TicketState ticketState) {
        long currentSystemTimeInMillis = System.currentTimeMillis();
        if (currentSystemTimeInMillis - ticketState.getCreationTime() >= this.maxTimeToLiveInMilliSeconds) {
            LOGGER.debug("Ticket is expired because the time since creation is greater than maxTimeToLiveInMilliSeconds");
            return true;
        }
        if (currentSystemTimeInMillis - ticketState.getLastTimeUsed() >= this.timeToKillInMilliSeconds) {
            LOGGER.debug("Ticket is expired because the time since last use is greater than timeToKillInMilliseconds");
            return true;
        }
        return false;
    }
}

