/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.validation;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.jasig.cas.authentication.Authentication;
import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.validation.Assertion;
import org.springframework.util.Assert;

public final class ImmutableAssertion
implements Assertion,
Serializable {
    private static final long serialVersionUID = -3348826049921010423L;
    private final Authentication primaryAuthentication;
    private final List<Authentication> chainedAuthentications;
    private final boolean fromNewLogin;
    private final Service service;

    public ImmutableAssertion(Authentication primary, List<Authentication> chained, Service service, boolean fromNewLogin) {
        Assert.notNull((Object)primary, (String)"primary authentication cannot be null");
        Assert.notNull(chained, (String)"chained authentications cannot be null");
        Assert.notNull((Object)service, (String)"service cannot be null");
        Assert.notEmpty(chained, (String)"chained authentications cannot be empty");
        this.primaryAuthentication = primary;
        this.chainedAuthentications = chained;
        this.service = service;
        this.fromNewLogin = fromNewLogin;
    }

    public Authentication getPrimaryAuthentication() {
        return this.primaryAuthentication;
    }

    public List<Authentication> getChainedAuthentications() {
        return Collections.unmodifiableList(this.chainedAuthentications);
    }

    public boolean isFromNewLogin() {
        return this.fromNewLogin;
    }

    public Service getService() {
        return this.service;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Assertion)) {
            return false;
        }
        Assertion a = (Assertion)o;
        return this.primaryAuthentication.equals(a.getPrimaryAuthentication()) && this.chainedAuthentications.equals(a.getChainedAuthentications()) && this.service.equals(a.getService()) && this.fromNewLogin == a.isFromNewLogin();
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder(15, 11);
        builder.append((Object)this.primaryAuthentication);
        builder.append(this.chainedAuthentications);
        builder.append((Object)this.service);
        builder.append(this.fromNewLogin);
        return builder.toHashCode();
    }

    public String toString() {
        return this.primaryAuthentication.toString() + ':' + this.service.toString();
    }
}

