/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.web.flow;

import javax.validation.constraints.NotNull;
import org.jasig.cas.CentralAuthenticationService;
import org.jasig.cas.authentication.AuthenticationException;
import org.jasig.cas.authentication.Credential;
import org.jasig.cas.authentication.principal.DefaultPrincipalFactory;
import org.jasig.cas.authentication.principal.PrincipalFactory;
import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.authentication.principal.WebApplicationService;
import org.jasig.cas.ticket.ServiceTicket;
import org.jasig.cas.ticket.TicketException;
import org.jasig.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public abstract class AbstractNonInteractiveCredentialsAction
extends AbstractAction {
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected PrincipalFactory principalFactory = new DefaultPrincipalFactory();
    @NotNull
    private CentralAuthenticationService centralAuthenticationService;

    protected final boolean isRenewPresent(RequestContext context) {
        return StringUtils.hasText((String)context.getRequestParameters().get("renew"));
    }

    protected final Event doExecute(RequestContext context) {
        Credential credential = this.constructCredentialsFromRequest(context);
        if (credential == null) {
            return this.error();
        }
        String ticketGrantingTicketId = WebUtils.getTicketGrantingTicketId(context);
        WebApplicationService service = WebUtils.getService(context);
        if (this.isRenewPresent(context) && ticketGrantingTicketId != null && service != null) {
            try {
                ServiceTicket serviceTicketId = this.centralAuthenticationService.grantServiceTicket(ticketGrantingTicketId, (Service)service, new Credential[]{credential});
                WebUtils.putServiceTicketInRequestScope(context, serviceTicketId);
                return this.result("warn");
            }
            catch (AuthenticationException e) {
                this.onError(context, credential);
                return this.error();
            }
            catch (TicketException e) {
                this.centralAuthenticationService.destroyTicketGrantingTicket(ticketGrantingTicketId);
                this.logger.debug("Attempted to generate a ServiceTicket using renew=true with different credential", (Throwable)e);
            }
        }
        try {
            WebUtils.putTicketGrantingTicketInScopes(context, this.centralAuthenticationService.createTicketGrantingTicket(new Credential[]{credential}));
            this.onSuccess(context, credential);
            return this.success();
        }
        catch (Exception e) {
            this.onError(context, credential);
            return this.error();
        }
    }

    public CentralAuthenticationService getCentralAuthenticationService() {
        return this.centralAuthenticationService;
    }

    public final void setCentralAuthenticationService(CentralAuthenticationService centralAuthenticationService) {
        this.centralAuthenticationService = centralAuthenticationService;
    }

    public void setPrincipalFactory(PrincipalFactory principalFactory) {
        this.principalFactory = principalFactory;
    }

    protected void onError(RequestContext context, Credential credential) {
    }

    protected void onSuccess(RequestContext context, Credential credential) {
    }

    protected abstract Credential constructCredentialsFromRequest(RequestContext var1);
}

