/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.audit.spi;

import javax.validation.constraints.NotNull;
import org.aspectj.lang.JoinPoint;
import org.jasig.cas.CentralAuthenticationService;
import org.jasig.cas.audit.spi.PrincipalIdProvider;
import org.jasig.cas.authentication.Authentication;
import org.jasig.cas.authentication.Credential;
import org.jasig.cas.ticket.InvalidTicketException;
import org.jasig.cas.ticket.ServiceTicket;
import org.jasig.cas.ticket.Ticket;
import org.jasig.cas.ticket.TicketGrantingTicket;
import org.jasig.cas.ticket.registry.TicketRegistry;
import org.jasig.cas.util.AopUtils;
import org.jasig.inspektr.common.spi.PrincipalResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;

public final class TicketOrCredentialPrincipalResolver
implements PrincipalResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(TicketOrCredentialPrincipalResolver.class);
    private PrincipalIdProvider principalIdProvider = new DefaultPrincipalIdProvider();
    @NotNull
    private final CentralAuthenticationService centralAuthenticationService;

    @Deprecated
    public TicketOrCredentialPrincipalResolver(TicketRegistry ticketRegistry) {
        LOGGER.warn("The constructor is deprecated and will be removed. Consider an alternate constructor");
        this.centralAuthenticationService = null;
    }

    public TicketOrCredentialPrincipalResolver(CentralAuthenticationService centralAuthenticationService) {
        this.centralAuthenticationService = centralAuthenticationService;
    }

    public String resolveFrom(JoinPoint joinPoint, Object retVal) {
        return this.resolveFromInternal(AopUtils.unWrapJoinPoint(joinPoint));
    }

    public String resolveFrom(JoinPoint joinPoint, Exception retVal) {
        return this.resolveFromInternal(AopUtils.unWrapJoinPoint(joinPoint));
    }

    public String resolve() {
        return "audit:unknown";
    }

    protected String resolveFromInternal(JoinPoint joinPoint) {
        StringBuilder builder = new StringBuilder();
        Object arg1 = joinPoint.getArgs()[0];
        if (arg1.getClass().isArray()) {
            Object[] args1AsArray;
            for (Object arg : args1AsArray = (Object[])arg1) {
                builder.append(this.resolveArgument(arg));
            }
        } else {
            builder.append(this.resolveArgument(arg1));
        }
        return builder.toString();
    }

    private String resolveArgument(Object arg1) {
        LOGGER.debug("Resolving argument [{}] for audit", (Object)arg1.getClass().getSimpleName());
        if (arg1 instanceof Credential) {
            return arg1.toString();
        }
        if (arg1 instanceof String) {
            try {
                Ticket ticket = this.centralAuthenticationService.getTicket((String)arg1, Ticket.class);
                if (ticket instanceof ServiceTicket) {
                    ServiceTicket serviceTicket = (ServiceTicket)ticket;
                    return serviceTicket.getGrantingTicket().getAuthentication().getPrincipal().getId();
                }
                if (ticket instanceof TicketGrantingTicket) {
                    TicketGrantingTicket tgt = (TicketGrantingTicket)ticket;
                    return tgt.getAuthentication().getPrincipal().getId();
                }
            }
            catch (InvalidTicketException e) {
                LOGGER.trace(e.getMessage(), (Throwable)e);
            }
            LOGGER.debug("Could not locate ticket [{}] in the registry", arg1);
        } else {
            org.springframework.security.core.Authentication authentication;
            SecurityContext securityContext = SecurityContextHolder.getContext();
            if (securityContext != null && (authentication = securityContext.getAuthentication()) != null) {
                return ((UserDetails)authentication.getPrincipal()).getUsername();
            }
        }
        LOGGER.debug("Unable to determine the audit argument. Returning [{}]", (Object)"audit:unknown");
        return "audit:unknown";
    }

    public void setPrincipalIdProvider(PrincipalIdProvider principalIdProvider) {
        this.principalIdProvider = principalIdProvider;
    }

    public PrincipalIdProvider getPrincipalIdProvider() {
        return this.principalIdProvider;
    }

    static class DefaultPrincipalIdProvider
    implements PrincipalIdProvider {
        DefaultPrincipalIdProvider() {
        }

        @Override
        public String getPrincipalIdFrom(Authentication authentication) {
            return authentication.getPrincipal().toString();
        }
    }
}

