/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.authentication.principal;

import java.util.List;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.jasig.cas.authentication.Credential;
import org.jasig.cas.authentication.principal.Principal;
import org.jasig.cas.authentication.principal.PrincipalResolver;

public class ChainingPrincipalResolver
implements PrincipalResolver {
    @NotNull
    @Size(min=1)
    private List<PrincipalResolver> chain;

    public void setChain(List<PrincipalResolver> chain) {
        this.chain = chain;
    }

    public Principal resolve(Credential credential) {
        Principal result = null;
        Credential input = credential;
        for (PrincipalResolver resolver : this.chain) {
            if (result != null) {
                input = new IdentifiableCredential(result.getId());
            }
            result = resolver.resolve(input);
        }
        return result;
    }

    public boolean supports(Credential credential) {
        return this.chain.get(0).supports(credential);
    }

    static class IdentifiableCredential
    implements Credential {
        private final String id;

        IdentifiableCredential(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }
    }
}

