/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.monitor;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.validation.constraints.NotNull;
import org.jasig.cas.monitor.AbstractNamedMonitor;
import org.jasig.cas.monitor.PoolStatus;
import org.jasig.cas.monitor.StatusCode;

public abstract class AbstractPoolMonitor
extends AbstractNamedMonitor<PoolStatus> {
    public static final int DEFAULT_MAX_WAIT = 3000;
    private int maxWait = 3000;
    @NotNull
    private ExecutorService executor;

    public void setExecutor(ExecutorService executorService) {
        this.executor = executorService;
    }

    public void setMaxWait(int time) {
        this.maxWait = time;
    }

    public PoolStatus observe() {
        StatusCode code;
        Future<StatusCode> result = this.executor.submit(new Validator(this));
        String description = null;
        try {
            code = result.get(this.maxWait, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            code = StatusCode.UNKNOWN;
            description = "Validator thread interrupted during pool validation.";
        }
        catch (TimeoutException e) {
            code = StatusCode.WARN;
            description = String.format("Pool validation timed out.  Max wait is %s ms.", this.maxWait);
        }
        catch (Exception e) {
            code = StatusCode.ERROR;
            description = e.getMessage();
        }
        return new PoolStatus(code, description, this.getActiveCount(), this.getIdleCount());
    }

    protected abstract StatusCode checkPool() throws Exception;

    protected abstract int getIdleCount();

    protected abstract int getActiveCount();

    private static class Validator
    implements Callable<StatusCode> {
        private final AbstractPoolMonitor monitor;

        Validator(AbstractPoolMonitor monitor) {
            this.monitor = monitor;
        }

        @Override
        public StatusCode call() throws Exception {
            return this.monitor.checkPool();
        }
    }
}

