/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.services;

import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.jasig.cas.authentication.principal.PersistentIdGenerator;
import org.jasig.cas.authentication.principal.Principal;
import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.authentication.principal.ShibbolethCompatiblePersistentIdGenerator;
import org.jasig.cas.services.RegisteredServiceUsernameAttributeProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AnonymousRegisteredServiceUsernameAttributeProvider
implements RegisteredServiceUsernameAttributeProvider {
    private static final long serialVersionUID = 7050462900237284803L;
    private static final Logger LOGGER = LoggerFactory.getLogger(AnonymousRegisteredServiceUsernameAttributeProvider.class);
    @NotNull
    private final PersistentIdGenerator persistentIdGenerator;

    public AnonymousRegisteredServiceUsernameAttributeProvider() {
        this(new ShibbolethCompatiblePersistentIdGenerator());
    }

    public AnonymousRegisteredServiceUsernameAttributeProvider(@NotNull PersistentIdGenerator persistentIdGenerator) {
        this.persistentIdGenerator = persistentIdGenerator;
    }

    public PersistentIdGenerator getPersistentIdGenerator() {
        return this.persistentIdGenerator;
    }

    public String resolveUsername(Principal principal, Service service) {
        String id = this.persistentIdGenerator.generate(principal, service);
        LOGGER.debug("Resolved username [{}] for anonymous access", (Object)id);
        return id;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        AnonymousRegisteredServiceUsernameAttributeProvider rhs = (AnonymousRegisteredServiceUsernameAttributeProvider)obj;
        return this.persistentIdGenerator.equals(rhs.persistentIdGenerator);
    }

    public int hashCode() {
        return new HashCodeBuilder(13, 113).toHashCode();
    }
}

